/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef SMILELABEL_H
#define SMILELABEL_H

#include <QLabel>
#include <QString>
#include <QMovie>
#include <QMouseEvent>

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class SmileLabel : public QLabel
{
  Q_OBJECT
  private:
    QMovie*     m_movie;
    QString     m_filename;
    QStringList m_smileStrings;
    bool        m_inited;

  public:
    SmileLabel(QWidget *parent = 0);
    ~SmileLabel();

    bool inited() const {return m_inited;}
    bool load        (const QString &);
    void setSmileText(const QStringList & list);

    void setFilename (const QString & fname)
    { m_inited = (!(m_filename = fname).isEmpty() && !m_smileStrings.isEmpty () && m_movie->isValid()); }

  protected:
    void mousePressEvent(QMouseEvent * ev) { if(m_inited) emit clicked(m_smileStrings[0]); ev->accept(); }

  signals:
    void clicked(const QString &);
};

#endif
