/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Fri Jul 12 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef TRANSACTION_LIST_H
#define TRANSACTION_LIST_H


#include <qlistview.h>
#include <qsimplerichtext.h>
#include <string>
#include "../prg/transaction.h"
#include "../prg/refpointer.h"


#define TRANSACTION_LISTVIEW_COLUMNS 7

class TransactionListView;
class TransactionListViewItem;
class KBanking;


class TransactionListViewItem: public QListViewItem {
private:
  bool _isNew;
  bool _needUpdate;
  RefPointer<Transaction> _transaction;
  QSimpleRichText *_cell[TRANSACTION_LISTVIEW_COLUMNS];
  int _ht;
  std::string _colour;

  void _populate(bool isCurrent);

public:
  TransactionListViewItem(TransactionListView *parent,
                          RefPointer<Transaction> t);
  TransactionListViewItem(TransactionListView *parent,
                          QListViewItem *after,
                          RefPointer<Transaction> t);
  TransactionListViewItem(const TransactionListViewItem &item);

  virtual ~TransactionListViewItem();

  RefPointer<Transaction> getTransaction();

  virtual void paintCell(QPainter * p,
                         const QColorGroup & cg,
                         int column,
                         int width,
                         int align);
  virtual int width(const QFontMetrics &,
                    const QListView *,
                    int column) const;
  virtual void setup();
  virtual QString key(int column, bool ascending) const;

  void redrawItem(bool sel);

  void setColour(const QString &c);

  bool needUpdate();
};



class TransactionListView: public QListView {
  Q_OBJECT
private:
  bool _shortList;
  KBanking *_app;
  bool _needUpdate;
  uint32_t _lastSessionId;
  int _modify;
public:
  TransactionListView(KBanking *kb,
                      bool shortList,
                      QWidget *parent=0, const char *name=0);
  TransactionListView(bool shortList,
                      QWidget *parent=0, const char *name=0);
  TransactionListView(QWidget *parent=0, const char *name=0);
  TransactionListView(KBanking *app,
                      const std::list<RefPointer<Transaction> > l,
                      bool shortList,
                      QWidget* parent,
                      const char* name,
                      WFlags fl);

  virtual ~TransactionListView();

  void addTransaction(RefPointer<Transaction> t);
  void addTransactions(const std::list<RefPointer<Transaction> > &ts);

  RefPointer<Transaction> getCurrentTransaction();
  std::list<RefPointer<Transaction> > getSelectedTransactions();

  void redrawSelected();

  bool isShortList() const;
  void setShortList(bool b);

  uint32_t getLastSessionId() const;
  void setLastSessionId(uint32_t sess);

  KBanking *app() const { return _app;};
  void setApp(KBanking *app) { _app=app; };

  void beginModify();
  void endModify();
  bool isModifying();

  void updateAll();

public slots:
  void slotHeaderChanged(int section,
                         int oldSize,
                         int newSize);

};



#endif //TRANSACTION_LIST_H







