/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: datedxferview.h 277 2005-08-24 16:52:02Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/



#ifndef KBANKING_DATEDTRANSFERVIEW_H
#define KBANKING_DATEDTRANSFERVIEW_H

#include "datedxferview.ui.h"

#include <qwidget.h>

#include <aqbanking/job.h>

class DatedTransferView;
class KBanking;


#include "transferlist.h"


class DatedTransferView: public DatedTransferViewUi {
  Q_OBJECT
public:
  DatedTransferView(KBanking *app,
                    QWidget* parent=0, const char* name=0, WFlags fl=0);
  virtual ~DatedTransferView();

  bool init();
  bool fini();

protected:
  void closeEvent(QCloseEvent *e);

private:
  KBanking *_app;
  TransferListView *_xaList;

  AB_JOB *_newDatedXferJob(AB_JOB_TYPE jt,
                           RefPointer<Transfer> tmpl=0);
  void _createDatedTransfer(RefPointer<Transfer> tmpl=0);
  void _modifyDatedTransfer(RefPointer<Transfer> tmpl=0);

public slots:
  void slotUpdated();
  void slotDetails();
  void slotNewDatedTransfer();
  void slotModifyDatedTransfer();
  void slotDeleteDatedTransfer();
};










#endif /* KBANKING_DATEDTRANSFERVIEW_H */



