/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: ktimport.h 433 2008-01-12 08:58:57Z martin $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQHBCI_KDE_TIMPORT_H
#define AQHBCI_KDE_TIMPORT_H


class KBanking;


#include "timport.h"


class KTransactionImporter: public TransactionImporter {
public:
  KTransactionImporter(KBanking *kb,
                       AB_IMEXPORTER_CONTEXT *ctx,
                       uint32_t flags);
  virtual ~KTransactionImporter();

  virtual Account *askUserForAccount(const std::string &bankCode,
				     const std::string &accountNumber,
				     const std::string &accountName);
  virtual GWEN_TIME *askUserForDate(const Transaction *t,
                                    const GWEN_TIME *lastDate);

  virtual DupeCheckResult
    askUserForDuplicate(Account *a,
                        RefPointer<Transaction> tnew,
                        RefPointer<Transaction> told,
                        const std::list<RefPointer<Transaction> > &dnl,
                        const std::list<RefPointer<Transaction> > &dol,
                        bool &dontAskAgain);

  virtual Payee *askUserForPayee(RefPointer<Transaction> t,
                                 bool &aborted,
                                 bool &askNoMore);

  virtual Category *askUserForCategory(RefPointer<Transaction> t,
                                       bool &aborted,
                                       bool &askNoMore);
  virtual bool
    presentTransactionsToUser(std::list<RefPointer<Transaction> > &toAdd,
                              std::list<RefPointer<Transaction> > &toDel);

private:
  KBanking *_kb;
};












#endif // AQHBCI_KDE_TIMPORT_H

