/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: editcategory.cpp 328 2005-09-20 12:42:22Z cstim $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "category.h"
#include "categorylist.h"
#include "editcategory.h"
#include "ruleeditor.h"
#include "kbanking.h"

#include <qlineedit.h>
#include <qlistview.h>
#include <qtimer.h>
#include <qmessagebox.h>



EditCategory::EditCategory(KBanking *kb,
                           Category *cat,
                           Category *parentCat,
                           bool isCreate,
                           QWidget* parent,
                           const char* name,
                           bool modal,
                           WFlags fl)
:EditCategoryUi(parent, name, modal, fl)
,_app(kb)
,_category(cat)
,_parentCategory(parentCat)
,_isCreate(isCreate){

  categoryList->setSelectionMode(QListView::Single);
  categoryList->setAllColumnsShowFocus(true);
  categoryList->setRootIsDecorated(true);

  nameEdit->setText(QString::fromUtf8(cat->getName().c_str()));
  descrEdit->setText(QString::fromUtf8(cat->getDescription().c_str()));
  ruleEditor->init(kb, cat->getRules(), false, 0);

  /*QTimer::singleShot(0, this, SLOT(adjustSize())); */

}



EditCategory::~EditCategory() {
}



bool EditCategory::init() {
  GWEN_DB_NODE *db;

  db=_app->getAppData();
  if (db) {
    db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                        "gui/dlgs/EditCategory");
    if (db) {
      GWEN_DB_NODE *dbT;
      int w, h;

      w=GWEN_DB_GetIntValue(db, "width", 0, 640);
      h=GWEN_DB_GetIntValue(db, "height", 0, 480);
      resize(w, h);

      dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "categoryList");
      if (dbT) {
        const char *p;
        int i, j;

        /* found settings */
        i=GWEN_DB_GetIntValue(dbT, "sortColumn", 0, -1);
        if (i!=-1)
          categoryList->setSortColumn(i);
        p=GWEN_DB_GetCharValue(dbT, "sortOrder", 0, "ascending");
        if (p) {
          if (strcasecmp(p, "ascending")==0)
            categoryList->setSortOrder(Qt::Ascending);
          else
            if (strcasecmp(p, "descending")==0)
              categoryList->setSortOrder(Qt::Descending);
        }
        for (i=0; i<categoryList->columns(); i++) {
          categoryList->setColumnWidthMode(i, QListView::Manual);
          j=GWEN_DB_GetIntValue(dbT, "columns", i, -1);
          if (j!=-1)
            categoryList->setColumnWidth(i, j);
        } /* for */
      } // if category list data

    }
  }

  categoryList->beginModify();
  categoryList->addCategories(_app->getCategories(),
                              _category->getId().c_str());
  categoryList->expandAll();
  if (_parentCategory) {
    categoryList->selectCategory(_parentCategory->getId().c_str(), true);
  }
  categoryList->endModify();

  return true;
}



bool EditCategory::fini() {
  GWEN_DB_NODE *db;
  GWEN_DB_NODE *dbT;
  int i, j;

  db=_app->getAppData();
  assert(db);
  db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                      "gui/dlgs/EditCategory");
  assert(db);
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                      "width", width());
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                      "height", height());

  // store category list info
  dbT=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS, "categoryList");
  GWEN_DB_SetIntValue(dbT, GWEN_DB_FLAGS_DEFAULT,
                      "sortColumn", categoryList->sortColumn());
  switch(categoryList->sortOrder()) {
  case Qt::Ascending:
    GWEN_DB_SetCharValue(dbT, GWEN_DB_FLAGS_OVERWRITE_VARS,
                         "sortOrder", "ascending");
    break;
  case Qt::Descending:
    GWEN_DB_SetCharValue(dbT, GWEN_DB_FLAGS_OVERWRITE_VARS,
                         "sortOrder", "descending");
    break;
  default:
    break;
  }
  GWEN_DB_DeleteVar(dbT, "columns");
  for (i=0; i<categoryList->columns(); i++) {
    j=categoryList->columnWidth(i);
    GWEN_DB_SetIntValue(dbT, GWEN_DB_FLAGS_DEFAULT,
                        "columns", j);
  } /* for */

  return true;
}



void EditCategory::accept() {
  QString qs;

  qs=nameEdit->text();
  if (qs.isEmpty()) {
    QMessageBox::critical(this,
                          tr("Invalid Input"),
                          tr("<qt>"
                             "Please enter a name for this category."
                             "</qt>"),
                          tr("Dismiss"), QString::null);
    return;
  }
  if (!getParentCategory()) {
    QMessageBox::critical(this,
                          tr("No Parent"),
                          tr("<qt>"
                             "Please select a parent for this category."
                             "</qt>"),
                          tr("Dismiss"), QString::null);
    return;
  }

  _category->setName(KBanking::QStringToUtf8String(qs));
  qs=descrEdit->text();
  if (!qs.isEmpty())
    _category->setDescription(KBanking::QStringToUtf8String(qs));
  _category->setRules(ruleEditor->getRules());
  EditCategoryUi::accept();
}



Category *EditCategory::getParentCategory() {
  std::list<Category*> cats=categoryList->getSelectedCategories();
  if (cats.empty()) {
    DBG_ERROR(0, "No categories selected");
    return 0;
  }
  return cats.front();
}



Category *EditCategory::createCategory(KBanking *kb, QWidget *parent) {
  Category *cat;
  std::string s;

  s=QBanking::QStringToUtf8String(tr("New Category"));
  cat=new Category("0", s.c_str(), "", 0);
  EditCategory w(kb, cat, 0, true, parent, "EditCategory", true);

  w.setCaption(tr("Create Category"));
  if (!w.init()) {
    delete cat;
    return 0;
  }
  if (w.exec()==QDialog::Accepted) {
    DBG_INFO(0, "Adding category");
    kb->addCategory(cat, w.getParentCategory());
    w.fini();
    return cat;
  }
  else {
    DBG_INFO(0, "Rejected");
    w.fini();
    delete cat;
  }

  return 0;
}



bool EditCategory::editCategory(KBanking *kb,
                                Category *cat,
                                QWidget *parent) {
  std::string s;
  Category *parentCat;

  parentCat=cat->getParent();
  /* unlink temporarily */
  EditCategory w(kb, cat, parentCat, false, parent, "EditCategory", true);

  w.setCaption(tr("Edit Category"));
  if (!w.init()) {
    return false;
  }

  if (w.exec()==QDialog::Accepted) {
    Category *newParentCat;

    newParentCat=w.getParentCategory();
    if (parentCat!=newParentCat) {
      DBG_ERROR(0, "Reparenting category");
      kb->reparentCategory(cat, newParentCat);
    }
    else {
      DBG_ERROR(0, "Not reparenting category");
    }
    w.fini();
    return true;
  }
  else {
    DBG_INFO(0, "Rejected");
    w.fini();
    return false;
  }
}



bool EditCategory::editNewCategory(KBanking *kb,
                                   Category *cat,
                                   QWidget *parent) {
  std::string s;
  Category *parentCat;

  parentCat=cat->getParent();
  EditCategory w(kb, cat, 0, true, parent, "EditCategory", true);

  w.setCaption(tr("Create Category"));
  if (!w.init())
    return 0;
  if (w.exec()==QDialog::Accepted) {
    DBG_INFO(0, "Adding category");
    if (!kb->addCategory(cat, w.getParentCategory())) {
      DBG_ERROR(0, "Could not add category");
      QMessageBox::critical(parent,
                            tr("Error"),
                            tr("Error adding the category. "
                               "Please see console log."),
                            tr("Dismiss"), QString::null);
      w.fini();
      return false;
    }
    w.fini();
    return true;
  }
  else {
    DBG_INFO(0, "Rejected");
    w.fini();
    return false;
  }
}







