/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: editaccount.cpp 330 2005-10-02 14:05:27Z cstim $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "editaccount.h"
#include <qbanking/qbselectbank.h>
#include "kbanking.h"

#include <qlineedit.h>
#include <qcheckbox.h>
#include <qpushbutton.h>



EditAccount::EditAccount(KBanking *app,
                         Account *a,
                         bool isCreate,
                         QWidget* parent,
                         const char* name,
                         bool modal,
                         WFlags fl)
:EditAccountUi(parent, name, modal, fl)
,_account(a)
,_isCreate(isCreate) {

  accountNameEdit
    ->setText(QString::fromUtf8(a->getAccountName().c_str()));
  accountNumberEdit
    ->setText(QString::fromUtf8(a->getAccountNumber().c_str()));
  bankNameEdit
    ->setText(QString::fromUtf8(a->getBankName().c_str()));
  bankCodeEdit
    ->setText(QString::fromUtf8(a->getBankCode().c_str()));
  ownerEdit
    ->setText(QString::fromUtf8(a->getOwnerName().c_str()));

  updateTransactionsCheck->setChecked(a->getOptionUpdateTransactions());
  updateBalanceCheck->setChecked(a->getOptionUpdateBalance());
  updateStandingOrdersCheck->setChecked(a->getOptionUpdateStandingOrders());
  updateDatedTransfersCheck->setChecked(a->getOptionUpdateDatedTransfers());
  updatePendingCheck->setChecked(a->getOptionUpdatePending());
  excludeFromAllCheck->setChecked(a->getOptionExcludeFromGlobalCall());

  bankCodeEdit->setEnabled(_isCreate);
  accountNumberEdit->setEnabled(_isCreate);
  bankCodeButton->setEnabled(_isCreate);

  QObject::connect(bankCodeButton, SIGNAL(clicked()),
                   this, SLOT(slotBankCode()));
}



EditAccount::~EditAccount() {
}




void EditAccount::accept() {
  QString qs;

  qs=bankCodeEdit->text();
  if (!qs.isEmpty())
    _account->setBankCode(KBanking::QStringToUtf8String(qs));

  qs=accountNumberEdit->text();
  if (!qs.isEmpty())
    _account->setAccountNumber(KBanking::QStringToUtf8String(qs));

  qs=bankNameEdit->text();
  if (!qs.isEmpty())
    _account->setBankName(KBanking::QStringToUtf8String(qs));

  qs=accountNameEdit->text();
  if (!qs.isEmpty())
    _account->setAccountName(KBanking::QStringToUtf8String(qs));

  qs=ownerEdit->text();
  if (!qs.isEmpty())
    _account->setOwnerName(KBanking::QStringToUtf8String(qs));

  _account->setOptionUpdateTransactions(updateTransactionsCheck->isChecked());
  _account->setOptionUpdateBalance(updateBalanceCheck->isChecked());
  _account->setOptionUpdateStandingOrders(updateStandingOrdersCheck->isChecked());
  _account->setOptionUpdateDatedTransfers(updateDatedTransfersCheck->isChecked());
  _account->setOptionUpdatePending(updatePendingCheck->isChecked());
  _account->setOptionExcludeFromGlobalCall(excludeFromAllCheck->isChecked());

  EditAccountUi::accept();
}



void EditAccount::reject() {
  return EditAccountUi::reject();
}



void EditAccount::slotBankCode() {
  AB_BANKINFO *bi;

  bi=QBSelectBank::selectBank(_app,
                              this,
                              tr("Select a Bank"),
                              QString("de"),
                              bankCodeEdit->text());
  if (bi) {
    const char *s;

    s=AB_BankInfo_GetBankId(bi);
    if (s)
      bankCodeEdit->setText(QString::fromUtf8(s));
    s=AB_BankInfo_GetBankName(bi);
    if (s)
      bankNameEdit->setText(QString::fromUtf8(s));
    s=AB_BankInfo_GetLocation(bi);
    AB_BankInfo_free(bi);
  }
}



QString EditAccount::_tr(const char * sourceText) {
  QString qs;
  int i;

  qs=tr(sourceText);
  i=qs.find('|');
  if (i) {
    qs=qs.mid(i+1);
  }
  return qs;
}








