#include <stdio.h>
#include <stdlib.h>
#include <qobject.h>
#include <qstring.h>
#include <qwaitcondition.h>
#include <alsa/asoundlib.h>
#include <jack/jack.h>
#include "recdata.h"

RecData::RecData(QString p_pcmName, unsigned long p_ringBufSize, QObject *parent) : QObject(parent) {

  pcmName = p_pcmName;
  wavDataSize = 0;  
  writeOfs = 0;
  readOfs = 0;
  validByteCount = 0;
  maxValidByteCount = 0;
  doRecord = false;
  doCapture = false;
  pauseFlag = false;
  newMax = false;
  enableJack = false;
  jackRunning = false;
  max[0] = 0;
  max[1] = 0;
  midiChannel = 0;
  midiNote = 0;
  frameCounter = 0;
  rate = DEFAULT_RATE;
  periodsize = DEFAULT_PERIODSIZE;
  periods = DEFAULT_PERIODS;
  channels = DEFAULT_CHANNELS;
  framesize = DEFAULT_SAMPLESIZE * DEFAULT_CHANNELS;
  ringBufSize = p_ringBufSize;
  ringBuf = (unsigned char *)malloc(ringBufSize);
}

RecData::~RecData() {

  free(ringBuf);
}

int RecData::initJack() {

  int l1;

  if ((jack_handle = jack_client_new("qaRecord")) == 0) {
    fprintf(stderr, "jack server not running ?\n");
    exit(1);
  }
  for (l1 = 0; l1 < 2; l1++) {
    jackdata[l1] = (jack_default_audio_sample_t *)malloc(MAX_JACK_FRAMES * sizeof(jack_default_audio_sample_t));
  }
  jack_set_process_callback(jack_handle, capture_callback, (void *)this);
  rate = jack_get_sample_rate(jack_handle);
  jack_in[0] = jack_port_register(jack_handle, "In_0", JACK_DEFAULT_AUDIO_TYPE, JackPortIsInput, 0);
  jack_in[1] = jack_port_register(jack_handle, "In_1", JACK_DEFAULT_AUDIO_TYPE, JackPortIsInput, 0);
  return(0);  
}
 
int RecData::activateJack() {

  jackRunning = true;
  if (jack_activate(jack_handle)) {
    fprintf(stderr, "cannot activate client");
  }
  validByteCount = 0;
  writeOfs = 0;
  jmax[0] = 0;
  jmax[1] = 0;
  return(0);
}

int RecData::deactivateJack() {

  if (jackRunning) {
    jackRunning = false;
    if (jack_deactivate(jack_handle)) {
      fprintf(stderr, "cannot deactivate client");
    }
  }
  return(0);
}  


int RecData::capture_callback(jack_nframes_t nframes, void *arg) {

  RecData *rd;

  rd = (RecData *)arg;
  return(rd->jack_capture(nframes));
}

int RecData::jack_capture(jack_nframes_t nframes) {

  int l1, l2, i;
  jack_default_audio_sample_t *buf[2];
  short s;

  if (nframes > MAX_JACK_FRAMES) {
    fprintf(stderr, "nframes > %d\n", MAX_JACK_FRAMES);
  } else {
    for (l1 = 0; l1 < 2; l1++) {  
      buf[l1] = (jack_default_audio_sample_t *)jack_port_get_buffer(jack_in[l1], nframes);
      memcpy(jackdata[l1], buf[l1], sizeof(jack_default_audio_sample_t) * nframes);
    }    
    if (samplesize == 2) {
      for (l2 = 0; l2 < nframes; l2++) { 
        for (l1 = 0; l1 < 2; l1++) {
          s = (short)(32767.0 * jackdata[l1][l2]);
          if (abs(s) > jmax[l1]) jmax[l1] = abs(s);
          ringBuf[writeOfs++] = (unsigned char)s;
          ringBuf[writeOfs++] = s >> 8;
          if (writeOfs >= ringBufSize) writeOfs -= ringBufSize;
        }
      }
    } else {
      for (l2 = 0; l2 < nframes; l2++) {
        for (l1 = 0; l1 < 2; l1++) {
          i = (int)(2147483647.0 * jackdata[l1][l2]);
          if (abs(i) > jmax[l1]) jmax[l1] = abs(i);
          ringBuf[writeOfs++] = (unsigned char)i;  
          ringBuf[writeOfs++] = i >> 8;
          ringBuf[writeOfs++] = i >> 16;
          ringBuf[writeOfs++] = i >> 24;
          if (writeOfs >= ringBufSize) writeOfs -= ringBufSize;
        }
      }
    }  
    if (newMax) {
      newMax = false;
      max[0] = jmax[0];
      max[1] = jmax[1];
      jmax[0] = 0;  
      jmax[1] = 0;  
    }
    if (doRecord) {
      validByteCount += nframes * framesize;
      if (validByteCount > maxValidByteCount) {
        maxValidByteCount = validByteCount;
      }
    }  
    if (writeOfs >= ringBufSize) writeOfs -= ringBufSize;
    frameCounter += nframes;
    if (frameCounter >= 4096) {
      waitForData.wakeOne();
      frameCounter = 0;
    }
  } 
  return(0);
}

int RecData::setSamplesize(int size) {

  samplesize = size;
  framesize = samplesize * DEFAULT_CHANNELS;
  return 0;
}
