#ifndef METER_H
#define METER_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <qwidget.h>
#include <qstring.h>
#include <qlabel.h>
#include <qtimer.h>
#include <qsizepolicy.h>
#include <qsize.h>
#include "recdata.h"

#define METER_MINIMUM_WIDTH        300
#define METER_MINIMUM_HEIGHT        45
#define METER_OVER               32000
#define METER_OVER32        2097152000
#define METER_OVER_WIDTH            30
#define METER_MINDB                -85
#define METER_TICK_WIDTH            25

enum tickType { TICK_UP, TICK_DOWN };

class Meter : public QWidget
{
  Q_OBJECT

  private:
    RecData *recdata;
    int *maxRef;
    int globalMax, globalMaxResetCount;
    QTimer *timer;
    tickType tick;

  protected:
    virtual void paintEvent(QPaintEvent *);
    virtual void resizeEvent (QResizeEvent* );            
    
  public:
    Meter(tickType p_tick, RecData *p_recdata, int *p_maxRef, QWidget* parent=0, const char *name=0);
    ~Meter();
    virtual QSize sizeHint() const;
    virtual QSizePolicy sizePolicy() const;

  public slots: 
    void updateMeter();
    void resetGlobalMax();
};
  
#endif
