/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEPLOTDIALOG_H
#define QALCULATEPLOTDIALOG_H

#include <kdialogbase.h>
#include <qmap.h>
#include <qstring.h>

class KLineEdit;
class QCheckBox;
class QRadioButton;
class QSpinBox;
class QButtonGroup;
class KComboBox;
class QPushButton;
class QTabWidget;
class KListView;
class QLabel;
class QListViewItem;
class QalculateExpressionEdit;

#include "qalculate_kde_utils.h"

/**
@author Niklas Knutsson
*/
class QalculatePlotDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculatePlotDialog(QWidget *parent = 0, const char *name = 0);
	virtual ~QalculatePlotDialog();

	QLabel *xVariableLabel;
	KLineEdit *seriesTitleEdit, *xVariableEdit, *minEdit, *maxEdit, *stepSizeEdit, *titleEdit, *xLabelEdit, *yLabelEdit;
	QalculateExpressionEdit *expressionEdit;
	QCheckBox *rowsButton, *gridButton, *fullBorderButton, *logXButton, *logYButton;
	QRadioButton *functionButton, *vectorMatrixButton, *pairedMatrixButton, *primaryButton, *secondaryButton, *samplingRateButton, *stepSizeButton, *colorButton, *monochromeButton;
	QSpinBox *samplingRateBox, *logXBox, *logYBox;
	QButtonGroup *typeGroup, *rangeGroup;
	KComboBox *styleCombo, *smoothingCombo, *legendPlacementCombo;
	QPushButton *addButton, *modifyButton, *removeButton, *applyRangeButton, *applyAppearanceButton;
	QTabWidget *tabs;
	KListView *seriesView;

	bool generatePlot(PlotParameters &pp, vector<MathStructure> &y_vectors, vector<MathStructure> &x_vectors, vector<PlotDataParameters*> &pdps);
	void generatePlotSeries(MathStructure **x_vector, MathStructure **y_vector, int type, string str, string str_x);

	QMap<QListViewItem*, int> itemStyle;
	QMap<QListViewItem*, int> itemSmoothing;
	QMap<QListViewItem*, int> itemType;
	QMap<QListViewItem*, int> itemAxis;
	QMap<QListViewItem*, bool> itemRows;
	QMap<QListViewItem*, MathStructure*> itemXVector;
	QMap<QListViewItem*, MathStructure*> itemYVector;
	QMap<QListViewItem*, QString> itemXVariable;
	
protected slots:
	
	void slotHelp();	

public slots:

	void onClosing();
	void seriesItemRenamed(QListViewItem*, const QString&, int);
	void seriesSelected();
	void rangeTypeChanged(int);
	void typeChanged(int);
	void savePlot();
	void expressionActivated();
	void addSeries();
	void modifySeries();
	void removeSeries();
	void applyRange();
	void applyAppearance();
	void updatePlot();
	void saveMode();

};

#endif
