#ifndef VISUAL_RING_H
#define VISUAL_RING_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include "prim.h"

namespace visual {

class ring : public Primitive
{
 private:
	double radius, thickness;
 public:

	inline ring() : radius(1.0), thickness(0) {}
	ring( const ring& other) 
		: Primitive( other), radius( other.radius), thickness( other.thickness) 
	{}

	inline double get_radius()
	{ return radius; }

	inline void set_radius( double r)
	{ write_lock L(mtx); radius = r; }

	inline double get_thickness()
	{
		if (thickness)
			return thickness;
		else
			return radius * 0.1;
	}

	inline void
	set_thickness( double r)
	{ write_lock L(mtx); thickness = r; }

	virtual vector getScale();
	virtual void glRender( rView& view);
};


} // !namespace visual

#endif // !VISUAL_RING_H
