from numpy import *
from scikits.openopt import *
from pylab import *


#P = 1.01e-1
P = 0
xyCoordsAlwaysExist = False

contol = 1e-4

xl, yl = 0, 15
xr, yr = 8, 15

n = 10

MaxForces = 100*sin(arange(n)) + 5000*ones(n)\
+ array([ -1.37163831e+03,  -1.60694848e+03,  -1.74685759e+03,\
        -1.77099023e+03,  -1.76295446e+03,  -1.83232862e+03,\
        -2.01327466e+03,  -2.23292838e+03,  -2.37990432e+03,\
        -2.40786079e+03,  -2.37604148e+03,  -2.39220174e+03,\
        -2.51227773e+03,  -2.68825834e+03,  -2.81448159e+03,\
        -2.82791948e+03,  -2.76385327e+03,  -2.71873406e+03,\
        -2.75969731e+03,  -2.86237323e+03,  -2.93613565e+03,\
        -2.91260196e+03,  -2.80726185e+03,  -2.69990883e+03,\
        -2.65982371e+03,  -2.68285823e+03,  -2.69793719e+03,\
        -2.63722331e+03,  -2.49886567e+03,  -2.34512448e+03,\
        -2.24405190e+03,  -2.20790597e+03,  -2.18342816e+03,\
        -2.10368051e+03,  -1.95071662e+03,  -1.77036769e+03,\
        -1.62911926e+03,  -1.55345727e+03,  -1.50621766e+03,\
        -1.42212572e+03,  -1.26885753e+03,  -1.07614103e+03,\
        -9.07638583e+02,  -8.02510393e+02,  -7.39726398e+02,\
        -6.58001243e+02,  -5.12877756e+02,  -3.17504802e+02,\
        -1.30014677e+02,   9.99898976e-03])[:n]



#MaxForces -= array([ 470.83299096,  319.6860156 ,  186.5286786 ,   85.57322313,  3.84866201])-150
lengths = 5*ones(n)+cos(arange(n))#array([4, 3, 1, 2])
masses = 15*ones(n)+4*cos(arange(n))#array([10, 15, 20])

g = 10
Fm = masses * g

AdditionalMasses = [10]*(n-1)
x0 = hstack((array([ 1253.71520066, -3022.1989107 ]), AdditionalMasses))

lb = [-inf] * 2 + [0] * (n-1)
ub = [inf] * (n+1)

########################################################
def fillByNaNs(input, blockID):
    r = {}
    for fn in input.keys(): r[fn] = nan
    r['blockID'] = blockID
    r['broken'] = True
    return r

########################################################
from blockMisc import project2ball

def blockEngineFunc((lx, ly, lFx, lFy, prevBlockForceThreshold), AdditionalMasses, blockID):
    prevBlockBroken = isnan(prevBlockForceThreshold) or (prevBlockForceThreshold > 0 and P == 0)
    # calculate output
    Fwhole = sqrt(lFx**2+lFy**2)
    ForceThreshold = Fwhole - MaxForces[blockID]
    if P != 0:
        projection, distance = project2ball(x = [lFx, lFy], radius=MaxForces[blockID], center = 0)
        ForceThreshold += P * distance
    if blockID < n-1:
        CurrentAdditionalMass = AdditionalMasses[blockID]
        rFy = lFy +Fm[blockID] + CurrentAdditionalMass*g # TODO : store Fm[i] inside blocks
    else:
        rFy = nan
    rFx = lFx# Fx are same along whole chain

    if xyCoordsAlwaysExist or not prevBlockBroken:
        dx, dy = lengths[blockID] * lFx/ Fwhole, lengths[blockID] * lFy/ Fwhole
        rx = lx + dx
        ry = ly + dy
    else:
        rx = nan
        ry = nan
        ForceThreshold = nan
        rFx = nan
        rFy = nan

    r = (rx, ry, rFx, rFy, ForceThreshold)

    return r

########################################################
oofun_AdditionalMasses = oofun(lambda x: x[2:],  dep = 2+arange(len(AdditionalMasses)), name='AdditionalMasses')
oofun_AdditionalMasses.d = lambda x: hstack((zeros(2), ones(len(AdditionalMasses))))
########################################################
def derivative_blockEngineFunc((lx, ly, lFx, lFy, prevBlockForceThreshold), AdditionalMasses, blockID):
    nVars = 5 + len(AdditionalMasses)
    r = zeros((5, nVars)) # number of inputs = number of outputs
    r[0, 0] = 1 # dxr/dxl
    r[1, 1] = 1 # dyr/dyl


    Fwhole = sqrt(lFx**2+lFy**2)
    r[0, 2] = lengths[blockID] / Fwhole # dxr/dlFx
    r[1, 3] = lengths[blockID] / Fwhole # dyr/dlFy

    r[2, 2] = 1# drFx/dlFx, they are equal

    r[3, 3] = 1# drFy/dlFy
    if blockID < n-1:
        r[3, 5 + blockID] = g

    # dForceThreshold
    assert P == 0
    r[4, 2] = lFx / Fwhole # / dlFx
    r[4, 3] = lFy / Fwhole # / dlFy

    return r




########################################################

def firstBlockFunc(FxFyAdditionalMasses):

    lFx = FxFyAdditionalMasses[0]
    lFy = FxFyAdditionalMasses[1]

    lx = xl
    ly = yl

    ForceThreshold = 0

    r = (lx, ly, lFx, lFy, ForceThreshold)
    return r


########################################################
########################################################
def nanify(z, prevBlockForceConstraint):
    if prevBlockForceConstraint > 0 or isnan(prevBlockForceConstraint): return nan
    else: return z

ooFuncs = [oofun(firstBlockFunc, name = '0th block')]
c = []
for i in xrange(n):
    #derivative_blockEngineFunc = None
    ooFuncs.append(oofun(blockEngineFunc, input = (ooFuncs[i], oofun_AdditionalMasses), d = derivative_blockEngineFunc, args = i, name = 'blockEngineOOfun'))
    # TODO: replace "4" by named output "ForceThreshold"
    c.append(oofun(lambda z: z[4], input = ooFuncs[copy(i)+1], d=lambda z: [0, 0, 0, 0, 1], name='c'+str(i)))
    #c.append(lambda x, i=i: ooFuncs[i+1](x)[4])

f = oofun(lambda z: z[0]+z[1], input = ooFuncs[-1], d = lambda z:[1, 1, 0, 0, 0], name = 'objFunc')
#def f(x):
#    # TODO: replace "0" by named output "lx"
#   r = ooFuncs[-1](x)[0] + ooFuncs[-1](x)[1]
#   return r

p = NLP(f, x0, c=c, lb=lb, ub=ub, goal = 'max', ftol = 1e-6, xtol = 1e-6, gtol = 1e-6,  plot=0, maxIter = 1e4, contol = contol, iprint=1, maxFunEvals = 1e10)

p.diffInt = 2 * [1e-4] + (n-1) * [1e-7]

# condition "sum of masses is (at least) 100":

## 1) as linear equality
p.Aeq = 2 * [0] + (n-1) * [1]
p.beq = 100 # sum of additional masses should be this number

## 2) as linear inequality
#p.A = -array(2 * [0] + (n-1) * [1])
#p.b = -100

## 3) as non-linear inequality:
#a = array(2 * [0] + (n-1) * [1])
#b = 100
#cc = oofun(lambda x: b-dot(a, x), d = lambda x: -array(2 * [0] + n * [1]))
#p.c.append(cc)

## 4) as non-linear equality:
#p.h = lambda x: x[2:].sum()-100
#p.dh = lambda x: array(2 * [0] + (n-1) * [1])

## choose solver:
#solver = 'scipy_slsqp'
#solver = 'lincher'
solver = 'ralg'
#solver = 'algencan'
#solver = 'ipopt'
#solver = 'scipy_cobyla'
#solver = 'algencan'

#def cb(p):
#    if any(isnan(p.c(p.xk))):
#        return 1
#    else:
#        return 0
#p.callback = cb

r = p.solve(solver, debug=0, iprint = 1,  show_nnan = 0, hsNumber = 3, maxIter = 10000, showLS=0, showRej=1, maxLineSearch=1000)


