from BaseProblem import NonLinProblem
from NLP import nlp_init
from numpy import sum, dot, asfarray
import NLP

class LSP(NonLinProblem):
    __optionalData__ = []
    def __init__(self, *args, **kwargs):
        if len(args) > 2: self.err('incorrect args number for LSP constructor, must be 0..2 + (optionaly) some kwargs')

        kwargs2 = kwargs.copy()
        if len(args) > 0: kwargs2['f'] = args[0]
        if len(args) > 1: kwargs2['x0'] = args[1]

        NonLinProblem.__init__(self)
        self.probType = 'LSP'
        self.allowedGoals = ['minimum', 'min']
        self.showGoal = False
        self.isObjFunValueASingleNumber = False

        return nlp_init(self, kwargs2)


    def objFuncMultiple2Single(self, fv):
        return (fv ** 2).sum()

#    def lsp2nlp(self, solver, **kwargs):
#        ff = lambda x: sum(asfarray(self.f(x))**2)
#        if hasattr(self, 'df'):
#            dff = lambda x: dot(2*asfarray(self.f(x)), asfarray(self.df(x)))
#            p = NLP.NLP(ff, self.x0, df=dff)
#        else:
#            p = NLP.NLP(ff, self.x0)
#        self.inspire(p)
#        r = p.solve(solver, **kwargs)
#        return r
    def lsp2nlp(self, solver, **solver_params):
        #self.solver = getSolverFromStringName(self, solver)
        #self.__prepare__()
#        FF = oofun(self.f)
#        if hasattr(self, 'df') and self.df is not None: #TODO: replace by userSupplied
#            FF.d = self.df
        ff = lambda x: sum(asfarray(self.f(x))**2)
        if hasattr(self, 'df'):
            dff = lambda x: dot(2*asfarray(self.f(x)), asfarray(self.df(x)))
            p = NLP.NLP(ff, self.x0, df=dff)
        else:
            p = NLP.NLP(ff, self.x0)
        #p = NLP.NLP(FF, self.x0)
        self.inspire(p, sameConstraints=True)


        def lsp_iterfcn(*args,  **kwargs):
            p.primalIterFcn(*args,  **kwargs)
#            if len(args) != 0 and type(args[0]) != ndarray: # hence Point
#                p.primalIterFcn(args[0].x, max(abs(self.f(args[0].x))), args[0].mr(),  **kwargs)
#                # TODO: add nNaNs
#            elif len(args) > 1:
#                p.primalIterFcn(args[0], max(abs(self.f(args[0]))), *args[2:],  **kwargs)
#            elif kwargs.has_key('fk'):
#                kwargs['fk'] = max(abs(self.f(args[0])))
#                p.primalIterFcn(*args, **kwargs)
#            else:
#                p.primalIterFcn(*args,  **kwargs)
            p.xk = self.xk
            p.fk = p.f(p.xk)
            p.rk = self.rk
            # TODO: add nNaNs

#            self.xk = p.xk.copy()
#            self.fk = max(abs(asfarray(self.f(self.xk))))
#            self.rk = p.rk

#            self.istop = p.istop

#            cond1 = self.iprint>0 and self.iter>0 and self.iter % self.iprint == 0
#
#            cond2 = (self.iter == 0 or (self.istop and (p.rk <= p.contol ))) \
#            and self.iprint>=0 and not self.lastIterTextOutputWasInvolved
            p.istop = self.istop

#
#
#        def nlsp_callback(nlsp):
#            # nlsp = self
#            if all(abs(asfarray(self.f(nlsp.xk))) < self.ftol)  and self.getMaxResidual(nlsp.xk) < self.contol:
#                if nlsp.isUC: msg_contol = '' #TODO: make available self.isUC instead of p.isUC
#                else: msg_contol = 'and contol '
#                self.msg = 'solution with required ftol ' + msg_contol+ 'has been reached'
#                return (15, self.msg)
#            else:
#                return False

        #self.callback = [nlsp_callback]
        #self.kernelIterFuncs.pop(SMALL_DELTA_F)
        p.primalIterFcn,  p.iterfcn = self.iterfcn, lsp_iterfcn
        p.goal = 'min'

        self.iprint = -1
        p.show = False

        r = p.solve(solver, **solver_params)
        #r.ff = ff(r.xf)

        return r
