# Copyright (c) 2006 Bea Lam. All rights reserved.
# 
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

"""
Provides operations for sending and receiving files over OBEX.
"""

# Docstrings for attributes in this module.
_docstrings = {

"sendfile":
    """
    Sends a file to a remote device.
    
    Arguments:
        - address: the address of the remote device
        - channel: the channel of the remote service
        - source: a filename or file object, containing the data to be sent.
          If a file object is given, it must be opened for reading. Also it
          must be a real built-in file object, not just an object with file-like
          methods.
    """,
"recvfile":
    """
    Receives a file through an OBEX service.
    
    Arguments:
        - sock: the server socket on which the file is to be received. Note 
          this socket must *not* be listening. Also, an OBEX service should 
          have been advertised on this socket.
        - dest: a filename or file object, to which the received data will be 
          written. If a filename is given, any existing file will be overwritten.
          If a file object is given, it must be opened for writing. Also it
          must be a real built-in file object, not just an object with file-like
          methods.
    
    For example, to receive a file and save it as "MyFile.txt":
        >>> from lightblue import *
        >>> s = socket()
        >>> s.bind(("", 0))
        >>> advertise("My OBEX Service", s, OBEX)
        >>> obex.recvfile(s, "MyFile.txt")
    """
}

# import implementation modules
from _obex import *

# set docstrings
import _obex
localattrs = locals()
for attr in _obex.__all__:
    try:
        localattrs[attr].__doc__ = _docstrings[attr]
    except KeyError:
        pass
del attr
del localattrs
del _obex