#!/usr/bin/python

# TODO: Unit tests
# TODO: Document all routines
# TODO: Experiment with function generator to create API

# Investing time into setting up BugWatch class that I can move
# all my upstream checking functionality into, to unify it into
# a strong backend and avoid reimplementing it everywhere.
# Move plenty of functionality into lpltk so can utilize it in
# the quantal release.  Need to test it thoroughly too.

class BugWatch(object):
    def __init__(self, service, lp_bug_watch):
        self.__service = service
        self.lp_bug_watch = typecheck_Entry(lp_bug_watch)

        self.__bug = None
        self.__bug_tasks = None
        self.__date_created = None
        self.__date_last_changed = None
        self.__date_last_checked = None
        self.__date_next_checked = None
        self.__last_error_type = None
        self.__owner = None
        self.__remote_bug = None
        self.__remote_importance = None
        self.__remote_status = None
        self.__title = None
        self.__url = None

    def __str__(self):
        return "%s %s" %(self.__remote_bug, self.__title)

    @property
    def bug(self):
        if self.__bug is None:
            lp_bug = self.lp_bug_watch.bug
            if lp_bug is not None:
                self.__bug = Bug(self.__service, lp_bug.id)
        return self.__bug

    @property
    def bug_tasks(self):
        if self.__bug_tasks is None:
            lp_bug_tasks = self.lp_bug_watch.bug_tasks
            self.__bug_tasks = BugTasks(self.__services, lp_bug_tasks)
        return self.__bug_tasks

    @property
    def date_created(self):
        if self.__date_created is None:
            self.__date_created = self.lp_bug_watch.date_created
        return self.__date_created

    @property
    def date_last_changed(self):
        if self.__date_last_changed is None:
            self.__date_last_changed = self.lp_bug_watch.date_last_changed
        return self.__date_last_changed

    @property
    def date_last_checked(self):
        if self.__date_last_checked is None:
            self.__date_last_checked = self.lp_bug_watch.date_last_checked
        return self.__date_last_checked

    @property
    def date_next_checked(self):
        if self.__date_next_checked is None:
            self.__date_next_checked = self.lp_bug_watch.date_next_checked
        return self.__date_next_checked

    @property
    def last_error_type(self):
        if self.__last_error_type is None:
            self.__last_error_type = self.lp_bug_watch.last_error_type
        return self.__last_error_type

    @property
    def owner(self):
        if self.__owner is None:
            lp_owner = self.lp_bug_watch.owner
            if lp_owner is not None:
                self.__owner = Person(None, lp_owner)
        return self.__owner

    @property
    def remote_bug(self):
        if self.__remote_bug is None:
            self.__remote_bug = self.lp_bug_watch.remote_bug
        return self.__remote_bug

    @property
    def remote_importance(self):
        if self.__remote_importance is None:
            self.__remote_importance = self.lp_bug_watch.remote_importance
        return self.__remote_importance

    @property
    def remote_status(self):
        if self.__remote_status is None:
            self.__remote_status = self.lp_bug_watch.remote_status
        return self.__remote_status

    @property
    def title(self):
        if self.__title is None:
            self.__title = self.lp_bug_watch.title
        return self.__title

    @property
    def url(self):
        if self.__url is None:
            self.__url = self.lp_bug_watch.url
        return self.__url
