#!/usr/bin/python

from utils                      import o2str

# Person
#
# A class that provides a convenient interface to a Launchpad person.
# (as returned from a call to the bug.owner property)
#
class Person(object):
    # __init__
    #
    # Initialize the Person instance from a Launchpad bug.
    #
    def __init__(self, tkbug, lpperson):
        self.__tkbug          = tkbug
        if tkbug != None:
            self.__commit_changes = tkbug.commit_changes
        self.__full_name      = None
        self.__person         = lpperson

    def __eq__(self, other):
        if other == None:
            return False
        return self.lpperson == other.lpperson

    def __ne__(self, other):
        if other == None:
            return False
        return self.lpperson != other.lpperson

    #--------------------------------------------------------------------------
    # display_name
    #
    @property
    def display_name(self):
        return self.full_name

    #--------------------------------------------------------------------------
    # full_name
    #
    @property
    def full_name(self):
        if self.__full_name == None:
            self.__full_name = o2str(self.__person.display_name)
        return self.__full_name

    #--------------------------------------------------------------------------
    # first_name
    #
    @property
    def first_name(self):
        if self.__full_name == None:
            self.__full_name = o2str(self.__person.display_name)
        return self.__full_name.split(' ')[0]

    #--------------------------------------------------------------------------
    # lpperson
    #
    @property
    def lpperson(self):
        return self.__person

# vi:set ts=4 sw=4 expandtab:
