import autopath
from pypy.tool.algo.sparsemat import *


def test_sparsemat1():
    import py
    M = SparseMatrix(4)
    M[0,0] = M[1,1] = M[2,2] = M[3,3] = 1
    M[0,1] = -1.0
    M[1,2] = M[1,3] = -0.5
    M[2,1] = -1.0
    res = M.solve([4, 5, 4, 1])
    assert res == [19, 15, 19, 1]

def test_sparsemat2():
    import py
    M = SparseMatrix(4)
    M[0,0] = M[1,1] = M[2,2] = M[3,3] = 1
    M[0,1] = -1.0
    M[1,2] = M[1,3] = -0.5
    M[2,1] = M[2,3] = -0.5
    res = M.solve([6, 3, 6, 0])
    assert res == [14, 8, 10, 0]

def test_big_example():
    M = SparseMatrix(754)
    M.lines = [
        {0: 1, 1: -0.5, 752: -0.5},
        {1: 1, 2: -0.5, 4: -0.5},
        {2: 1, 3: -1.0},
        {3: 1},
        {4: 1, 5: -0.5, 750: -0.5},
        {5: 1, 6: -0.5, 7: -0.5},
        {3: -1.0, 6: 1},
        {8: -0.5, 748: -0.5, 7: 1},
        {8: 1, 9: -0.5, 10: -0.5},
        {9: 1, 3: -1.0},
        {10: 1, 11: -0.5, 747: -0.5},
        {11: 1, 12: -1.0},
        {12: 1, 13: -1.0},
        {745: -0.5, 13: 1, 14: -0.5},
        {16: -0.5, 14: 1, 15: -0.5},
        {3: -1.0, 15: 1},
        {16: 1, 17: -0.5, 744: -0.5},
        {17: 1, 18: -1.0},
        {576: -0.5, 18: 1, 19: -0.5},
        {19: 1, 20: -0.5, 574: -0.5},
        {20: 1, 21: -0.5, 22: -0.5},
        {3: -1.0, 21: 1},
        {573: -0.5, 22: 1, 23: -0.5},
        {24: -1.0, 23: 1},
        {24: 1, 25: -1.0},
        {25: 1, 26: -0.5, 571: -0.5},
        {26: 1, 27: -0.5, 28: -0.5},
        {3: -1.0, 27: 1},
        {570: -0.5, 28: 1, 29: -0.5},
        {29: 1, 30: -1.0},
        {567: -0.5, 30: 1, 31: -0.5},
        {32: -0.5, 565: -0.5, 31: 1},
        {32: 1, 33: -0.5, 34: -0.5},
        {33: 1, 3: -1.0},
        {34: 1, 35: -0.5, 564: -0.5},
        {35: 1, 36: -1.0},
        {563: -0.5, 36: 1, 37: -0.5},
        {561: -0.5, 37: 1, 38: -0.5},
        {40: -0.5, 38: 1, 39: -0.5},
        {3: -1.0, 39: 1},
        {40: 1, 41: -0.5, 560: -0.5},
        {41: 1, 42: -1.0},
        {42: 1, 43: -0.5, 559: -0.5},
        {43: 1, 44: -1.0},
        {44: 1, 45: -0.5, 557: -0.5},
        {45: 1, 46: -0.29999999999999999, 47: -0.69999999999999996},
        {3: -1.0, 46: 1},
        {48: -0.5, 555: -0.5, 47: 1},
        {48: 1, 49: -0.29999999999999999, 50: -0.69999999999999996},
        {49: 1, 3: -1.0},
        {553: -0.5, 50: 1, 51: -0.5},
        {51: 1, 52: -0.29999999999999999, 53: -0.69999999999999996},
        {3: -1.0, 52: 1},
        {53: 1, 54: -0.5, 551: -0.5},
        {56: -0.69999999999999996, 54: 1, 55: -0.29999999999999999},
        {3: -1.0, 55: 1},
        {56: 1, 57: -0.5, 550: -0.5},
        {57: 1, 58: -1.0},
        {58: 1, 59: -0.29999999999999999, 63: -0.69999999999999996},
        {59: 1, 60: -0.5, 61: -0.5},
        {3: -1.0, 60: 1},
        {61: 1, 62: -1.0},
        {62: 1},
        {64: -0.5, 548: -0.5, 63: 1},
        {64: 1, 65: -0.29999999999999999, 66: -0.69999999999999996},
        {65: 1, 3: -1.0},
        {66: 1, 67: -0.5, 546: -0.5},
        {67: 1, 68: -0.29999999999999999, 69: -0.69999999999999996},
        {3: -1.0, 68: 1},
        {544: -0.5, 69: 1, 70: -0.5},
        {72: -0.69999999999999996, 70: 1, 71: -0.29999999999999999},
        {3: -1.0, 71: 1},
        {72: 1, 73: -0.5, 542: -0.5},
        {73: 1, 74: -0.29999999999999999, 75: -0.69999999999999996},
        {74: 1, 3: -1.0},
        {540: -0.5, 75: 1, 76: -0.5},
        {76: 1, 77: -0.29999999999999999, 78: -0.69999999999999996},
        {3: -1.0, 77: 1},
        {538: -0.5, 78: 1, 79: -0.5},
        {80: -0.29999999999999999, 81: -0.69999999999999996, 79: 1},
        {80: 1, 3: -1.0},
        {81: 1, 82: -0.5, 537: -0.5},
        {82: 1, 83: -1.0},
        {522: -0.5, 83: 1, 84: -0.5},
        {520: -0.5, 84: 1, 85: -0.5},
        {85: 1, 86: -0.29999999999999999, 87: -0.69999999999999996},
        {3: -1.0, 86: 1},
        {88: -0.5, 518: -0.5, 87: 1},
        {88: 1, 89: -0.29999999999999999, 90: -0.69999999999999996},
        {89: 1, 3: -1.0},
        {90: 1, 91: -0.5, 516: -0.5},
        {91: 1, 92: -0.29999999999999999, 93: -0.69999999999999996},
        {3: -1.0, 92: 1},
        {514: -0.5, 93: 1, 94: -0.5},
        {96: -0.69999999999999996, 94: 1, 95: -0.29999999999999999},
        {3: -1.0, 95: 1},
        {96: 1, 97: -0.5, 512: -0.5},
        {97: 1, 98: -0.29999999999999999, 99: -0.69999999999999996},
        {98: 1, 3: -1.0},
        {99: 1, 100: -0.5, 510: -0.5},
        {100: 1, 101: -0.29999999999999999, 102: -0.69999999999999996},
        {3: -1.0, 101: 1},
        {508: -0.5, 102: 1, 103: -0.5},
        {104: -0.29999999999999999, 105: -0.69999999999999996, 103: 1},
        {104: 1, 3: -1.0},
        {105: 1, 106: -0.5, 506: -0.5},
        {106: 1, 107: -0.29999999999999999, 108: -0.69999999999999996},
        {3: -1.0, 107: 1},
        {504: -0.5, 108: 1, 109: -0.5},
        {109: 1, 110: -0.29999999999999999, 111: -0.69999999999999996},
        {3: -1.0, 110: 1},
        {112: -0.5, 502: -0.5, 111: 1},
        {112: 1, 113: -0.29999999999999999, 114: -0.69999999999999996},
        {113: 1, 3: -1.0},
        {114: 1, 115: -0.5, 500: -0.5},
        {115: 1, 116: -0.29999999999999999, 117: -0.69999999999999996},
        {3: -1.0, 116: 1},
        {498: -0.5, 117: 1, 118: -0.5},
        {120: -0.69999999999999996, 118: 1, 119: -0.29999999999999999},
        {3: -1.0, 119: 1},
        {120: 1, 121: -0.5, 496: -0.5},
        {121: 1, 122: -0.29999999999999999, 123: -0.69999999999999996},
        {122: 1, 3: -1.0},
        {123: 1, 124: -0.5, 494: -0.5},
        {124: 1, 125: -0.29999999999999999, 126: -0.69999999999999996},
        {3: -1.0, 125: 1},
        {492: -0.5, 126: 1, 127: -0.5},
        {128: -0.29999999999999999, 129: -0.69999999999999996, 127: 1},
        {128: 1, 3: -1.0},
        {129: 1, 130: -0.5, 490: -0.5},
        {130: 1, 131: -0.29999999999999999, 132: -0.69999999999999996},
        {3: -1.0, 131: 1},
        {488: -0.5, 132: 1, 133: -0.5},
        {133: 1, 134: -0.29999999999999999, 135: -0.69999999999999996},
        {3: -1.0, 134: 1},
        {136: -0.5, 486: -0.5, 135: 1},
        {136: 1, 137: -0.29999999999999999, 138: -0.69999999999999996},
        {137: 1, 3: -1.0},
        {138: 1, 139: -0.5, 484: -0.5},
        {139: 1, 140: -0.29999999999999999, 141: -0.69999999999999996},
        {3: -1.0, 140: 1},
        {483: -0.5, 141: 1, 142: -0.5},
        {142: 1, 143: -1.0},
        {144: -0.5, 460: -0.5, 143: 1},
        {144: 1, 145: -0.5, 481: -0.5},
        {145: 1, 146: -0.29999999999999999, 147: -0.69999999999999996},
        {146: 1, 3: -1.0},
        {147: 1, 148: -0.5, 479: -0.5},
        {148: 1, 149: -0.29999999999999999, 150: -0.69999999999999996},
        {3: -1.0, 149: 1},
        {477: -0.5, 150: 1, 151: -0.5},
        {152: -0.29999999999999999, 153: -0.69999999999999996, 151: 1},
        {152: 1, 3: -1.0},
        {153: 1, 154: -0.5, 476: -0.5},
        {154: 1, 155: -1.0},
        {460: -0.5, 155: 1, 156: -0.5},
        {458: -0.5, 156: 1, 157: -0.5},
        {157: 1, 158: -0.29999999999999999, 159: -0.69999999999999996},
        {3: -1.0, 158: 1},
        {160: -0.5, 456: -0.5, 159: 1},
        {160: 1, 161: -0.29999999999999999, 162: -0.69999999999999996},
        {161: 1, 3: -1.0},
        {162: 1, 163: -0.5, 454: -0.5},
        {163: 1, 164: -0.29999999999999999, 165: -0.69999999999999996},
        {3: -1.0, 164: 1},
        {452: -0.5, 165: 1, 166: -0.5},
        {168: -0.69999999999999996, 166: 1, 167: -0.29999999999999999},
        {3: -1.0, 167: 1},
        {168: 1, 169: -0.5, 451: -0.5},
        {169: 1, 170: -1.0},
        {170: 1, 171: -0.5, 435: -0.5},
        {433: -0.5, 171: 1, 172: -0.5},
        {172: 1, 173: -0.29999999999999999, 174: -0.69999999999999996},
        {3: -1.0, 173: 1},
        {431: -0.5, 174: 1, 175: -0.5},
        {176: -0.29999999999999999, 177: -0.69999999999999996, 175: 1},
        {176: 1, 3: -1.0},
        {177: 1, 178: -0.5, 429: -0.5},
        {178: 1, 179: -0.29999999999999999, 180: -0.69999999999999996},
        {3: -1.0, 179: 1},
        {428: -0.5, 180: 1, 181: -0.5},
        {181: 1, 182: -1.0},
        {204: -0.5, 182: 1, 183: -0.5},
        {184: -0.5, 202: -0.5, 183: 1},
        {184: 1, 185: -0.29999999999999999, 186: -0.69999999999999996},
        {185: 1, 3: -1.0},
        {200: -0.5, 186: 1, 187: -0.5},
        {187: 1, 188: -0.29999999999999999, 189: -0.69999999999999996},
        {3: -1.0, 188: 1},
        {198: -0.5, 189: 1, 190: -0.5},
        {192: -0.69999999999999996, 190: 1, 191: -0.29999999999999999},
        {3: -1.0, 191: 1},
        {192: 1, 193: -0.5, 196: -0.5},
        {193: 1, 194: -0.29999999999999999, 195: -0.69999999999999996},
        {194: 1, 3: -1.0},
        {195: 1, 44: -1.0},
        {193: -0.5, 196: 1, 197: -0.5},
        {193: -1.0, 197: 1},
        {190: -0.5, 198: 1, 199: -0.5},
        {190: -1.0, 199: 1},
        {200: 1, 201: -0.5, 187: -0.5},
        {201: 1, 187: -1.0},
        {184: -0.5, 202: 1, 203: -0.5},
        {184: -1.0, 203: 1},
        {426: -0.5, 204: 1, 205: -0.5},
        {205: 1, 206: -0.29999999999999999, 207: -0.69999999999999996},
        {3: -1.0, 206: 1},
        {208: -0.5, 424: -0.5, 207: 1},
        {208: 1, 209: -0.29999999999999999, 210: -0.69999999999999996},
        {209: 1, 3: -1.0},
        {210: 1, 211: -0.5, 422: -0.5},
        {211: 1, 212: -0.29999999999999999, 213: -0.69999999999999996},
        {3: -1.0, 212: 1},
        {213: 1, 214: -0.5, 421: -0.5},
        {214: 1, 215: -1.0},
        {216: -0.5, 183: -0.5, 215: 1},
        {216: 1, 217: -0.5, 419: -0.5},
        {217: 1, 218: -0.29999999999999999, 219: -0.69999999999999996},
        {218: 1, 3: -1.0},
        {417: -0.5, 219: 1, 220: -0.5},
        {220: 1, 221: -0.29999999999999999, 222: -0.69999999999999996},
        {3: -1.0, 221: 1},
        {415: -0.5, 222: 1, 223: -0.5},
        {224: -0.29999999999999999, 225: -0.69999999999999996, 223: 1},
        {224: 1, 3: -1.0},
        {225: 1, 226: -0.5, 413: -0.5},
        {226: 1, 227: -0.29999999999999999, 228: -0.69999999999999996},
        {3: -1.0, 227: 1},
        {411: -0.5, 228: 1, 229: -0.5},
        {229: 1, 230: -0.29999999999999999, 231: -0.69999999999999996},
        {3: -1.0, 230: 1},
        {232: -0.5, 409: -0.5, 231: 1},
        {232: 1, 233: -0.29999999999999999, 234: -0.69999999999999996},
        {233: 1, 3: -1.0},
        {234: 1, 235: -0.5, 407: -0.5},
        {235: 1, 236: -0.29999999999999999, 237: -0.69999999999999996},
        {3: -1.0, 236: 1},
        {237: 1, 238: -0.5, 405: -0.5},
        {240: -0.69999999999999996, 238: 1, 239: -0.29999999999999999},
        {3: -1.0, 239: 1},
        {240: 1, 241: -0.5, 403: -0.5},
        {241: 1, 242: -0.29999999999999999, 243: -0.69999999999999996},
        {242: 1, 3: -1.0},
        {401: -0.5, 243: 1, 244: -0.5},
        {244: 1, 245: -0.29999999999999999, 246: -0.69999999999999996},
        {3: -1.0, 245: 1},
        {399: -0.5, 246: 1, 247: -0.5},
        {248: -0.29999999999999999, 249: -0.69999999999999996, 247: 1},
        {248: 1, 3: -1.0},
        {249: 1, 250: -0.5, 397: -0.5},
        {250: 1, 251: -0.29999999999999999, 252: -0.69999999999999996},
        {3: -1.0, 251: 1},
        {395: -0.5, 252: 1, 253: -0.5},
        {253: 1, 254: -0.29999999999999999, 255: -0.69999999999999996},
        {3: -1.0, 254: 1},
        {256: -0.5, 393: -0.5, 255: 1},
        {256: 1, 257: -0.29999999999999999, 258: -0.69999999999999996},
        {257: 1, 3: -1.0},
        {258: 1, 259: -0.5, 391: -0.5},
        {259: 1, 260: -0.29999999999999999, 261: -0.69999999999999996},
        {3: -1.0, 260: 1},
        {261: 1, 262: -0.5, 389: -0.5},
        {264: -0.69999999999999996, 262: 1, 263: -0.29999999999999999},
        {3: -1.0, 263: 1},
        {264: 1, 265: -0.5, 387: -0.5},
        {265: 1, 266: -0.29999999999999999, 267: -0.69999999999999996},
        {266: 1, 3: -1.0},
        {385: -0.5, 267: 1, 268: -0.5},
        {268: 1, 269: -0.29999999999999999, 270: -0.69999999999999996},
        {3: -1.0, 269: 1},
        {383: -0.5, 270: 1, 271: -0.5},
        {272: -0.29999999999999999, 273: -0.69999999999999996, 271: 1},
        {272: 1, 3: -1.0},
        {273: 1, 274: -0.5, 382: -0.5},
        {274: 1, 275: -1.0},
        {297: -0.5, 275: 1, 276: -0.5},
        {276: 1, 277: -0.5, 295: -0.5},
        {277: 1, 278: -0.29999999999999999, 279: -0.69999999999999996},
        {3: -1.0, 278: 1},
        {280: -0.5, 293: -0.5, 279: 1},
        {280: 1, 281: -0.29999999999999999, 282: -0.69999999999999996},
        {281: 1, 3: -1.0},
        {291: -0.5, 282: 1, 283: -0.5},
        {283: 1, 284: -0.29999999999999999, 285: -0.69999999999999996},
        {3: -1.0, 284: 1},
        {289: -0.5, 285: 1, 286: -0.5},
        {288: -0.69999999999999996, 286: 1, 287: -0.29999999999999999},
        {3: -1.0, 287: 1},
        {288: 1, 183: -1.0},
        {289: 1, 290: -0.5, 286: -0.5},
        {290: 1, 286: -1.0},
        {283: -0.5, 291: 1, 292: -0.5},
        {283: -1.0, 292: 1},
        {280: -0.5, 293: 1, 294: -0.5},
        {280: -1.0, 294: 1},
        {296: -0.5, 277: -0.5, 295: 1},
        {296: 1, 277: -1.0},
        {297: 1, 298: -0.5, 380: -0.5},
        {298: 1, 299: -0.29999999999999999, 300: -0.69999999999999996},
        {3: -1.0, 299: 1},
        {378: -0.5, 300: 1, 301: -0.5},
        {301: 1, 302: -0.29999999999999999, 303: -0.69999999999999996},
        {3: -1.0, 302: 1},
        {304: -0.5, 376: -0.5, 303: 1},
        {304: 1, 305: -0.29999999999999999, 306: -0.69999999999999996},
        {305: 1, 3: -1.0},
        {306: 1, 307: -0.5, 375: -0.5},
        {307: 1, 308: -1.0},
        {276: -0.5, 308: 1, 309: -0.5},
        {309: 1, 310: -0.5, 373: -0.5},
        {312: -0.69999999999999996, 310: 1, 311: -0.29999999999999999},
        {3: -1.0, 311: 1},
        {312: 1, 313: -0.5, 371: -0.5},
        {313: 1, 314: -0.29999999999999999, 315: -0.69999999999999996},
        {314: 1, 3: -1.0},
        {369: -0.5, 315: 1, 316: -0.5},
        {316: 1, 317: -0.29999999999999999, 318: -0.69999999999999996},
        {3: -1.0, 317: 1},
        {367: -0.5, 318: 1, 319: -0.5},
        {320: -0.29999999999999999, 321: -0.69999999999999996, 319: 1},
        {320: 1, 3: -1.0},
        {321: 1, 322: -0.5, 365: -0.5},
        {322: 1, 323: -0.29999999999999999, 324: -0.69999999999999996},
        {3: -1.0, 323: 1},
        {363: -0.5, 324: 1, 325: -0.5},
        {325: 1, 326: -0.29999999999999999, 327: -0.69999999999999996},
        {3: -1.0, 326: 1},
        {328: -0.5, 361: -0.5, 327: 1},
        {328: 1, 329: -0.29999999999999999, 330: -0.69999999999999996},
        {329: 1, 3: -1.0},
        {330: 1, 331: -0.5, 359: -0.5},
        {331: 1, 332: -0.29999999999999999, 333: -0.69999999999999996},
        {3: -1.0, 332: 1},
        {333: 1, 334: -0.5, 357: -0.5},
        {336: -0.69999999999999996, 334: 1, 335: -0.29999999999999999},
        {3: -1.0, 335: 1},
        {336: 1, 337: -0.5, 355: -0.5},
        {337: 1, 338: -0.29999999999999999, 339: -0.69999999999999996},
        {338: 1, 3: -1.0},
        {353: -0.5, 339: 1, 340: -0.5},
        {340: 1, 341: -0.29999999999999999, 342: -0.69999999999999996},
        {3: -1.0, 341: 1},
        {351: -0.5, 342: 1, 343: -0.5},
        {344: -0.29999999999999999, 345: -0.69999999999999996, 343: 1},
        {344: 1, 3: -1.0},
        {345: 1, 346: -0.5, 349: -0.5},
        {346: 1, 347: -0.29999999999999999, 348: -0.69999999999999996},
        {3: -1.0, 347: 1},
        {44: -1.0, 348: 1},
        {346: -0.5, 349: 1, 350: -0.5},
        {346: -1.0, 350: 1},
        {352: -0.5, 343: -0.5, 351: 1},
        {352: 1, 343: -1.0},
        {353: 1, 354: -0.5, 340: -0.5},
        {354: 1, 340: -1.0},
        {337: -0.5, 355: 1, 356: -0.5},
        {337: -1.0, 356: 1},
        {358: -0.5, 357: 1, 334: -0.5},
        {334: -1.0, 358: 1},
        {360: -0.5, 331: -0.5, 359: 1},
        {360: 1, 331: -1.0},
        {328: -0.5, 361: 1, 362: -0.5},
        {328: -1.0, 362: 1},
        {363: 1, 364: -0.5, 325: -0.5},
        {364: 1, 325: -1.0},
        {322: -0.5, 365: 1, 366: -0.5},
        {322: -1.0, 366: 1},
        {368: -0.5, 319: -0.5, 367: 1},
        {368: 1, 319: -1.0},
        {369: 1, 370: -0.5, 316: -0.5},
        {370: 1, 316: -1.0},
        {313: -0.5, 371: 1, 372: -0.5},
        {313: -1.0, 372: 1},
        {374: -0.5, 373: 1, 310: -0.5},
        {310: -1.0, 374: 1},
        {308: -1.0, 375: 1},
        {376: 1, 304: -0.5, 377: -0.5},
        {304: -1.0, 377: 1},
        {378: 1, 379: -0.5, 301: -0.5},
        {379: 1, 301: -1.0},
        {298: -0.5, 380: 1, 381: -0.5},
        {298: -1.0, 381: 1},
        {275: -1.0, 382: 1},
        {384: -0.5, 271: -0.5, 383: 1},
        {384: 1, 271: -1.0},
        {385: 1, 386: -0.5, 268: -0.5},
        {386: 1, 268: -1.0},
        {265: -0.5, 387: 1, 388: -0.5},
        {265: -1.0, 388: 1},
        {389: 1, 262: -0.5, 390: -0.5},
        {262: -1.0, 390: 1},
        {392: -0.5, 259: -0.5, 391: 1},
        {392: 1, 259: -1.0},
        {256: -0.5, 393: 1, 394: -0.5},
        {256: -1.0, 394: 1},
        {395: 1, 396: -0.5, 253: -0.5},
        {396: 1, 253: -1.0},
        {250: -0.5, 397: 1, 398: -0.5},
        {250: -1.0, 398: 1},
        {400: -0.5, 247: -0.5, 399: 1},
        {400: 1, 247: -1.0},
        {401: 1, 402: -0.5, 244: -0.5},
        {402: 1, 244: -1.0},
        {241: -0.5, 403: 1, 404: -0.5},
        {241: -1.0, 404: 1},
        {405: 1, 238: -0.5, 406: -0.5},
        {238: -1.0, 406: 1},
        {408: -0.5, 235: -0.5, 407: 1},
        {408: 1, 235: -1.0},
        {232: -0.5, 409: 1, 410: -0.5},
        {232: -1.0, 410: 1},
        {411: 1, 412: -0.5, 229: -0.5},
        {412: 1, 229: -1.0},
        {226: -0.5, 413: 1, 414: -0.5},
        {226: -1.0, 414: 1},
        {416: -0.5, 223: -0.5, 415: 1},
        {416: 1, 223: -1.0},
        {417: 1, 418: -0.5, 220: -0.5},
        {418: 1, 220: -1.0},
        {217: -0.5, 419: 1, 420: -0.5},
        {217: -1.0, 420: 1},
        {421: 1, 215: -1.0},
        {211: -0.5, 422: 1, 423: -0.5},
        {211: -1.0, 423: 1},
        {424: 1, 208: -0.5, 425: -0.5},
        {208: -1.0, 425: 1},
        {426: 1, 427: -0.5, 205: -0.5},
        {427: 1, 205: -1.0},
        {428: 1, 182: -1.0},
        {178: -0.5, 429: 1, 430: -0.5},
        {178: -1.0, 430: 1},
        {432: -0.5, 175: -0.5, 431: 1},
        {432: 1, 175: -1.0},
        {433: 1, 434: -0.5, 172: -0.5},
        {434: 1, 172: -1.0},
        {449: -0.5, 435: 1, 436: -0.5},
        {436: 1, 437: -0.29999999999999999, 438: -0.69999999999999996},
        {3: -1.0, 437: 1},
        {447: -0.5, 438: 1, 439: -0.5},
        {440: -0.29999999999999999, 441: -0.69999999999999996, 439: 1},
        {440: 1, 3: -1.0},
        {441: 1, 442: -0.5, 445: -0.5},
        {442: 1, 443: -0.29999999999999999, 444: -0.69999999999999996},
        {3: -1.0, 443: 1},
        {171: -1.0, 444: 1},
        {442: -0.5, 445: 1, 446: -0.5},
        {442: -1.0, 446: 1},
        {448: -0.5, 439: -0.5, 447: 1},
        {448: 1, 439: -1.0},
        {449: 1, 450: -0.5, 436: -0.5},
        {450: 1, 436: -1.0},
        {170: -1.0, 451: 1},
        {452: 1, 453: -0.5, 166: -0.5},
        {453: 1, 166: -1.0},
        {163: -0.5, 454: 1, 455: -0.5},
        {163: -1.0, 455: 1},
        {456: 1, 160: -0.5, 457: -0.5},
        {160: -1.0, 457: 1},
        {458: 1, 459: -0.5, 157: -0.5},
        {459: 1, 157: -1.0},
        {474: -0.5, 460: 1, 461: -0.5},
        {461: 1, 462: -0.29999999999999999, 463: -0.69999999999999996},
        {3: -1.0, 462: 1},
        {464: -0.5, 472: -0.5, 463: 1},
        {464: 1, 465: -0.29999999999999999, 466: -0.69999999999999996},
        {465: 1, 3: -1.0},
        {466: 1, 467: -0.5, 470: -0.5},
        {467: 1, 468: -0.29999999999999999, 469: -0.69999999999999996},
        {3: -1.0, 468: 1},
        {44: -1.0, 469: 1},
        {467: -0.5, 470: 1, 471: -0.5},
        {467: -1.0, 471: 1},
        {472: 1, 464: -0.5, 473: -0.5},
        {464: -1.0, 473: 1},
        {474: 1, 475: -0.5, 461: -0.5},
        {475: 1, 461: -1.0},
        {155: -1.0, 476: 1},
        {477: 1, 478: -0.5, 151: -0.5},
        {478: 1, 151: -1.0},
        {480: -0.5, 148: -0.5, 479: 1},
        {480: 1, 148: -1.0},
        {481: 1, 482: -0.5, 145: -0.5},
        {145: -1.0, 482: 1},
        {483: 1, 143: -1.0},
        {139: -0.5, 484: 1, 485: -0.5},
        {139: -1.0, 485: 1},
        {136: -0.5, 486: 1, 487: -0.5},
        {136: -1.0, 487: 1},
        {488: 1, 489: -0.5, 133: -0.5},
        {489: 1, 133: -1.0},
        {490: 1, 491: -0.5, 130: -0.5},
        {130: -1.0, 491: 1},
        {492: 1, 493: -0.5, 127: -0.5},
        {493: 1, 127: -1.0},
        {124: -0.5, 494: 1, 495: -0.5},
        {124: -1.0, 495: 1},
        {496: 1, 121: -0.5, 497: -0.5},
        {497: 1, 121: -1.0},
        {498: 1, 499: -0.5, 118: -0.5},
        {499: 1, 118: -1.0},
        {115: -0.5, 500: 1, 501: -0.5},
        {115: -1.0, 501: 1},
        {112: -0.5, 502: 1, 503: -0.5},
        {112: -1.0, 503: 1},
        {504: 1, 505: -0.5, 109: -0.5},
        {505: 1, 109: -1.0},
        {506: 1, 507: -0.5, 106: -0.5},
        {106: -1.0, 507: 1},
        {508: 1, 509: -0.5, 103: -0.5},
        {509: 1, 103: -1.0},
        {100: -0.5, 510: 1, 511: -0.5},
        {100: -1.0, 511: 1},
        {512: 1, 97: -0.5, 513: -0.5},
        {513: 1, 97: -1.0},
        {514: 1, 515: -0.5, 94: -0.5},
        {515: 1, 94: -1.0},
        {91: -0.5, 516: 1, 517: -0.5},
        {91: -1.0, 517: 1},
        {88: -0.5, 518: 1, 519: -0.5},
        {88: -1.0, 519: 1},
        {520: 1, 521: -0.5, 85: -0.5},
        {521: 1, 85: -1.0},
        {522: 1, 523: -0.5, 535: -0.5},
        {523: 1, 524: -0.29999999999999999, 525: -0.69999999999999996},
        {3: -1.0, 524: 1},
        {534: -0.5, 525: 1, 526: -0.5},
        {526: 1, 527: -1.0},
        {528: -0.69999999999999996, 59: -0.29999999999999999, 527: 1},
        {528: 1, 529: -0.5, 532: -0.5},
        {529: 1, 530: -0.29999999999999999, 531: -0.69999999999999996},
        {530: 1, 3: -1.0},
        {531: 1, 84: -1.0},
        {529: -0.5, 532: 1, 533: -0.5},
        {529: -1.0, 533: 1},
        {534: 1, 527: -1.0},
        {536: -0.5, 523: -0.5, 535: 1},
        {536: 1, 523: -1.0},
        {537: 1, 83: -1.0},
        {538: 1, 539: -0.5, 79: -0.5},
        {539: 1, 79: -1.0},
        {76: -0.5, 540: 1, 541: -0.5},
        {76: -1.0, 541: 1},
        {73: -0.5, 542: 1, 543: -0.5},
        {73: -1.0, 543: 1},
        {544: 1, 545: -0.5, 70: -0.5},
        {545: 1, 70: -1.0},
        {547: -0.5, 546: 1, 67: -0.5},
        {67: -1.0, 547: 1},
        {64: -0.5, 548: 1, 549: -0.5},
        {64: -1.0, 549: 1},
        {58: -1.0, 550: 1},
        {552: -0.5, 54: -0.5, 551: 1},
        {552: 1, 54: -1.0},
        {553: 1, 554: -0.5, 51: -0.5},
        {554: 1, 51: -1.0},
        {48: -0.5, 555: 1, 556: -0.5},
        {48: -1.0, 556: 1},
        {557: 1, 558: -0.5, 45: -0.5},
        {45: -1.0, 558: 1},
        {44: -1.0, 559: 1},
        {560: 1, 42: -1.0},
        {561: 1, 562: -0.5, 38: -0.5},
        {562: 1, 38: -1.0},
        {563: 1, 44: -1.0},
        {36: -1.0, 564: 1},
        {32: -0.5, 565: 1, 566: -0.5},
        {32: -1.0, 566: 1},
        {568: -0.5, 569: -0.5, 567: 1},
        {568: 1, 3: -1.0},
        {569: 1, 62: -1.0},
        {570: 1, 30: -1.0},
        {26: -0.5, 571: 1, 572: -0.5},
        {26: -1.0, 572: 1},
        {24: -1.0, 573: 1},
        {20: -0.5, 574: 1, 575: -0.5},
        {20: -1.0, 575: 1},
        {576: 1, 577: -0.5, 742: -0.5},
        {577: 1, 578: -0.5, 579: -0.5},
        {578: 1, 3: -1.0},
        {740: -0.5, 579: 1, 580: -0.5},
        {580: 1, 581: -0.5, 582: -0.5},
        {3: -1.0, 581: 1},
        {738: -0.5, 582: 1, 583: -0.5},
        {584: -0.5, 585: -0.5, 583: 1},
        {584: 1, 3: -1.0},
        {585: 1, 586: -0.5, 737: -0.5},
        {586: 1, 587: -1.0},
        {25: -0.5, 587: 1, 588: -0.5},
        {588: 1, 589: -0.5, 735: -0.5},
        {589: 1, 590: -0.5, 591: -0.5},
        {3: -1.0, 590: 1},
        {592: -0.5, 733: -0.5, 591: 1},
        {592: 1, 593: -0.5, 594: -0.5},
        {593: 1, 3: -1.0},
        {594: 1, 595: -0.5, 731: -0.5},
        {595: 1, 596: -0.5, 597: -0.5},
        {3: -1.0, 596: 1},
        {729: -0.5, 597: 1, 598: -0.5},
        {600: -0.5, 598: 1, 599: -0.5},
        {3: -1.0, 599: 1},
        {600: 1, 601: -0.5, 727: -0.5},
        {601: 1, 602: -0.5, 603: -0.5},
        {602: 1, 3: -1.0},
        {603: 1, 604: -0.5, 725: -0.5},
        {604: 1, 605: -0.5, 606: -0.5},
        {3: -1.0, 605: 1},
        {723: -0.5, 606: 1, 607: -0.5},
        {608: -0.5, 609: -0.5, 607: 1},
        {608: 1, 3: -1.0},
        {609: 1, 610: -0.5, 721: -0.5},
        {610: 1, 611: -0.5, 612: -0.5},
        {3: -1.0, 611: 1},
        {612: 1, 613: -0.5, 719: -0.5},
        {613: 1, 614: -0.5, 615: -0.5},
        {3: -1.0, 614: 1},
        {616: -0.5, 717: -0.5, 615: 1},
        {616: 1, 617: -0.5, 618: -0.5},
        {617: 1, 3: -1.0},
        {618: 1, 619: -0.5, 715: -0.5},
        {619: 1, 620: -0.5, 621: -0.5},
        {3: -1.0, 620: 1},
        {713: -0.5, 621: 1, 622: -0.5},
        {624: -0.5, 622: 1, 623: -0.5},
        {3: -1.0, 623: 1},
        {624: 1, 625: -0.5, 711: -0.5},
        {625: 1, 626: -0.5, 627: -0.5},
        {626: 1, 3: -1.0},
        {627: 1, 628: -0.5, 710: -0.5},
        {628: 1, 629: -1.0},
        {629: 1, 630: -0.5, 670: -0.5},
        {668: -0.5, 630: 1, 631: -0.5},
        {632: -0.5, 633: -0.5, 631: 1},
        {632: 1, 3: -1.0},
        {633: 1, 634: -0.5, 667: -0.5},
        {634: 1, 635: -1.0},
        {656: -0.5, 635: 1, 636: -0.5},
        {636: 1, 637: -0.5, 654: -0.5},
        {637: 1, 638: -0.5, 639: -0.5},
        {3: -1.0, 638: 1},
        {640: -0.5, 653: -0.5, 639: 1},
        {640: 1, 641: -1.0},
        {641: 1, 642: -0.5, 25: -0.5},
        {642: 1, 643: -0.5, 651: -0.5},
        {643: 1, 644: -0.5, 645: -0.5},
        {3: -1.0, 644: 1},
        {649: -0.5, 645: 1, 646: -0.5},
        {648: -0.5, 646: 1, 647: -0.5},
        {3: -1.0, 647: 1},
        {648: 1, 25: -1.0},
        {649: 1, 650: -0.5, 646: -0.5},
        {650: 1, 646: -1.0},
        {652: -0.5, 651: 1, 643: -0.5},
        {643: -1.0, 652: 1},
        {641: -1.0, 653: 1},
        {637: -0.5, 654: 1, 655: -0.5},
        {637: -1.0, 655: 1},
        {656: 1, 657: -0.5, 665: -0.5},
        {657: 1, 658: -0.5, 659: -0.5},
        {658: 1, 3: -1.0},
        {659: 1, 660: -0.5, 663: -0.5},
        {660: 1, 661: -0.5, 662: -0.5},
        {3: -1.0, 661: 1},
        {25: -1.0, 662: 1},
        {664: -0.5, 660: -0.5, 663: 1},
        {664: 1, 660: -1.0},
        {665: 1, 666: -0.5, 657: -0.5},
        {657: -1.0, 666: 1},
        {635: -1.0, 667: 1},
        {668: 1, 669: -0.5, 631: -0.5},
        {669: 1, 631: -1.0},
        {708: -0.5, 670: 1, 671: -0.5},
        {672: -0.5, 673: -0.5, 671: 1},
        {672: 1, 3: -1.0},
        {673: 1, 674: -0.5, 707: -0.5},
        {674: 1, 675: -1.0},
        {696: -0.5, 675: 1, 676: -0.5},
        {676: 1, 677: -0.5, 694: -0.5},
        {677: 1, 678: -0.5, 679: -0.5},
        {3: -1.0, 678: 1},
        {680: -0.5, 693: -0.5, 679: 1},
        {680: 1, 681: -1.0},
        {681: 1, 682: -0.5, 25: -0.5},
        {682: 1, 683: -0.5, 691: -0.5},
        {683: 1, 684: -0.5, 685: -0.5},
        {3: -1.0, 684: 1},
        {689: -0.5, 685: 1, 686: -0.5},
        {688: -0.5, 686: 1, 687: -0.5},
        {3: -1.0, 687: 1},
        {688: 1, 25: -1.0},
        {689: 1, 690: -0.5, 686: -0.5},
        {690: 1, 686: -1.0},
        {691: 1, 692: -0.5, 683: -0.5},
        {683: -1.0, 692: 1},
        {681: -1.0, 693: 1},
        {677: -0.5, 694: 1, 695: -0.5},
        {677: -1.0, 695: 1},
        {696: 1, 697: -0.5, 705: -0.5},
        {697: 1, 698: -0.5, 699: -0.5},
        {698: 1, 3: -1.0},
        {699: 1, 700: -0.5, 703: -0.5},
        {700: 1, 701: -0.5, 702: -0.5},
        {3: -1.0, 701: 1},
        {25: -1.0, 702: 1},
        {704: -0.5, 700: -0.5, 703: 1},
        {704: 1, 700: -1.0},
        {705: 1, 706: -0.5, 697: -0.5},
        {697: -1.0, 706: 1},
        {707: 1, 675: -1.0},
        {708: 1, 709: -0.5, 671: -0.5},
        {709: 1, 671: -1.0},
        {629: -1.0, 710: 1},
        {712: -0.5, 625: -0.5, 711: 1},
        {712: 1, 625: -1.0},
        {713: 1, 714: -0.5, 622: -0.5},
        {714: 1, 622: -1.0},
        {619: -0.5, 715: 1, 716: -0.5},
        {619: -1.0, 716: 1},
        {616: -0.5, 717: 1, 718: -0.5},
        {616: -1.0, 718: 1},
        {720: -0.5, 613: -0.5, 719: 1},
        {720: 1, 613: -1.0},
        {721: 1, 610: -0.5, 722: -0.5},
        {722: 1, 610: -1.0},
        {723: 1, 724: -0.5, 607: -0.5},
        {724: 1, 607: -1.0},
        {604: -0.5, 725: 1, 726: -0.5},
        {604: -1.0, 726: 1},
        {728: -0.5, 601: -0.5, 727: 1},
        {728: 1, 601: -1.0},
        {729: 1, 730: -0.5, 598: -0.5},
        {730: 1, 598: -1.0},
        {595: -0.5, 731: 1, 732: -0.5},
        {595: -1.0, 732: 1},
        {592: -0.5, 733: 1, 734: -0.5},
        {592: -1.0, 734: 1},
        {736: -0.5, 589: -0.5, 735: 1},
        {736: 1, 589: -1.0},
        {737: 1, 587: -1.0},
        {738: 1, 739: -0.5, 583: -0.5},
        {739: 1, 583: -1.0},
        {580: -0.5, 740: 1, 741: -0.5},
        {580: -1.0, 741: 1},
        {577: -0.5, 742: 1, 743: -0.5},
        {577: -1.0, 743: 1},
        {744: 1, 18: -1.0},
        {745: 1, 746: -0.5, 14: -0.5},
        {746: 1, 14: -1.0},
        {747: 1, 12: -1.0},
        {8: -0.5, 748: 1, 749: -0.5},
        {8: -1.0, 749: 1},
        {5: -0.5, 750: 1, 751: -0.5},
        {5: -1.0, 751: 1},
        {752: 1, 1: -0.5, 753: -0.5},
        {753: 1, 1: -1.0}]

    v = [2, 1, 1, 0, 9.5, 1, 1, 17.5, 1, 1, 10.5, 3.5, 3, 15.5, 1, 1,
         10.5, 3.5, 3, 5.5, 1, 1, 10.5, 3.5, 3, 5.5, 1, 1, 10.5, 3.5,
         3, 5.5, 1, 1, 10.5, 3.5, 3, 5.5, 1, 1, 10.5, 3.5, 3, 10, 2, 1,
         1, 13.0, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 10.5, 3.5, 3, 13, 1, 5,
         0, 2, 1, 1, 13.0, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 9.5, 1, 1, 14.0,
         1, 1, 10.5, 3.5, 3, 2, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 9.5, 1, 1,
         14.0, 1, 1, 17.0, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 9.5, 1, 1, 14.0,
         1, 1, 9.5, 1, 1, 14.0, 1, 1, 17.0, 1, 1, 9.5, 1, 1, 14.0, 1,
         1, 9.5, 1, 1, 14.0, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 10.5, 3.5, 3,
         2, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 10.5, 3.5, 3, 2, 1, 1, 13.0,
         1, 1, 9.5, 1, 1, 14.0, 1, 1, 10.5, 3.5, 3, 2, 1, 1, 9.5, 1, 1,
         14.0, 1, 1, 10.5, 3.5, 3, 2, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 9.5,
         1, 1, 19.5, 4, 1, 4, 1, 4, 1, 4, 1, 2, 1, 1, 9.5, 1, 1, 14.0,
         1, 1, 10.5, 3.5, 3, 2, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 9.5, 1, 1,
         14.0, 1, 1, 17.0, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 9.5, 1, 1, 14.0,
         1, 1, 9.5, 1, 1, 14.0, 1, 1, 17.0, 1, 1, 9.5, 1, 1, 14.0, 1,
         1, 9.5, 1, 1, 14.0, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 10.5, 3.5, 3,
         2, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 9.5, 1, 1, 19.5, 4, 1, 4, 1,
         4, 1, 4, 1, 2, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 10.5, 3.5, 3, 2,
         1, 1, 9.5, 1, 1, 14.0, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 9.5, 1, 1,
         14.0, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 28.5,
         1, 1, 9.5, 1, 1, 12.0, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4,
         1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 3, 4, 1, 4, 1, 4, 1, 3,
         4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4,
         1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 3, 4, 1, 4,
         1, 4, 1, 3, 4, 1, 4, 1, 4, 1, 2, 1, 1, 9.5, 1, 1, 14.0, 1, 1,
         18.5, 4, 1, 4, 1, 4, 1, 3, 4, 1, 4, 1, 4, 1, 4, 1, 2, 1, 1, 28.5,
         1, 1, 9.5, 1, 1, 12.0, 4, 1, 4, 1, 4, 1, 3, 4, 1, 4, 1, 4, 1,
         3, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1,
         4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 2, 1, 1,
         10.5, 3.5, 3, 2, 1, 1, 18.5, 4, 1, 3, 4, 1, 3, 4, 1, 4, 1, 4,
         1, 4, 1, 4, 1, 4, 1, 3, 4, 1, 4, 1, 4, 1, 4, 1, 10, 3, 4, 1,
         10, 3, 4, 1, 25, 1, 5, 3, 4, 1, 3, 4, 1, 2, 1, 1, 9.5, 1, 1,
         14.0, 1, 1, 10.5, 3.5, 3, 2, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 17.0,
         1, 1, 9.5, 1, 1, 14.0, 1, 1, 9.5, 1, 1, 14.0, 1, 1, 17.0, 1,
         1, 9.5, 1, 1, 14.0, 1, 1, 9.5, 1, 1, 17.5, 1, 1, 10.5, 3.5, 3,
         5.5, 1, 1, 10.5, 3.5, 3, 5.5, 1, 1, 10.5, 3.5, 3, 2, 1, 1, 9.5,
         1, 1, 12.0, 4, 1, 4, 1, 3, 4, 1, 2, 1, 1, 9.5, 1, 1, 12.0, 4,
         1, 4, 1, 3, 4, 1, 5.5, 1, 1, 10.5, 3.5, 3, 5.5, 1, 1, 10.5, 3.5,
         3, 2, 1, 1, 9.5, 1, 1, 12.0, 4, 1, 4, 1, 3, 4, 1, 2, 1, 1, 9.5,
         1, 1, 12.0, 4, 1, 4, 1, 3, 4, 1, 3, 4, 1, 4, 1, 4, 1, 4, 1, 4,
         1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 3, 4, 1, 4,
         1, 4, 1, 3, 4, 1, 3, 4, 1, 4, 1, 4, 1]

    expected = [25.033, 20.783, 1.0, 0.0, 38.565, 26.815, 1.0, 50.631,
                30.881, 1.0, 58.762, 48.512, 45.012, 42.012, 24.262, 1.0,
                45.523, 35.273, 31.773, 35.124, 27.374, 1.0, 51.747, 41.497,
                37.997, 34.997, 27.247, 1.0, 51.494, 41.244, 37.744, 41.489,
                33.739, 1.0, 64.477, 54.227, 50.727, 43.568, 35.818, 1.0,
                68.636, 58.386, 54.886, 51.886, 41.886, 37.636, 1.0, 51.909,
                36.659, 1.0, 50.512, 38.762, 1.0, 53.518, 37.268, 1.0,
                51.383, 41.133, 37.633, 16.0, 1.0, 5.0, 0.0, 42.618, 38.368,
                1.0, 52.954, 37.704, 1.0, 52.006, 40.256, 1.0, 55.652,
                39.402, 1.0, 54.431, 42.681, 1.0, 59.116, 42.866, 1.0,
                59.38, 49.13, 45.63, 41.369, 37.119, 1.0, 51.171, 39.421,
                1.0, 54.458, 38.208, 1.0, 52.726, 40.976, 1.0, 56.68,
                40.43, 1.0, 55.899, 36.649, 1.0, 50.499, 38.749, 1.0,
                53.499, 37.249, 1.0, 51.355, 39.605, 1.0, 54.722, 38.472,
                1.0, 53.103, 41.353, 1.0, 57.219, 40.969, 1.0, 56.669,
                37.419, 1.0, 51.599, 39.849, 1.0, 55.07, 38.82, 1.0, 53.6,
                41.85, 1.0, 57.929, 41.679, 1.0, 57.684, 45.934, 1.0,
                63.762, 47.512, 1.0, 66.018, 55.768, 52.268, 45.673, 41.423,
                1.0, 57.319, 45.569, 1.0, 63.241, 46.991, 1.0, 65.273,
                55.023, 51.523, 44.184, 39.934, 1.0, 55.191, 39.941, 1.0,
                55.202, 43.452, 1.0, 60.217, 43.967, 1.0, 60.952, 50.702,
                47.202, 43.764, 39.514, 1.0, 54.591, 42.841, 1.0, 59.344,
                43.094, 1.0, 59.706, 49.456, 45.956, 42.499, 38.249, 1.0,
                52.785, 41.035, 1.0, 56.764, 40.514, 1.0, 56.02, 44.27,
                1.0, 61.386, 48.77, 45.27, 45.014, 41.514, 45.535, 42.035,
                42.749, 39.249, 43.412, 39.162, 1.0, 54.089, 42.339, 1.0,
                58.627, 42.377, 1.0, 58.681, 48.431, 44.931, 41.362, 37.112,
                1.0, 51.16, 39.41, 1.0, 54.443, 38.193, 1.0, 52.705, 40.955,
                1.0, 56.65, 40.4, 1.0, 55.857, 36.607, 1.0, 50.438, 38.688,
                1.0, 53.412, 37.162, 1.0, 51.231, 39.481, 1.0, 54.545,
                38.295, 1.0, 52.849, 41.099, 1.0, 56.856, 40.606, 1.0,
                56.152, 36.902, 1.0, 50.86, 39.11, 1.0, 54.014, 37.764,
                1.0, 52.091, 40.341, 1.0, 55.773, 39.523, 1.0, 54.604,
                42.854, 1.0, 59.363, 43.113, 1.0, 59.733, 49.483, 45.983,
                42.647, 38.397, 1.0, 52.995, 41.245, 1.0, 57.065, 40.815,
                1.0, 56.45, 44.7, 1.0, 61.999, 49.2, 45.7, 45.315, 41.815,
                45.745, 42.245, 42.897, 39.397, 43.32, 39.07, 1.0, 53.957,
                42.207, 1.0, 58.439, 42.189, 1.0, 58.412, 48.162, 44.662,
                40.678, 36.428, 1.0, 50.182, 38.432, 1.0, 53.046, 36.796,
                1.0, 50.709, 38.959, 1.0, 53.799, 37.549, 1.0, 51.784,
                40.034, 1.0, 55.334, 39.084, 1.0, 53.977, 42.227, 1.0,
                58.468, 42.218, 1.0, 58.454, 46.704, 1.0, 64.862, 48.612,
                1.0, 67.589, 36.839, 1.0, 50.77, 39.02, 1.0, 53.886, 43.52,
                40.02, 41.339, 37.839, 53.112, 49.612, 51.204, 47.704,
                46.718, 43.218, 46.727, 43.227, 43.584, 40.084, 44.534,
                41.034, 42.049, 38.549, 43.459, 39.959, 41.296, 37.796,
                42.932, 39.432, 40.928, 37.428, 47.662, 46.689, 43.189,
                46.707, 43.207, 43.57, 40.07, 48.983, 47.613, 44.113,
                47.354, 43.854, 44.023, 40.523, 44.841, 41.341, 42.264,
                38.764, 43.61, 40.11, 41.402, 37.902, 45.106, 41.606,
                45.599, 42.099, 42.795, 39.295, 43.981, 40.481, 41.662,
                38.162, 43.188, 39.688, 41.107, 37.607, 44.9, 41.4, 45.455,
                41.955, 42.693, 39.193, 43.91, 40.41, 41.612, 38.112,
                47.931, 46.877, 43.377, 46.839, 43.339, 43.662, 40.162,
                48.956, 47.594, 44.094, 47.341, 43.841, 44.014, 40.514,
                44.641, 40.391, 1.0, 55.844, 44.094, 1.0, 61.134, 44.884,
                1.0, 62.264, 49.384, 45.884, 48.594, 45.094, 44.891, 41.391,
                50.202, 48.467, 44.967, 47.952, 44.452, 44.441, 40.941,
                44.434, 40.934, 52.862, 48.612, 1.0, 67.589, 36.839, 1.0,
                50.77, 39.02, 1.0, 53.886, 43.52, 40.02, 41.339, 37.839,
                53.112, 49.612, 54.523, 51.491, 47.991, 50.069, 46.569,
                45.923, 42.423, 55.268, 52.012, 48.512, 50.434, 46.934,
                46.179, 42.679, 46.35, 42.85, 43.32, 39.82, 44.349, 40.849,
                41.919, 38.419, 45.469, 41.969, 45.853, 42.353, 42.972,
                39.472, 44.105, 40.605, 41.749, 38.249, 43.249, 39.749,
                41.149, 37.649, 44.93, 41.43, 45.476, 41.976, 42.708,
                39.208, 43.921, 40.421, 41.619, 38.119, 43.89, 39.64,
                1.0, 54.771, 44.521, 41.021, 47.459, 43.209, 1.0, 59.869,
                47.709, 44.209, 44.021, 44.14, 40.64, 48.63, 47.366, 43.866,
                47.181, 43.681, 43.902, 40.402, 44.756, 41.256, 42.204,
                38.704, 42.868, 39.368, 40.633, 41.768, 38.268, 43.262,
                39.762, 41.159, 37.659, 42.136, 38.636, 51.886, 57.886,
                40.318, 36.818, 51.886, 53.727, 38.239, 34.739, 28.0,
                1.0, 5.0, 40.744, 31.747, 28.247, 40.997, 31.874, 28.374,
                22.423, 18.173, 1.0, 33.347, 21.597, 1.0, 40.193, 23.943,
                1.0, 44.887, 34.637, 31.137, 21.277, 17.027, 1.0, 31.053,
                19.303, 1.0, 35.606, 19.356, 1.0, 35.713, 16.463, 1.0,
                29.926, 18.176, 1.0, 33.352, 17.102, 1.0, 31.203, 19.453,
                1.0, 35.906, 19.656, 1.0, 36.313, 17.063, 1.0, 31.125,
                19.375, 1.0, 35.751, 19.501, 1.0, 36.002, 24.252, 1.0,
                45.504, 25.754, 1.0, 48.507, 38.257, 34.757, 31.757, 24.007,
                1.0, 45.015, 34.765, 31.265, 32.405, 24.655, 1.0, 46.311,
                36.061, 32.561, 24.124, 19.874, 1.0, 36.749, 24.999, 1.0,
                46.997, 29.499, 25.999, 24.374, 20.874, 35.561, 29.155,
                25.655, 24.124, 19.874, 1.0, 36.749, 24.999, 1.0, 46.997,
                29.499, 25.999, 24.374, 20.874, 34.265, 28.507, 25.007,
                31.757, 24.007, 1.0, 45.015, 34.765, 31.265, 32.405, 24.655,
                1.0, 46.311, 36.061, 32.561, 24.124, 19.874, 1.0, 36.749,
                24.999, 1.0, 46.997, 29.499, 25.999, 24.374, 20.874, 35.561,
                29.155, 25.655, 24.124, 19.874, 1.0, 36.749, 24.999, 1.0,
                46.997, 29.499, 25.999, 24.374, 20.874, 34.265, 28.507,
                25.007, 37.757, 30.254, 26.754, 28.752, 25.252, 24.001,
                20.501, 23.875, 20.375, 21.563, 18.063, 24.156, 20.656,
                23.953, 20.453, 21.602, 18.102, 22.676, 19.176, 20.963,
                17.463, 23.856, 20.356, 23.803, 20.303, 21.527, 18.027,
                34.137, 28.443, 24.943, 26.097, 22.597, 22.673, 19.173,
                34.773, 28.762, 25.262, 48.012, 35.381, 31.881, 31.315,
                27.815, 25.283, 21.783]

    answer = M.solve(v)

    assert len(answer) == len(expected)
    for x, y in zip(answer, expected):
        error = abs(y - x)
        assert error < 0.01
