## options.py
## 
## Copyright (C) 2006 Mykola Lynnyk <pydefiner@gmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##

import pygtk
pygtk.require('2.0')
import gtk

import string

import pyNeighborhood
import dialog


class OptionsDialog:
    #
    # Fix the entered path
    #
    def path_validator(self, path):
        list = path.split("/")
        final_path = ""
        for item in list:
            if item != "":
                final_path = final_path + "/" + item
        return final_path

    #
    # Remove unuseful spaces
    #
    def unpad(self, str):
        if str == '':
            return str
        else:            
            splitted = str.split(" ")
            non_empty_list = []
            for sym in splitted:
                if sym == '':
                    pass
                else:
                    non_empty_list.append(sym)
            unpadded_line = string.join(non_empty_list)
            return unpadded_line

    def enable_smb_toggle(self, check_button):
        if check_button.get_active():
            self.hbox_mount_smb.set_sensitive(True)
            self.hbox_umount_smb.set_sensitive(True)
            self.hbox_options_smb.set_sensitive(True)
        else:
            self.hbox_mount_smb.set_sensitive(False)
            self.hbox_umount_smb.set_sensitive(False)
            self.hbox_options_smb.set_sensitive(False)
            if self.cifs_check_button.get_active() == False:
                dialog.dialog("SMB and CIFS can not be disabled at the same time. "
                              "Restoring.", self.parent)
                check_button.set_active(True)
        return

    def enable_cifs_toggle(self, check_button):
        if check_button.get_active():
            self.hbox_mount_cifs.set_sensitive(True)
            self.hbox_umount_cifs.set_sensitive(True)
            self.hbox_options_cifs.set_sensitive(True)
        else:
            self.hbox_mount_cifs.set_sensitive(False)
            self.hbox_umount_cifs.set_sensitive(False)
            self.hbox_options_cifs.set_sensitive(False)
            if self.smb_check_button.get_active() == False:
                dialog.dialog("SMB and CIFS can not be disabled at the same time. "
                              "Restoring.", self.parent)
                check_button.set_active(True)
        return

    def anonymous_toggle(self, check_button):
        if check_button.get_active():
            self.hbox_user.set_sensitive(False)
            self.hbox_password.set_sensitive(False)
            self.check_button_prompt.set_sensitive(False)
        else:
            self.hbox_user.set_sensitive(True)
            self.hbox_password.set_sensitive(True)
            self.check_button_prompt.set_sensitive(True)
        return
    
    def workgroup_toggle(self, check_button):
        if check_button.get_active():
            self.hbox_workgroup.set_sensitive(False)
        else:
            self.hbox_workgroup.set_sensitive(True)
        return
    #
    # Callback for adding a new file manager
    #
    def add_cb(self, widget):
        msg = gtk.Dialog("Add file manager",
                         self.parent,
                         gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                         (gtk.STOCK_OK, gtk.RESPONSE_OK,
                         gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))
        msg.set_resizable(False)
        hbox = gtk.VBox(True, 10)
        lbl_name = gtk.Label("Specify the file manager here:")
        lbl_name.show()
        hbox.pack_start(lbl_name, True, True, 0)

        entry_name = gtk.Entry()
        entry_name.set_max_length(50)
        entry_name.select_region(0, len(entry_name.get_text()))
        hbox.pack_start(entry_name, True, True, 0)
        entry_name.show()
        msg.vbox.pack_start(hbox, True, True, 0)

        msg.show_all()
        response = msg.run()
        if response == gtk.RESPONSE_CANCEL or gtk.RESPONSE_DELETE_EVENT: 
            msg.destroy()
        if response == gtk.RESPONSE_OK:
            text = self.unpad(entry_name.get_text())
            if text != '':
                iter = self.liststore.append(None)
                self.liststore.set_value(iter, 0, text)
            msg.destroy()

    #
    # Callback for editing an existing file manager
    #
    def edit_cb(self, widget):
        treeselection = self.treeview.get_selection()
        (model, iter) = treeselection.get_selected()
        if iter == None:
            return
        text = model.get_value(iter, 0)

        msg = gtk.Dialog("Edit file manager",
                         self.parent,
                         gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                         (gtk.STOCK_OK, gtk.RESPONSE_OK,
                         gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))
        msg.set_resizable(False)
        hbox = gtk.VBox(True, 10)
        lbl_name = gtk.Label("Specify the file manager here:")
        lbl_name.show()
        hbox.pack_start(lbl_name, True, True, 0)

        entry_name = gtk.Entry()
        entry_name.set_max_length(50)
        entry_name.select_region(0, len(entry_name.get_text()))
        entry_name.set_text(text)
        hbox.pack_start(entry_name, True, True, 0)
        entry_name.show()
        msg.vbox.pack_start(hbox, True, True, 0)

        msg.show_all()
        response = msg.run()
        if response == gtk.RESPONSE_CANCEL or gtk.RESPONSE_DELETE_EVENT: 
            msg.destroy()
        if response == gtk.RESPONSE_OK:
            self.liststore.set_value(iter, 0, self.unpad(entry_name.get_text()))
            msg.destroy()

    #
    # Callback for removing an existing file manager
    #
    def remove_cb(self, widget):
        treeselection = self.treeview.get_selection()
        (model, iter) = treeselection.get_selected()
        if iter == None:
            return
        model.remove(iter)

    #
    # Description af the general tab
    #
    def general_options(self):
        vbox = gtk.VBox()
        vbox.set_border_width(10)
        
        #
        # Text entry with the default mount folder
        #
        hbox = gtk.HBox(True, 10)
        hbox.set_border_width(5)
        lbl_folder = gtk.Label("Mount folder:")
        lbl_folder.show()
        lbl_folder.set_alignment(0, 0.5)
        hbox.pack_start(lbl_folder, False, True, 0)

        entry_folder = gtk.Entry()
        entry_folder.set_max_length(50)
        entry_folder.select_region(0, len(entry_folder.get_text()))
        entry_folder.show()
        hbox.pack_start(entry_folder, True, True, 0)
        vbox.pack_start(hbox, False, True, 0)
        
        #
        # Checkbutton selecting mount points policy
        #
        check_button_rem = gtk.CheckButton("Remove mount points after unmount")
        check_button_rem.set_active(True)
        check_button_rem.set_border_width(5)
        vbox.pack_start(check_button_rem, False, True, 0)

        #
        # Frame with user preferences
        #
        frame = gtk.Frame(None)
        vbox_enc = gtk.VBox()
        frame.add(vbox_enc)
        # Checkbutton

        check_button = gtk.CheckButton("Always use anonymous logins")
        check_button.set_active(True)
        check_button.set_border_width(5)
        vbox_enc.pack_start(check_button, True, True, 0)

        self.check_button_prompt = gtk.CheckButton("Always use default username and password")
        self.check_button_prompt.set_active(True)
        self.check_button_prompt.set_border_width(5)
        vbox_enc.pack_start(self.check_button_prompt, True, True, 0)

        # User name text entry
        self.hbox_user = gtk.HBox(True, 10)
        self.hbox_user.set_border_width(5)
        lbl_user = gtk.Label("Default username:")
        lbl_user.show()
        lbl_user.set_alignment(0, 0.5)
        self.hbox_user.pack_start(lbl_user, False, True, 5)

        entry_user = gtk.Entry()
        entry_user.set_max_length(50)
        entry_user.select_region(0, len(entry_user.get_text()))
        entry_user.show()
        self.hbox_user.pack_start(entry_user, True, True, 0)
        self.hbox_user.set_border_width(5)
        vbox_enc.pack_start(self.hbox_user, True, True, 0)

#        self.hbox_user.set_sensitive(check_button.get_active())

        # User password text entry
        self.hbox_password = gtk.HBox(True, 10)
        self.hbox_password.set_border_width(5)
        lbl_password = gtk.Label("Default password:")
        lbl_password.show()
        lbl_password.set_alignment(0, 0.5)
        self.hbox_password.pack_start(lbl_password, False, True, 5)

        entry_password = gtk.Entry()
        entry_password.set_max_length(50)
        entry_password.select_region(0, len(entry_password.get_text()))
        entry_password.set_visibility(False)
        entry_password.show()
        self.hbox_password.pack_start(entry_password, True, True, 0)
        self.hbox_password.set_border_width(5)
        vbox_enc.pack_start(self.hbox_password, True, True, 0)
        
        #
        # Set current configuration values
        #
        entry_folder.set_text(pyNeighborhood.parser.get_value("mount_directory"))
        entry_user.set_text(pyNeighborhood.parser.get_value("user"))
        entry_password.set_text(pyNeighborhood.parser.get_value("password"))

        if pyNeighborhood.parser.get_value("anonymous") == "True":
            self.hbox_user.set_sensitive(False)
            self.hbox_password.set_sensitive(False)
            self.check_button_prompt.set_sensitive(False)
            check_button.set_active(True)
        else:
            self.hbox_user.set_sensitive(True)
            self.hbox_password.set_sensitive(True)
            self.check_button_prompt.set_sensitive(True)
            check_button.set_active(False)
        
        if pyNeighborhood.parser.get_value("enable_default") == "True":
            self.check_button_prompt.set_active(True)
        else:
            self.check_button_prompt.set_active(False)

        if pyNeighborhood.parser.get_value("delete_dirs") == "True":
            check_button_rem.set_active(True)
        else:
            check_button_rem.set_active(False)

        vbox.pack_start(frame, False, False, 5)
        check_button.connect('toggled', self.anonymous_toggle)

        self.m_folder = entry_folder
        self.m_user = entry_user
        self.m_password = entry_password
        self.m_checkbutton = check_button
        self.m_checkbutton_rem = check_button_rem

        return vbox

    def network_options(self):
        vbox = gtk.VBox()
        vbox.set_border_width(10)

        frame = gtk.Frame(None)
        vbox_workgroup = gtk.VBox()
        frame.add(vbox_workgroup)
        # Checkbutton

        check_button = gtk.CheckButton("Always use msbrowse")
        check_button.set_active(True)
        check_button.set_border_width(5)
        vbox_workgroup.pack_start(check_button, True, True, 0)
        #
        # Workgroup entry
        #
        hbox_workgroup = gtk.HBox(True, 10)
        hbox_workgroup.set_border_width(5)
        lbl_workgroup = gtk.Label("Workgroup:")
        lbl_workgroup.show()
        lbl_workgroup.set_alignment(0, 0.5)
        hbox_workgroup.pack_start(lbl_workgroup, False, True, 0)

        entry_workgroup = gtk.Entry()
        entry_workgroup.set_max_length(50)
        entry_workgroup.select_region(0, len(entry_workgroup.get_text()))
        entry_workgroup.show()
        hbox_workgroup.pack_start(entry_workgroup, True, True, 0)
        vbox_workgroup.pack_start(hbox_workgroup, True, True, 0)
        vbox.pack_start(frame, False, True, 0)

        #
        # Client entry
        #
        hbox_client = gtk.HBox(True, 10)
        hbox_client.set_border_width(5)
        lbl_client = gtk.Label("Client command:")
        lbl_client.show()
        lbl_client.set_alignment(0, 0.5)
        hbox_client.pack_start(lbl_client, False, True, 0)

        entry_client = gtk.Entry()
        entry_client.set_max_length(50)
        entry_client.select_region(0, len(entry_client.get_text()))
        entry_client.show()
        hbox_client.pack_start(entry_client, True, True, 0)
        vbox.pack_start(hbox_client, False, True, 0)
        
        #
        # Lookup entry
        #
        hbox_lookup = gtk.HBox(True, 10)
        hbox_lookup.set_border_width(5)
        lbl_lookup = gtk.Label("Lookup command:")
        lbl_lookup.show()
        lbl_lookup.set_alignment(0, 0.5)
        hbox_lookup.pack_start(lbl_lookup, False, True, 0)

        entry_lookup = gtk.Entry()
        entry_lookup.set_max_length(50)
        entry_lookup.select_region(0, len(entry_lookup.get_text()))
        entry_lookup.show()
        hbox_lookup.pack_start(entry_lookup, True, True, 0)
        vbox.pack_start(hbox_lookup, False, True, 0)
        
        #
        # Checkbox - automatic retrieving
        #
        check_button_ret = gtk.CheckButton("%s"%"Try to retrieve IP address when\n"
                                                "adding a machine from the group browser" )
        check_button_ret.set_active(True)
        check_button_ret.set_border_width(5)
        vbox.pack_start(check_button_ret, False, True, 0)

        #
        # Set current configuration values
        #
        entry_workgroup.set_text(pyNeighborhood.parser.get_value("workgroup"))
        entry_client.set_text(pyNeighborhood.parser.get_value("client"))
        entry_lookup.set_text(pyNeighborhood.parser.get_value("lookup"))

        if pyNeighborhood.parser.get_value("msbrowse") == "True":
            hbox_workgroup.set_sensitive(False)
            check_button.set_active(True)
        else:
            hbox_workgroup.set_sensitive(True)
            check_button.set_active(False)

        if pyNeighborhood.parser.get_value("autoretrieve_ip") == "True":
            check_button_ret.set_active(True)
        else:
            check_button_ret.set_active(False)

        self.entry_workgroup = entry_workgroup
        self.entry_client = entry_client
        self.entry_lookup = entry_lookup
        self.w_checkbutton = check_button
        self.ret_checkbutton = check_button_ret
        
        #
        # Connect the checkbox toggle
        #
        self.hbox_workgroup = hbox_workgroup
        check_button.connect('toggled', self.workgroup_toggle)
        return vbox

    def smb_options(self):
        vbox = gtk.VBox()
        vbox.set_border_width(10)

        #
        # CheckButton switching CIFS usage
        #
        check_button = gtk.CheckButton("Enable SMB")
        check_button.set_active(True)
        check_button.set_border_width(5)
        check_button.connect('toggled', self.enable_smb_toggle)
        vbox.pack_start(check_button, False, True, 0)

        #
        # Mount entry
        #
        self.hbox_mount_smb = gtk.HBox(True, 10)
        self.hbox_mount_smb.set_border_width(5)
        lbl_mount_smb = gtk.Label("Mount command:")
        lbl_mount_smb.show()
        lbl_mount_smb.set_alignment(0, 0.5)
        self.hbox_mount_smb.pack_start(lbl_mount_smb, False, True, 0)

        entry_mount_smb = gtk.Entry()
        entry_mount_smb.set_max_length(50)
        entry_mount_smb.select_region(0, len(entry_mount_smb.get_text()))
        entry_mount_smb.show()
        self.hbox_mount_smb.pack_start(entry_mount_smb, True, True, 0)
        vbox.pack_start(self.hbox_mount_smb, False, True, 0)

        #
        # Umount entry
        #
        self.hbox_umount_smb = gtk.HBox(True, 10)
        self.hbox_umount_smb.set_border_width(5)
        lbl_umount_smb = gtk.Label("Unmount command:")
        lbl_umount_smb.show()
        lbl_umount_smb.set_alignment(0, 0.5)
        self.hbox_umount_smb.pack_start(lbl_umount_smb, False, True, 0)

        entry_umount_smb = gtk.Entry()
        entry_umount_smb.set_max_length(50)
        entry_umount_smb.select_region(0, len(entry_umount_smb.get_text()))
        entry_umount_smb.show()
        self.hbox_umount_smb.pack_start(entry_umount_smb, True, True, 0)
        vbox.pack_start(self.hbox_umount_smb, False, True, 0)

        #
        # Options entry
        #
        self.hbox_options_smb = gtk.HBox(True, 10)
        self.hbox_options_smb.set_border_width(5)
        lbl_options_smb = gtk.Label("Options:")
        lbl_options_smb.show()
        lbl_options_smb.set_alignment(0, 0.5)
        self.hbox_options_smb.pack_start(lbl_options_smb, False, True, 0)

        entry_options_smb = gtk.Entry()
        entry_options_smb.set_max_length(150)
        entry_options_smb.select_region(0, len(entry_options_smb.get_text()))
        entry_options_smb.show()
        self.hbox_options_smb.pack_start(entry_options_smb, True, True, 0)
        vbox.pack_start(self.hbox_options_smb, False, True, 0)

        entry_mount_smb.set_text(pyNeighborhood.parser.get_value("smb_mount"))
        entry_umount_smb.set_text(pyNeighborhood.parser.get_value("smb_umount"))
        entry_options_smb.set_text(pyNeighborhood.parser.get_value("smb_options"))

        if pyNeighborhood.parser.get_value("enable_smb") == "True":
            self.hbox_mount_smb.set_sensitive(True)
            self.hbox_umount_smb.set_sensitive(True)
            self.hbox_options_smb.set_sensitive(True)
            check_button.set_active(True)
        else:
            self.hbox_mount_smb.set_sensitive(False)
            self.hbox_umount_smb.set_sensitive(False)
            self.hbox_options_smb.set_sensitive(False)
            check_button.set_active(False)
        
        self.entry_mount_smb = entry_mount_smb
        self.entry_umount_smb = entry_umount_smb
        self.entry_options_smb = entry_options_smb
        self.smb_check_button = check_button

        return vbox

    def cifs_options(self):
        vbox = gtk.VBox()
        vbox.set_border_width(10)

        #
        # CheckButton switching CIFS usage
        #
        check_button = gtk.CheckButton("Enable CIFS")
        check_button.set_active(True)
        check_button.set_border_width(5)
        check_button.connect('toggled', self.enable_cifs_toggle)
        vbox.pack_start(check_button, False, True, 0)

        #
        # Mount entry
        #
        self.hbox_mount_cifs = gtk.HBox(True, 10)
        self.hbox_mount_cifs.set_border_width(5)
        lbl_mount_cifs = gtk.Label("Mount command:")
        lbl_mount_cifs.show()
        lbl_mount_cifs.set_alignment(0, 0.5)
        self.hbox_mount_cifs.pack_start(lbl_mount_cifs, False, True, 0)

        entry_mount_cifs = gtk.Entry()
        entry_mount_cifs.set_max_length(50)
        entry_mount_cifs.select_region(0, len(entry_mount_cifs.get_text()))
        entry_mount_cifs.show()
        self.hbox_mount_cifs.pack_start(entry_mount_cifs, True, True, 0)
        vbox.pack_start(self.hbox_mount_cifs, False, True, 0)

        #
        # Umount entry
        #
        self.hbox_umount_cifs = gtk.HBox(True, 10)
        self.hbox_umount_cifs.set_border_width(5)
        lbl_umount_cifs = gtk.Label("Unmount command:")
        lbl_umount_cifs.show()
        lbl_umount_cifs.set_alignment(0, 0.5)
        self.hbox_umount_cifs.pack_start(lbl_umount_cifs, False, True, 0)

        entry_umount_cifs = gtk.Entry()
        entry_umount_cifs.set_max_length(50)
        entry_umount_cifs.select_region(0, len(entry_umount_cifs.get_text()))
        entry_umount_cifs.show()
        self.hbox_umount_cifs.pack_start(entry_umount_cifs, True, True, 0)
        vbox.pack_start(self.hbox_umount_cifs, False, True, 0)

        #
        # Options entry
        #
        self.hbox_options_cifs = gtk.HBox(True, 10)
        self.hbox_options_cifs.set_border_width(5)
        lbl_options_cifs = gtk.Label("Options:")
        lbl_options_cifs.show()
        lbl_options_cifs.set_alignment(0, 0.5)
        self.hbox_options_cifs.pack_start(lbl_options_cifs, False, True, 0)

        entry_options_cifs = gtk.Entry()
        entry_options_cifs.set_max_length(150)
        entry_options_cifs.select_region(0, len(entry_options_cifs.get_text()))
        entry_options_cifs.show()
        self.hbox_options_cifs.pack_start(entry_options_cifs, True, True, 0)
        vbox.pack_start(self.hbox_options_cifs, False, True, 0)

        entry_mount_cifs.set_text(pyNeighborhood.parser.get_value("cifs_mount"))
        entry_umount_cifs.set_text(pyNeighborhood.parser.get_value("cifs_umount"))
        entry_options_cifs.set_text(pyNeighborhood.parser.get_value("cifs_options"))

        if pyNeighborhood.parser.get_value("enable_cifs") == "True":
            self.hbox_mount_cifs.set_sensitive(True)
            self.hbox_umount_cifs.set_sensitive(True)
            self.hbox_options_cifs.set_sensitive(True)
            check_button.set_active(True)
        else:
            self.hbox_mount_cifs.set_sensitive(False)
            self.hbox_umount_cifs.set_sensitive(False)
            self.hbox_options_cifs.set_sensitive(False)
            check_button.set_active(False)
        
        self.entry_mount_cifs = entry_mount_cifs
        self.entry_umount_cifs = entry_umount_cifs
        self.entry_options_cifs = entry_options_cifs
        self.cifs_check_button = check_button

        return vbox
    
    #
    # Description af the filemanager tab
    #
    def filemanagers_options(self):
        hbox = gtk.HBox()

        #
        # Define a listore with filemanager names
        #
        self.liststore = gtk.ListStore(str)
        self.treeview = gtk.TreeView(self.liststore)
        self.treeview.set_headers_visible(False)

        cell = gtk.CellRendererText()
        tvcolumn = gtk.TreeViewColumn("Command", cell)
        tvcolumn.add_attribute(cell, 'text', 0)
        self.treeview.append_column(tvcolumn)

        for f_name in self.filemanagers_old:
            iter = self.liststore.append(None)
            self.liststore.set(iter, 0, f_name)

        scrolledwindow = gtk.ScrolledWindow()
        scrolledwindow.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        scrolledwindow.add(self.treeview)

        vbox_scrolledwindow = gtk.VBox()
        vbox_scrolledwindow.set_size_request(250,-1)
        vbox_scrolledwindow.pack_start(scrolledwindow)
        vbox_scrolledwindow.set_border_width(15)
        hbox.pack_start(vbox_scrolledwindow)

        #
        # Add buttons
        #
        spacing = 40
        frame = gtk.Frame(None)

        bbox = gtk.VButtonBox()

        bbox.set_border_width(5)
        bbox.set_layout(gtk.BUTTONBOX_START)
        bbox.set_spacing(spacing)
        frame.add(bbox)

        button_add = gtk.Button(label = "Add...")
        button_add.connect("pressed", self.add_cb)
        bbox.add(button_add)

        button_edit = gtk.Button("Edit...")
        button_edit.connect("pressed", self.edit_cb)
        bbox.add(button_edit)

        button_remove = gtk.Button("Remove")
        button_remove.connect("pressed", self.remove_cb)
        bbox.add(button_remove)

        vbox_buttons = gtk.VBox()
        vbox_buttons.set_border_width(10)
        vbox_buttons.pack_start(frame, padding = 5)
        hbox.pack_start(vbox_buttons)

        return hbox
    
    #
    # Main preferences window
    #
    def options(self):
        self.window = gtk.Dialog("Preferences",
                         self.parent,
                         gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                         (gtk.STOCK_OK, gtk.RESPONSE_OK,
                         gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))
        self.window.set_resizable(False)

        #
        # Create notebook with different configuration tabs
        #
        self.notebook = gtk.Notebook()
        label_general = gtk.Label()
        label_general.set_text("General")
        label_network = gtk.Label()
        label_network.set_text("Network")
        label_smb = gtk.Label()
        label_smb.set_text("SMB")
        label_cifs = gtk.Label()
        label_cifs.set_text("CIFS")
        label_filemanagers = gtk.Label()
        label_filemanagers.set_text("File Managers")

        #
        # vbox with notebook
        #
        # General
        self.note_vbox_general = gtk.VBox(False, 1)
        self.note_vbox_general.set_border_width(1)
        self.note_vbox_general.show()

        # Network
        self.note_vbox_network = gtk.VBox(False, 1)
        self.note_vbox_network.set_border_width(1)
        self.note_vbox_network.show()

        # SMB
        self.note_vbox_smb = gtk.VBox(False, 1)
        self.note_vbox_smb.set_border_width(1)
        self.note_vbox_smb.show()

        # CIFS
        self.note_vbox_cifs = gtk.VBox(False, 1)
        self.note_vbox_cifs.set_border_width(1)
        self.note_vbox_cifs.show()

        # CIFS
        self.note_vbox_filemanagers = gtk.VBox(False, 1)
        self.note_vbox_filemanagers.set_border_width(1)
        self.note_vbox_filemanagers.show()
        
        #
        # Add widgets to notebook
        #
        # General
        view_general = self.general_options()
        self.note_vbox_general.pack_start(view_general)
        # Network
        view_network = self.network_options()
        self.note_vbox_network.pack_start(view_network)
        # SMB
        view_smb = self.smb_options()
        self.note_vbox_smb.pack_start(view_smb)
        # CIFS
        view_cifs = self.cifs_options()
        self.note_vbox_cifs.pack_start(view_cifs)
        # Filemanager
        view_filemanagers = self.filemanagers_options()
        self.note_vbox_filemanagers.pack_start(view_filemanagers)

        #
        # Append all the pages
        #
        self.notebook.append_page(self.note_vbox_general, label_general)
        self.notebook.append_page(self.note_vbox_network, label_network)
        self.notebook.append_page(self.note_vbox_smb, label_smb)
        self.notebook.append_page(self.note_vbox_cifs, label_cifs)
        self.notebook.append_page(self.note_vbox_filemanagers, label_filemanagers)

        #
        # show the notebook
        #
        self.notebook.set_show_tabs(True)
        self.notebook.show()

        self.window.vbox.pack_start(self.notebook, True, True, 0)
        self.window.show_all()
        response = self.window.run()
        newoptdict = {}
        if response == gtk.RESPONSE_OK: 
            #
            # Read a new list of file managers
            #
            # Create filemanagers list entry
            iter = self.liststore.get_iter_first()
            if iter == None:
                self.filemanagers_new = self.filemanagers_old
            else:
                first_fm = self.unpad(self.liststore.get_value(iter, 0))
                if first_fm == '':
                    self.file_managers_new = self.filemanagers_old
                else:
                    self.filemanagers_new.append(first_fm)
                    while iter != None:
                        iter = self.liststore.iter_next(iter)
                        if iter != None:
                            self.filemanagers_new.append(self.unpad(self.liststore.get_value(iter, 0)))
            # Create options dictionary entry
            self.optdict_new["file_managers"] = string.join(self.filemanagers_new, "|")

            #
            # Read general options
            #
            self.optdict_new["user"]            = self.unpad(self.m_user.get_text())
            self.optdict_new["password"]        = self.unpad(self.m_password.get_text())
            self.optdict_new["mount_directory"] = self.path_validator(self.unpad(self.m_folder.get_text()))
            if self.m_checkbutton.get_active() == True:
                self.optdict_new["anonymous"] = "True"
            else:
                self.optdict_new["anonymous"] = "False"
            
            if self.check_button_prompt.get_active() == True:
                self.optdict_new["enable_default"] = "True"
            else:
                self.optdict_new["enable_default"] = "False"

            if self.m_checkbutton_rem.get_active() == True:
                self.optdict_new["delete_dirs"] = "True"
            else:
                self.optdict_new["delete_dirs"] = "False"
            
            #
            # Read network options
            #
            if self.w_checkbutton.get_active() == True:
                self.optdict_new["msbrowse"] = "True"
            else:
                self.optdict_new["msbrowse"] = "False"
            self.optdict_new["workgroup"] = self.unpad(self.entry_workgroup.get_text())
            self.optdict_new["client"]    = self.unpad(self.entry_client.get_text())
            self.optdict_new["lookup"]    = self.unpad(self.entry_lookup.get_text())
            if self.ret_checkbutton.get_active() == True:
                self.optdict_new["autoretrieve_ip"] = "True"
            else:
                self.optdict_new["autoretrieve_ip"] = "False"

            #
            # Read SMB options
            #
            self.optdict_new["smb_mount"]   = self.unpad(self.entry_mount_smb.get_text())
            self.optdict_new["smb_umount"]  = self.unpad(self.entry_umount_smb.get_text())
            self.optdict_new["smb_options"] = self.unpad(self.entry_options_smb.get_text())
            if self.smb_check_button.get_active() == True:
                self.optdict_new["enable_smb"] = "True"
            else:
                self.optdict_new["enable_smb"] = "False"

            #
            # Read CIFS options
            #
            self.optdict_new["cifs_mount"]   = self.unpad(self.entry_mount_cifs.get_text())
            self.optdict_new["cifs_umount"]  = self.unpad(self.entry_umount_cifs.get_text())
            self.optdict_new["cifs_options"] = self.unpad(self.entry_options_cifs.get_text())
            if self.cifs_check_button.get_active() == True:
                self.optdict_new["enable_cifs"] = "True"
            else:
                self.optdict_new["enable_cifs"] = "False"

            self.window.destroy()
            return self.optdict_new
        if response == gtk.RESPONSE_CANCEL: 
            self.window.destroy()
            return None
        self.window.destroy()

    #
    # Constructor
    #
    def __init__(self, parent):
        self.filemanagers_old = pyNeighborhood.parser.file_managers
        self.optdict_new = {}
        self.filemanagers_new = []
        self.parent = parent

