/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadInputRegistersResponse;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.InputRegister;
import net.wimpi.modbus.procimg.ProcessImage;

public final class ReadInputRegistersRequest
extends ModbusRequest {
    private int m_Reference;
    private int m_WordCount;

    public ReadInputRegistersRequest() {
        this.setFunctionCode(4);
        this.setDataLength(4);
    }

    public ReadInputRegistersRequest(int ref, int count) {
        this.setFunctionCode(4);
        this.setDataLength(4);
        this.setReference(ref);
        this.setWordCount(count);
    }

    public ModbusResponse createResponse() {
        ReadInputRegistersResponse response = null;
        InputRegister[] inpregs = null;
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            inpregs = procimg.getInputRegisterRange(this.getReference(), this.getWordCount());
        }
        catch (IllegalAddressException iaex) {
            return this.createExceptionResponse(2);
        }
        response = new ReadInputRegistersResponse(inpregs);
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        } else {
            response.setHeadless();
        }
        response.setUnitID(this.getUnitID());
        response.setFunctionCode(this.getFunctionCode());
        return response;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setWordCount(int count) {
        this.m_WordCount = count;
    }

    public int getWordCount() {
        return this.m_WordCount;
    }

    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.m_Reference);
        dout.writeShort(this.m_WordCount);
    }

    public void readData(DataInput din) throws IOException {
        this.m_Reference = din.readUnsignedShort();
        this.m_WordCount = din.readUnsignedShort();
    }
}

