/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipLong;
import org.apache.tools.zip.ZipOutputStream;
import org.apache.tools.zip.ZipShort;

public class ZipFile {
    private static final int HASH_SIZE = 509;
    private static final int SHORT = 2;
    private static final int WORD = 4;
    private static final int NIBLET_MASK = 15;
    private static final int BYTE_SHIFT = 8;
    private static final int POS_0 = 0;
    private static final int POS_1 = 1;
    private static final int POS_2 = 2;
    private static final int POS_3 = 3;
    private Hashtable entries = new Hashtable(509);
    private Hashtable nameMap = new Hashtable(509);
    private String encoding = null;
    private RandomAccessFile archive;
    private static final int CFH_LEN = 42;
    private static final int MIN_EOCD_SIZE = 22;
    private static final int CFD_LOCATOR_OFFSET = 16;
    private static final long LFH_OFFSET_FOR_FILENAME_LENGTH = 26L;

    public ZipFile(File f) throws IOException {
        this(f, null);
    }

    public ZipFile(String name) throws IOException {
        this(new File(name), null);
    }

    public ZipFile(String name, String encoding) throws IOException {
        this(new File(name), encoding);
    }

    public ZipFile(File f, String encoding) throws IOException {
        this.encoding = encoding;
        this.archive = new RandomAccessFile(f, "r");
        try {
            this.populateFromCentralDirectory();
            this.resolveLocalFileHeaderData();
        }
        catch (IOException e) {
            try {
                this.archive.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw e;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() throws IOException {
        this.archive.close();
    }

    public static void closeQuietly(ZipFile zipfile) {
        if (zipfile != null) {
            try {
                zipfile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Enumeration getEntries() {
        return this.entries.keys();
    }

    public ZipEntry getEntry(String name) {
        return (ZipEntry)this.nameMap.get(name);
    }

    public InputStream getInputStream(ZipEntry ze) throws IOException, ZipException {
        OffsetEntry offsetEntry = (OffsetEntry)this.entries.get(ze);
        if (offsetEntry == null) {
            return null;
        }
        long start = offsetEntry.dataOffset;
        BoundedInputStream bis = new BoundedInputStream(start, ze.getCompressedSize());
        switch (ze.getMethod()) {
            case 0: {
                return bis;
            }
            case 8: {
                bis.addDummy();
                return new InflaterInputStream(bis, new Inflater(true));
            }
        }
        throw new ZipException("Found unsupported compression method " + ze.getMethod());
    }

    private void populateFromCentralDirectory() throws IOException {
        this.positionAtCentralDirectory();
        byte[] cfh = new byte[42];
        byte[] signatureBytes = new byte[4];
        this.archive.readFully(signatureBytes);
        long sig = ZipLong.getValue(signatureBytes);
        long cfhSig = ZipLong.getValue(ZipOutputStream.CFH_SIG);
        while (sig == cfhSig) {
            this.archive.readFully(cfh);
            int off = 0;
            ZipEntry ze = new ZipEntry();
            int versionMadeBy = ZipShort.getValue(cfh, off);
            off += 2;
            ze.setPlatform(versionMadeBy >> 8 & 0xF);
            ze.setMethod(ZipShort.getValue(cfh, off += 4));
            long time = ZipFile.dosToJavaTime(ZipLong.getValue(cfh, off += 2));
            ze.setTime(time);
            ze.setCrc(ZipLong.getValue(cfh, off += 4));
            ze.setCompressedSize(ZipLong.getValue(cfh, off += 4));
            ze.setSize(ZipLong.getValue(cfh, off += 4));
            int fileNameLen = ZipShort.getValue(cfh, off += 4);
            int extraLen = ZipShort.getValue(cfh, off += 2);
            int commentLen = ZipShort.getValue(cfh, off += 2);
            off += 2;
            ze.setInternalAttributes(ZipShort.getValue(cfh, off += 2));
            ze.setExternalAttributes(ZipLong.getValue(cfh, off += 2));
            byte[] fileName = new byte[fileNameLen];
            this.archive.readFully(fileName);
            ze.setName(this.getString(fileName));
            OffsetEntry offset = new OffsetEntry();
            offset.headerOffset = ZipLong.getValue(cfh, off += 4);
            this.entries.put(ze, offset);
            this.nameMap.put(ze.getName(), ze);
            this.archive.skipBytes(extraLen);
            byte[] comment = new byte[commentLen];
            this.archive.readFully(comment);
            ze.setComment(this.getString(comment));
            this.archive.readFully(signatureBytes);
            sig = ZipLong.getValue(signatureBytes);
        }
    }

    private void positionAtCentralDirectory() throws IOException {
        boolean found = false;
        long off = this.archive.length() - 22L;
        if (off >= 0L) {
            this.archive.seek(off);
            byte[] sig = ZipOutputStream.EOCD_SIG;
            int curr = this.archive.read();
            while (curr != -1) {
                if (curr == sig[0] && (curr = this.archive.read()) == sig[1] && (curr = this.archive.read()) == sig[2] && (curr = this.archive.read()) == sig[3]) {
                    found = true;
                    break;
                }
                this.archive.seek(--off);
                curr = this.archive.read();
            }
        }
        if (!found) {
            throw new ZipException("archive is not a ZIP archive");
        }
        this.archive.seek(off + 16L);
        byte[] cfdOffset = new byte[4];
        this.archive.readFully(cfdOffset);
        this.archive.seek(ZipLong.getValue(cfdOffset));
    }

    private void resolveLocalFileHeaderData() throws IOException {
        Enumeration e = this.getEntries();
        while (e.hasMoreElements()) {
            ZipEntry ze = (ZipEntry)e.nextElement();
            OffsetEntry offsetEntry = (OffsetEntry)this.entries.get(ze);
            long offset = offsetEntry.headerOffset;
            this.archive.seek(offset + 26L);
            byte[] b = new byte[2];
            this.archive.readFully(b);
            int fileNameLen = ZipShort.getValue(b);
            this.archive.readFully(b);
            int extraFieldLen = ZipShort.getValue(b);
            this.archive.skipBytes(fileNameLen);
            byte[] localExtraData = new byte[extraFieldLen];
            this.archive.readFully(localExtraData);
            ze.setExtra(localExtraData);
            offsetEntry.dataOffset = offset + 26L + 2L + 2L + (long)fileNameLen + (long)extraFieldLen;
        }
    }

    protected static Date fromDosTime(ZipLong zipDosTime) {
        long dosTime = zipDosTime.getValue();
        return new Date(ZipFile.dosToJavaTime(dosTime));
    }

    private static long dosToJavaTime(long dosTime) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, (int)(dosTime >> 25 & 0x7FL) + 1980);
        cal.set(2, (int)(dosTime >> 21 & 0xFL) - 1);
        cal.set(5, (int)(dosTime >> 16) & 0x1F);
        cal.set(11, (int)(dosTime >> 11) & 0x1F);
        cal.set(12, (int)(dosTime >> 5) & 0x3F);
        cal.set(13, (int)(dosTime << 1) & 0x3E);
        return cal.getTime().getTime();
    }

    protected String getString(byte[] bytes) throws ZipException {
        if (this.encoding == null) {
            return new String(bytes);
        }
        try {
            return new String(bytes, this.encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new ZipException(uee.getMessage());
        }
    }

    private class BoundedInputStream
    extends InputStream {
        private long remaining;
        private long loc;
        private boolean addDummyByte = false;

        BoundedInputStream(long start, long remaining) {
            this.remaining = remaining;
            this.loc = start;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            if (this.remaining-- <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            RandomAccessFile randomAccessFile = ZipFile.this.archive;
            synchronized (randomAccessFile) {
                ZipFile.this.archive.seek(this.loc++);
                return ZipFile.this.archive.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    b[off] = 0;
                    return 1;
                }
                return -1;
            }
            if (len <= 0) {
                return 0;
            }
            if ((long)len > this.remaining) {
                len = (int)this.remaining;
            }
            int ret = -1;
            RandomAccessFile randomAccessFile = ZipFile.this.archive;
            synchronized (randomAccessFile) {
                ZipFile.this.archive.seek(this.loc);
                ret = ZipFile.this.archive.read(b, off, len);
            }
            if (ret > 0) {
                this.loc += (long)ret;
                this.remaining -= (long)ret;
            }
            return ret;
        }

        void addDummy() {
            this.addDummyByte = true;
        }
    }

    private static final class OffsetEntry {
        private long headerOffset = -1L;
        private long dataOffset = -1L;

        private OffsetEntry() {
        }
    }
}

