/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import jline.Terminal;

public class UnixTerminal
extends Terminal {
    public static final short ARROW_START = 27;
    public static final short ARROW_PREFIX = 91;
    public static final short ARROW_LEFT = 68;
    public static final short ARROW_RIGHT = 67;
    public static final short ARROW_UP = 65;
    public static final short ARROW_DOWN = 66;
    private Map terminfo;
    private int width = -1;
    private int height = -1;

    public void initializeTerminal() throws IOException, InterruptedException {
        final String string = UnixTerminal.stty("-g");
        if (string.length() == 0 || string.indexOf("=") == -1 && string.indexOf(":") == -1) {
            throw new IOException("Unrecognized stty code: " + string);
        }
        UnixTerminal.stty("-icanon min 1");
        UnixTerminal.stty("-echo");
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void start() {
                    try {
                        UnixTerminal.stty(string);
                    }
                    catch (Exception exception) {
                        UnixTerminal.this.consumeException(exception);
                    }
                }
            });
        }
        catch (AbstractMethodError abstractMethodError) {
            this.consumeException(abstractMethodError);
        }
    }

    public int readVirtualKey(InputStream inputStream) throws IOException {
        int n = this.readCharacter(inputStream);
        if (n == 27 && (n = this.readCharacter(inputStream)) == 91) {
            n = this.readCharacter(inputStream);
            if (n == 65) {
                return 16;
            }
            if (n == 66) {
                return 14;
            }
            if (n == 68) {
                return 2;
            }
            if (n == 67) {
                return 6;
            }
        }
        return n;
    }

    private void consumeException(Throwable throwable) {
    }

    public boolean isSupported() {
        return true;
    }

    public boolean getEcho() {
        return false;
    }

    public int getTerminalWidth() {
        if (this.width != -1) {
            return this.width;
        }
        int n = 80;
        try {
            String string = UnixTerminal.stty("size");
            if (string.length() != 0 && string.indexOf(" ") != -1) {
                n = Integer.parseInt(string.substring(string.indexOf(" ") + 1));
            }
        }
        catch (Exception exception) {
            this.consumeException(exception);
        }
        this.width = n;
        return this.width;
    }

    public int getTerminalHeight() {
        if (this.height != -1) {
            return this.height;
        }
        int n = 24;
        try {
            String string = UnixTerminal.stty("size");
            if (string.length() != 0 && string.indexOf(" ") != -1) {
                n = Integer.parseInt(string.substring(0, string.indexOf(" ")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.height = n;
        return this.height;
    }

    private static String stty(String string) throws IOException, InterruptedException {
        return UnixTerminal.exec("stty " + string + " < /dev/tty").trim();
    }

    private static String exec(String string) throws IOException, InterruptedException {
        return UnixTerminal.exec(new String[]{"sh", "-c", string});
    }

    private static String exec(String[] stringArray) throws IOException, InterruptedException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Process process = Runtime.getRuntime().exec(stringArray);
        InputStream inputStream = process.getInputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        inputStream = process.getErrorStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        process.waitFor();
        String string = new String(byteArrayOutputStream.toByteArray());
        return string;
    }
}

