/* PureAdmin
 * Copyright (C) 2003 Isak Savo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Usermanager functions
 *
 * Copyright (C) 2003 Isak Savo
 */
#ifndef __USR_MANAGER_H__
#define __USR_MANAGER_H__
#include <unistd.h>
#include <sys/types.h>
#include "globals.h"

#define PW_LINE_SEP ":"
#define PW_LINE_SEP_CH ':'

#ifndef PW_LINE_COMMENT
# define PW_LINE_COMMENT '#'
#endif

typedef struct PWInfo_ {
	gchar *login;
	gchar *pwd;
	uid_t uid;
	gid_t gid;
	gboolean chroot;
	gchar *home;
	gchar *gecos;
	gulong bw_dl;
	gulong bw_ul;
	guint quota_files;
	guint64 quota_size;
	guint ul_ratio;
	guint dl_ratio;
	gchar *allow_local_ip;
	gchar *deny_local_ip;    
	gchar *allow_client_ip;
	gchar *deny_client_ip;
	guint time_begin;
	guint time_end;
	guint per_user_max;
} PWInfo;

typedef struct PAvailableUser_ {
	gchar *login;
	gchar *realname;
} PAvailableUser;
    
struct usrman_info_widgets {
	GtkWidget *login, *realname, *home, *root, *pwd;
	GtkWidget *chk_chroot, *e_uid, *e_gid;
	GtkWidget *bw_ul, *bw_dl, *quota_files, *quota_size;
	GtkWidget *ul_ratio, *dl_ratio, *timelimit;
	GtkWidget *simsess;
	GtkWidget *loc_allow, *loc_deny, *cli_allow, *cli_deny;
	GtkWidget *btn_pwchange, *btn_savechanges, *btn_cancelchanges;
	GtkWidget *lbl_invalid_gid, *lbl_invalid_uid;
	GtkWidget *btn_browse_homedir, *btn_browse_fakeroot;
};

enum
{
	COL_USRMAN_ICON,
	COL_USRMAN_LOGIN,
	COL_USRMAN_REALNAME,
	N_USRMAN_COLUMNS
};

#define PUREADMIN_USERMANAGER_ERROR g_quark_from_static_string ("PUREADMIN_USR")

typedef enum
{
	PA_USR_ERROR_COMMAND_NOT_FOUND,
	PA_USR_ERROR_FILE_NOT_FOUND,
	PA_USR_ERROR_PERMISSION_DENIED,
	PA_USR_ERROR_USER_NOT_FOUND,
	PA_USR_ERROR_INVALID_FIELD,
	PA_USR_ERROR_FAILED
} PureadminUsermanagerError;

GtkWidget *usr_init_usermanager_window (GtkWidget *parent_window);

gint usr_fill_users_list (void);
void usr_widgets_set_active_state (gboolean active);
gboolean usr_widgets_set_info (gchar *user);
gboolean usr_user_exists (const gchar *user);
void usr_select_user (const gchar *user);
gboolean usr_select_first_user (void);
gboolean usr_manager_check_prerequisites (void);
gboolean usr_remove_user (const gchar *user, GError **err);
gboolean usr_add_user (const gchar *user, const gchar *passwd, GError **err);
gboolean usr_save_user_info (GError **err);
GList *usr_get_available_users (GError **err);

#endif /* __USR_MANAGER_H__ */
