#include "config.h"
#include "kanji.h"

void
usage P1C(const_string, str)
{
  fprintf (stderr, "Try `%s --help' for more information.\n", str);
  uexit (1);
}

void
usagehelp P2C(const_string*, message, const_string, bug_email)
{
  if (!bug_email)
    bug_email = "hideyuki@sat.t.u-tokyo.ac.jp";

  while (*message) {
    fprintf(stdout, "%s\n", *message);
    ++message;
  }
  fprintf(stdout, "\nEmail bug reports to %s.\n", bug_email);
  fflush(stdout);
  uexit (0);
}

void
printversionandexit P3C(const_string, banner,
                        const_string, copyright_holder,  const_string, author)
{
  extern const_string local_maintainer;   /* from maintain.h */
  extern string versionstring;  /* from web2c/lib/version.c */
  extern KPSEDLL string kpathsea_version_string;/* from kpathsea/version.c */
  string prog_name;
  extern string based_prog_name;
  unsigned len;

#if TERM_CODE == JIS
  string term_code=" (JIS)";
#elif TERM_CODE == SJIS
  string term_code=" (SJIS)";
#else
  string term_code=" (EUC)";
#endif

  const_string prog_name_end = strchr (banner, ',');
  const_string prog_version = prog_name_end + sizeof("Version") + 2;
  len = prog_name_end - banner - sizeof ("This is");
  prog_name = (string)xmalloc (len + 1);
  strncpy (prog_name, banner + sizeof ("This is"), len);
  prog_name[len] = 0;

  /* The Web2c version string starts with a space.  */
  fprintf (stdout, "%s %s%s%s\n",
     prog_name, prog_version, term_code, versionstring);
  fputs (kpathsea_version_string, stdout);
  putc('\n', stdout);

  if (copyright_holder) {
    fprintf (stdout, "Copyright (C) 1997-2004 %s.\n", copyright_holder);
    if (!author)
      author = copyright_holder;
  }

  fputs ("Kpathsea is copyright (C) 1999-2004 Free Software Foundation, Inc.\n",
	 stdout);

  fputs ("There is NO warranty.  You may redistribute this software\n", stdout);
  fputs ("under the terms of the pTeX copyright.  For more information\n", stdout);
  fputs ("about these matters, see the file named COPYING of pTeX.\n", stdout);
  putc('\n', stdout);
  fprintf (stdout,"Note: %s is built using Web2C, and Web2C is licensed\n", prog_name);
  fputs ("under the GNU General Public Licence.  For more information,\n",stdout);
  fputs ("see the file named COPYING of Web2C.\n",stdout);
  putc ('\n',stdout);
  fflush(stdout);
  uexit (0);
}
