
import os, sys, urllib, platform, re
import configobj, validate

#GET PATHS------------------
join = os.path.join

class Preferences:
    def __init__(self):
        self.userPrefsCfg=None#the config object for the preferences
        self.prefsSpec=None#specifications for the above
        self.appDataCfg=None #the config object for the app data (users don't need to see)

        self.general=None
        self.coder=None
        self.builder=None
        self.connections=None
        self.paths = {}  # this will remain a dictionary
        self.keys = {}  # does not remain a dictionary

        self.getPaths()
        self.loadAll()

        if self.userPrefsCfg['app']['resetPrefs']:
            self.resetPrefs()

    def resetPrefs(self):
        """removes userPrefs.cfg, does not touch appData.cfg
        """
        userCfg = join(self.paths['userPrefsDir'], 'userPrefs.cfg')
        try:
            os.unlink(userCfg)
            #log.info('Removed %s (as requested by pref)' % userCfg) # need to import log into prefs for this
        except:
            print "Could not remove prefs file '%s'; (try doing it manually?)" % userCfg
            #log.info('Could not remove %s (as requested by pref)' % userCfg)
        self.loadAll() # reloads, now getting all from .spec

    def getPaths(self):
        #on mac __file__ might be a local path, so make it the full path
        thisFileAbsPath= os.path.abspath(__file__)
        prefSpecDir = os.path.split(thisFileAbsPath)[0]
        dirPsychoPy = os.path.split(prefSpecDir)[0]
        
        #path to Resources (icons etc)
        dirApp = join(dirPsychoPy, 'app')
        if os.path.isdir(join(dirApp, 'Resources')):
            dirResources = join(dirApp, 'Resources')
        else:dirResources = dirApp
        
        self.paths['psychopy']=dirPsychoPy
        self.paths['appDir']=dirApp
        self.paths['appFile']=join(dirApp, 'PsychoPy.py')
        self.paths['demos'] = join(dirPsychoPy, 'demos')
        self.paths['resources']=dirResources
        self.paths['tests'] = join(dirPsychoPy, 'tests')
        
        if sys.platform=='win32':
            self.paths['prefsSpecFile']= join(prefSpecDir,'Windows.spec')
            self.paths['userPrefsDir']= join(os.environ['APPDATA'],'psychopy2')
        else:#platform.system gives nicer names, but no good on standalone vista/win7
            self.paths['prefsSpecFile']= join(prefSpecDir,platform.system()+'.spec')
            self.paths['userPrefsDir']= join(os.environ['HOME'],'.psychopy2')
        
    def loadAll(self):
        """Load the user prefs and the application data
        """
        self._validator=validate.Validator()
        
        # note: self.paths['userPrefsDir'] gets set in loadSitePrefs()
        self.paths['appDataFile'] = join(self.paths['userPrefsDir'], 'appData.cfg')
        self.paths['userPrefsFile'] = join(self.paths['userPrefsDir'], 'userPrefs.cfg')
        
        # If PsychoPy is tucked away by Py2exe in library.zip, the preferences file
        # cannot be found. This hack is an attempt to fix this.
        if "\\library.zip\\psychopy\\preferences\\" in self.paths["prefsSpecFile"]:
            self.paths["prefsSpecFile"] = self.paths["prefsSpecFile"].replace("\\library.zip\\psychopy\\preferences\\", "\\resources\\")                
        
        self.userPrefsCfg = self.loadUserPrefs()
        self.appDataCfg = self.loadAppData()
        self.validate()
        
        #simplify namespace
        self.general=self.userPrefsCfg['general']
        self.app = self.userPrefsCfg['app']
        self.coder=self.userPrefsCfg['coder']
        self.builder=self.userPrefsCfg['builder']
        self.connections=self.userPrefsCfg['connections']
        self.keys=self.userPrefsCfg['keyBindings']
        self.appData = self.appDataCfg
        
        # keybindings:
        self.keys = self.userPrefsCfg['keyBindings']
        
        # connections:
        if self.connections['autoProxy']: self.connections['proxy'] = self.getAutoProxy()

    def loadUserPrefs(self):
        """load user prefs, if any; don't save to a file because doing so will
        break easy_install. Saving to files within the psychopy/ is fine, eg for
        key-bindings, but outside it (where user prefs will live) is not allowed
        by easy_install (security risk)
        """
        self.prefsSpec = configobj.ConfigObj(self.paths['prefsSpecFile'], encoding='UTF8', list_values=False)
        
        #check/create path for user prefs
        if not os.path.isdir(self.paths['userPrefsDir']):
            try: os.makedirs(self.paths['userPrefsDir'])
            except:
                print "Preferences.py failed to create folder %s. Settings will be read-only" % self.paths['userPrefsDir']
        #then get the configuration file
        cfg = configobj.ConfigObj(self.paths['userPrefsFile'], configspec=self.prefsSpec)
        #cfg.validate(self._validator, copy=False)  # merge first then validate
        # don't cfg.write(), see explanation above
        return cfg
    def saveUserPrefs(self):
        """Validate and save the various setting to the appropriate files (or discard, in some cases)
        """
        self.validate()
        if not os.path.isdir(self.paths['userPrefsDir']):
            os.makedirs(self.paths['userPrefsDir'])
        self.userPrefsCfg.write()                

    def loadAppData(self):
        #fetch appData too against a config spec
        appDataSpec = configobj.ConfigObj(join(self.paths['appDir'], 'appData.spec'), encoding='UTF8', list_values=False)
        cfg = configobj.ConfigObj(self.paths['appDataFile'], configspec=appDataSpec)
        resultOfValidate = cfg.validate(self._validator, copy=True, preserve_errors=True)
        self.restoreBadPrefs(cfg, resultOfValidate)
        return cfg
    def saveAppData(self):
        """Save the various setting to the appropriate files (or discard, in some cases)
        """
        self.appDataCfg.validate(self._validator, copy=True)#copy means all settings get saved
        if not os.path.isdir(self.paths['userPrefsDir']):
            os.makedirs(self.paths['userPrefsDir'])
        self.appDataCfg.write()

    def validate(self):
        """Validate (user) preferences and reset invalid settings to defaults"""
        resultOfValidate = self.userPrefsCfg.validate(self._validator, copy=True)
        self.restoreBadPrefs(self.userPrefsCfg, resultOfValidate)
    def restoreBadPrefs(self, cfg, resultOfValidate):
        if resultOfValidate == True:
            return
        vtor = validate.Validator()
        for (section_list, key, _) in configobj.flatten_errors(cfg, resultOfValidate):
            if key is not None:
                cfg[', '.join(section_list)][key] = vtor.get_default_value(cfg.configspec[', '.join(section_list)][key])
            else:
                print "Section [%s] was missing in file '%s'" % (', '.join(section_list), cfg.filename)
        
    def getAutoProxy(self):
        """Fetch the proxy from the the system environment variables
        """
        if urllib.getproxies().has_key('http'):
            return urllib.getproxies()['http']
        else:
            return ""

