# -*- perl -*-
# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: compiler.t,v 1.3 2000/12/10 23:08:19 muaddib Exp $

use strict;
use Test;
use Data::Dumper;
use PSP::Compiler;

-d "pile-src" or chdir "t";

plan tests => 12;

my $compiler;

ok $compiler = 
  PSP::Compiler->new(inputs      => ["pile-src"],
		     output      => "output.pile",
		     verbose     => 0,
		     includepath => ['include'],
		     pile_name   => "foofly");

ok !$compiler->compile();

ok !$compiler->{verbose};
ok $compiler->{output} eq 'output.pile';
ok $compiler->{pile_name} => 'foofly';

ok 0 != $compiler->{seed};
ok 0 == $compiler->{n_errors};

ok 1 == @{$compiler->{includepath}};
ok 2 == @{$compiler->{submit_ids}};
ok 0 == keys(%{$compiler->{fieldspaces}});
ok 3 == @{$compiler->{depends}};
ok 3 == keys(%{$compiler->{depends_h}});

#print Dumper($compiler);
