# -*- perl -*-
# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: utils.t,v 1.1 2000/11/23 23:36:18 muaddib Exp $

use strict;
use Test;
use HTMLIO::Utils qw(:all);

plan tests => 29;

my %attr = ('type'=>"hidden",
	    'name'=>"test",
	    'value'=>"haha");

ok html_tag('input',\%attr,[qw(type name)]) eq
  '<input type="hidden" name="test" value="haha">';
ok html_tag('input',\%attr,[qw(type value)]) eq
  '<input type="hidden" value="haha" name="test">';
ok html_tag('input',\%attr,[qw(value name)]) eq
  '<input value="haha" name="test" type="hidden">';

ok delete $attr{value};

ok html_tag('input',\%attr,[qw(type name)]) eq
  '<input type="hidden" name="test">';
ok html_tag('input',\%attr,[qw(type value)]) eq
  '<input type="hidden" name="test">';
ok html_tag('input',\%attr,[qw(value name)]) eq
  '<input name="test" type="hidden">';

ok delete $attr{type};

ok html_tag('input',\%attr,[qw(type name)]) eq '<input name="test">';
ok html_tag('input',\%attr,[qw(type value)]) eq '<input name="test">';
ok html_tag('input',\%attr,[qw(value name)]) eq '<input name="test">';

ok delete $attr{name};

ok html_tag('input',\%attr,[qw(type name)]) eq '<input>';
ok html_tag('input',\%attr,[qw(type value)]) eq '<input>';
ok html_tag('input',\%attr,[qw(value name)]) eq '<input>';

my ($name,$type,$data,$slice,$join,$attr);
$name = "test";

ok stnd_html_input($name) eq '<input name="test" type="text" value="">';
ok stnd_html_input($name,"foo") eq '<input name="test" type="foo" value="">';
ok stnd_html_input($name,'"this"') eq
  '<input name="test" type="&quot;this&quot;" value="">';

$type = "text";
$data = [qw(boy ball)];
ok stnd_html_input($name,$type,$data) eq 
  ('<input name="test" type="text" value="boy">'."\n".
   '<input name="test" type="text" value="ball">');
push @$data, 'bat';
ok stnd_html_input($name,$type,$data) eq 
  ('<input name="test" type="text" value="boy">'."\n".
   '<input name="test" type="text" value="ball">'."\n".
   '<input name="test" type="text" value="bat">');

$slice = [1];
ok stnd_html_input($name,$type,$data,$slice) eq 
  '<input name="test" type="text" value="ball">';

$slice = [qw(0 2)];
ok stnd_html_input($name,$type,$data,$slice) eq 
  ('<input name="test" type="text" value="boy">'."\n".
   '<input name="test" type="text" value="bat">');

$join = ",";
ok stnd_html_input($name,$type,$data,$slice,$join) eq 
  ('<input name="test" type="text" value="boy">'.$join.
   '<input name="test" type="text" value="bat">');

$attr = { foo => "bar" };
ok stnd_html_input($name,$type,$data,$slice,$join,$attr) eq 
  ('<input name="test" type="text" value="boy" foo="bar">'.$join.
   '<input name="test" type="text" value="bat" foo="bar">');

$data = [];
ok stnd_html_input($name,$type,$data,$slice,$join) eq 
  ('<input name="test" type="text">'.$join.
   '<input name="test" type="text">');

$type = "checkbox";
my $possible = 
  {DDA => "Checking",
   SAV => "Savings",
   CD  => "Certificate of Deposit"};
ok con_html_input($name,$type,$possible) eq
  ('<input name="test" type="checkbox" value="CD">Certificate of Deposit'."\n".
   '<input name="test" type="checkbox" value="DDA">Checking'."\n".
   '<input name="test" type="checkbox" value="SAV">Savings');

$data = ['SAV'];
ok con_html_input($name,$type,$possible,$data) eq
  ('<input name="test" type="checkbox" value="CD">Certificate of Deposit'."\n".
   '<input name="test" type="checkbox" value="DDA">Checking'."\n".
   '<input name="test" type="checkbox" value="SAV" checked>Savings');

$type = "radio";
$slice = [qw(DDA SAV CD)];
push @$data, 'DDA';
ok con_html_input($name,$type,$possible,$data,$slice) eq
  ('<input name="test" type="radio" value="DDA" checked>Checking'."\n".
   '<input name="test" type="radio" value="SAV" checked>Savings'."\n".
   '<input name="test" type="radio" value="CD">Certificate of Deposit');


@$data = ();
$join = "<br>\n";
ok con_html_input($name,$type,$possible,$data,$slice,$join) eq
  ('<input name="test" type="radio" value="DDA">Checking'."<br>\n".
   '<input name="test" type="radio" value="SAV">Savings'."<br>\n".
   '<input name="test" type="radio" value="CD">Certificate of Deposit');
