package HTMLIO::Radio;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: Radio.pm,v 1.1 2000/11/23 23:36:16 muaddib Exp $

use strict;

=head1 NAME

HTMLIO::Radio - object for gathering and managing data through HTML radio

=head1 SYNOPSIS

see HTMLIO

=head1 DESCRIPTION

see HTMLIO

=cut

use HTMLIO;
use HTMLIO::Utils;

@HTMLIO::Radio::ISA = qw (HTMLIO);

=head1 METHODS

see HTMLIO for further methods

=head2 html_input

 instance
 (string $html) html_input ([variable \@index, string $join])

DESCRIPTION:

Will return the appropriat HTML necessary to set up user input through
a radio button. C<@index> specifies which possible data keys to set
for default display.

=cut

sub html_input {
  my ($this, $name, $data_obj, $slice, $join) = @_;

  my ($possible,$ordering) = $data_obj->possible_hash();

  for my $value ($data_obj->value()) {
    if (defined($possible->{$value})) {
      $possible->{$value} = 1;
    }
  }

  return con_html_input
	($name,
	 'radio',
	 [ $data_obj->value() ],
	 $possible,
	 $slice,
	 $join,
	 $this->attributes());
}

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<AtomicData>, L<HTMLIO>, L<Field>.

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
