package AtomicData::Y4Date;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: Y4Date.pm,v 1.1 2000/11/23 23:36:15 muaddib Exp $

use strict;

=head1 NAME

AtomicData::Y4Date - ensure 4 digit year.

=head1 SYNOPSIS

see AtomicData.pm

=head1 DESCRIPTION

Implements data encapsulation for dates. This package is only good
till year 9,999.

=cut

use AtomicData::Date;
@AtomicData::Y4Date::ISA = qw(AtomicData::Date);

=head1 METHODS

see AtomicData.pm for further methods.

=head2 set_format

see parent class for additional documentation.

=head2 canonicalize

see parent class for additional documentation.

Will return data in the form of /^(\d{2}\/\d{2}\/\d{4})?$/ where the
numbers make sense for an MM/DD/YYYY format.

=head2 verify

 instance
 () verify ()

DESCRIPTION:

Overides min and max_length parameters.

=cut

sub _verify {
  my ($this) = @_;

  my $parameters = $this->parameters();
  $parameters->{four_digit_year}++;
  delete $parameters->{min_length};
  delete $parameters->{max_length};

  $this->set_parameters($parameters);
  return $this->SUPER::_verify();
}

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<AtomicData>, L<HTMLIO>, L<Field>.

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
