#!/usr/bin/perl
use strict;
use lib qw(. ..);
use localutils;

my $vars = parse_makefile_vars();
my ($out_fname,$init) = parse_PL_argv(@ARGV);
my ($use_statements,$perl_args) = get_extra_libs($vars,$init);

open_perl_script($out_fname);
print($use_statements,<DATA>);
close_script();

__END__

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: piledriver.fcg.PL,v 1.3 2001/02/26 07:02:42 muaddie Exp $

use strict;

=head1 NAME

piledriver.fcg - executable script to dispatch FastCGI requests to PSP piles

=head1 SYNOPSIS

=head1 DESCRIPTION

The primary functionality of this executable is found within the
C<dispatch> subroutine which is exported by C<PSP::Driver>. This
script does provide some error checking functionality, however. It
also sets up a few variables and cleans up the CGI headers.

Sites using piles should redirect their web browser so that the
appropriate URLs are handled by this script.

=cut

use CGI::Fast;
use PSP::Driver qw(&dispatch);
use PSP::ProcManager;

my $proc_manager = PSP::ProcManager->new();
$proc_manager->pm_manage();

while (my $cgi = CGI::Fast->new()) {
  $proc_manager->pm_pre_dispatch();
  dispatch($cgi);
  $proc_manager->pm_post_dispatch();
}

exit 0;
