# -*- perl -*-
# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: Makefile.PL,v 1.5 2000/12/02 05:15:06 muaddib Exp $

require 5.004;
use strict;
use ExtUtils::MakeMaker;

my @MODULES = qw(
  Conf.pm
  Driver.pm
  Loader.pm
  Log.pm
  Output.pm
  Page.pm
  Pile.pm
  ProcManager.pm
  Utils.pm
  parent.pm
  share.pm
);

my %PM = map { $_ => '$(INST_LIBDIR)/PSP/'.$_ } @MODULES;

my @bin_scripts = qw(bin/testpile);
my @cgi_scripts = qw(cgi/piledriver.cgi cgi/piledriver.fcg);
my @scripts = (@bin_scripts,@cgi_scripts);

WriteMakefile(
   'NAME'         => 'PSP',
   'VERSION_FROM' => 'Utils.pm',
   'PM'	          => \%PM,
   'PL_FILES'     => { map {("$_.PL" => $_)} @scripts },
   'EXE_FILES'    => [ @bin_scripts ],
   ($] >= 5.005 ?
    (ABSTRACT   => 'The PSP CGI pile framework',
     AUTHOR     => 'James E Jurach (muaddib@erf.net)') : ()),
   'clean'        => { FILES => '$(EXE_FILES)'." @cgi_scripts" },
   'dist'         => { COMPRESS => 'gzip -9f', SUFFIX => 'gz' }
);

sub MY::postamble {
  my $out = "install::\n";
  for my $script (@cgi_scripts) {
    $out .= "\techo \"I don't know how to install CGI script: $script\"\n";
  }
  return $out;
}
