#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QLabel>
#include <QPushButton>

#include "ui_mainwindow.h"
#include "boardview.h"
#include "boarddelegate.h"
#include "boardmodel.h"

class ChessWindow : public QMainWindow
{
    Q_OBJECT

    public:
        ChessWindow(Figure::GameType type, bool enableSound_, QWidget *parent = 0);
        void moveRequest(int oldX, int oldY, int newX, int newY, QString figure = "");
        void loadRequest(QString settings);
        void youWin();
        void youLose();
        void youDraw();

    protected:
        void closeEvent(QCloseEvent *e);

    private:
        Ui::ChessWindow ui_;
        BoardModel *model_;        
        QModelIndex tmpIndex_;
        bool enabledSound;
        int movesCount;
	QAction *loseAction;
	void createMenu();

    private slots:
        void figureKilled(Figure* figure);
        void needNewFigure(QModelIndex index, QString player);
        void newFigure(QString figure);
        void load();
        void save();
        void addMove(int,int,int,int);

    signals:
        void closeBoard();
        void move(int, int, int, int, QString);
        void moveAccepted();
        void error();
        void load(QString);
        void draw();
        void lose();
        void toggleEnableSound(bool);

};

class SelectFigure : public QWidget
{
    Q_OBJECT
    public:
        SelectFigure(QString player, QWidget *parent = 0);

   private slots:
        void figureSelected();

    private:
        QPushButton *tb_queen, *tb_castle, *tb_knight, *tb_bishop;

    signals:
        void newFigure(QString figure);

};

#endif // MAINWINDOW_H
