/*
 * audaciouscontroller.cpp 
 * Copyright (C) 2008 Rion
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "audaciouscontroller.h"

#define AUDACIOUS_DBUS_SERVICE		"org.atheme.audacious"
#define AUDACIOUS_DBUS_PATH		"/org/atheme/audacious"
#define AUDACIOUS_DBUS_INTERFACE	"org.atheme.audacious"


/**
 * \class AudaciousController
 * \brief A controller for Audacious.
 */


/**
 * \brief Constructs the controller.
 */
AudaciousController::AudaciousController() : PollingTuneController()
{
	QDBusConnection dbusCon = QDBusConnection::sessionBus();
	if (!dbusCon.isConnected ()) {
		QString msg = dbusCon.lastError().message();
		qWarning("[Audacious plugin] Error while connecting to dbus: %s", qPrintable(msg));
	}
	iface = new QDBusInterface(AUDACIOUS_DBUS_SERVICE, AUDACIOUS_DBUS_PATH,
						 AUDACIOUS_DBUS_INTERFACE, dbusCon);
}


Tune AudaciousController::currentTune()
{
	Tune tune;
	if (!QDBusConnection::sessionBus().isConnected()) {
		return tune;
	}
	QDBusReply<QString> status = iface->call("Status");
	if (!status.isValid()) {
		return tune;
	}
	if (status.value() == "playing") {
		QDBusReply<uint> posObj = iface->call("Position");
		if (!posObj.isValid()) {
			qWarning("Can't get song position");
			return tune;
		}
		uint pos =  posObj.value();
		QString title = dbusGetTuple(pos, "title");
		if (title != "") {
			tune.setName(title);
			tune.setArtist(dbusGetTuple(pos, "artist"));
			tune.setAlbum(dbusGetTuple(pos, "album"));
			tune.setTrack(dbusGetTuple(pos, "track-number"));
		} else {
			QDBusReply<QString> title = iface->call("SongTitle", pos);
			tune.setName(title.value());
		}
		QDBusReply<uint> length = iface->call("SongLength", pos);
		tune.setTime(length.value());
	}
	return tune;
}

QString AudaciousController::dbusGetTuple(uint pos, QString tupleTitle)
{
	QDBusReply<QDBusVariant> reply = iface->call("SongTuple", pos, tupleTitle);
	return reply.isValid()?reply.value().variant().toString():"";
}
