/***************************************************************************
                          qsql_2.3.h  -  description
                             -------------------
    begin                : Sat 12 April 2003
    copyright            : (C) 2003 by paul-henri Ferme
    email                : paul-henri.ferme@noos.fr
 
A minimal "thin wrapper" around mysql++ API to achieve a minimum qt3 sql widget interface.
Goal is to use a standard qt library (without any sql support)
Commented-out class members are qt members not used/required  by prokyon3.
QSqlError not implemented at all.
 
Some: gotcha's:
Do use a  different namespace if linking with qt library including mysql support.
Do not call value(i) several times with the same parameter without rerunning query...
Do not forget to call mysql_thread_init()/mysql_thread_end()
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QSQL_2_3_H
#define QSQL_2_3_H

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include "../sql++/sqlplus.hh"
#include <qvariant.h>
#include <qmap.h>

#undef null   // do not remove. >> otherwise clash with qt headers

namespace qt_embedded_library {

    class QSqlQuery;

class QSqlDatabase :public QObject {
        friend class QSqlQuery;
public:
        //  virtual ~QSqlDatabase();
        QSqlDatabase();

        bool        open();
        //  bool        open( const QString& user, const QString& password );
        void        close();
        //  bool        isOpen() const {qWarning("PHF isopen=%s",IsOpen?"true":"false");return IsOpen;}
        bool        isOpen() const {
            return IsOpen;
        }
        //      bool        isOpenError() const;
        //  QStringList     tables() const;
        //      QSqlIndex       primaryIndex( const QString& tablename ) const;
        //      QSqlRecord      record( const QString& tablename ) const;
        //      QSqlRecord      record( const QSqlQuery& query ) const;
        //      QSqlRecordInfo  recordInfo( const QString& tablename ) const;
        //      QSqlRecordInfo  recordInfo( const QSqlQuery& query ) const;
        //      QSqlQuery    exec( const QString& query = QString::null ) const;
        //      QSqlError       lastError() const;

        //      bool        transaction();
        //      bool        commit();
        //      bool        rollback();

        void    setDatabaseName( const QString& name ) {
            DatabaseName = name ;
        }
        void    setUserName( const QString& name ) {
            UserName = name ;
        }
        void    setPassword( const QString& password ) {
            Password = password ;
        }
        void    setHostName( const QString& host ) {
            HostName = host ;
        }
        //      virtual void    setPort( int p );
        //      QString     databaseName() const;
        //      QString     userName() const;
        //      QString     password() const;
        //      QString     hostName() const;
        //      QString     driverName() const;
        //      int             port() const;

        //      QSqlDriver*     driver() const;

        //      char * const defaultConnection;

        static QSqlDatabase* addDatabase( const QString& type, const QString& connectionName = "" );
        static QSqlDatabase* database( const QString& connectionName = "", bool open = true );
        static void          removeDatabase( const QString& connectionName );
        static bool          contains( const QString& connectionName = "" );
        //      static QStringList   drivers();
        //      static void          registerSqlDriver( const QString& name, const QSqlDriverCreatorBase* dcb );

protected:
        //    QSqlDatabase( const QString& type, const QString& name, QObject * parent=0, const char * objname=0 );
private:
        //      void    init( const QString& type, const QString& name );
        //      QSqlDatabase( const QSqlDatabase & );
        //      QSqlDatabase &operator=( const QSqlDatabase & );
        static Connection* mycon;  // always contains the last opened connection
        Connection* con;
        static QMap<QString,QSqlDatabase*> databasemap;
        bool IsOpen;
        QString DatabaseName;
        QString UserName;
        QString Password;
        QString HostName;
    };

    class QSqlError {
public:
        enum Type {
            None,
            Connection,
            Statement,
            Transaction,
            Unknown
        };
        QSqlError(  const QString& driverText = QString::null,
                    const QString& databaseText = QString::null,
                    int type = QSqlError::None
                               /* int number = -1 */ )
: driverError(driverText), databaseError(databaseText), errorType(type) {
            ;
        }

        //QSqlError( const QSqlError& other );
        //QSqlError& operator=( const QSqlError& other );
        //virtual ~QSqlError();

        QString     driverText() const {
            return driverError;
        }
        //    void setDriverText( const QString& driverText ) { driverError=driverText;}
        QString     databaseText() const {
            return databaseError;
        }
        //     void setDatabaseText( const QString& databaseText ) { databaseError=databaseText;}
        int        type() const  {
            return errorType;
        }
        //     virtual void setType( int type ) { errorType = type;}
        /*     int        number() const; */
        /*     virtual void setNumber( int number ); */
        /*     QString     text() const; */
        /*     void        showMessage( const QString& msg = QString::null ) const; */

private:
        QString     driverError;
        QString     databaseError;
        int        errorType;
        //    int        errorNumber;
    };


    class QSqlQuery {
public:
        /*      QSqlQuery( QSqlResult * r ); */
QSqlQuery(): query( NULL ), valid( false ) {
            serror = QSqlError();
        }
        QSqlQuery( const QString& query, QSqlDatabase* db = 0 );
        /*      QSqlQuery( const QSqlQuery& other ); */
        /*      QSqlQuery& operator=( const QSqlQuery& other ); */
        virtual ~QSqlQuery();

        /*      bool                isValid() const; */
        bool                isActive() const {
            return active;
        }
        /*      bool            isNull( int field ) const; */
        /*      int                 at() const; */
        QString             lastQuery() const {
            return lastquery;
        }
        /*      int                 numRowsAffected() const; */
        QSqlError           lastError() const {
            return serror;
        }
        /*      bool                isSelect() const; */
        int                 size() const;
        /*      const QSqlDriver*   driver() const; */
        /*      const QSqlResult*   result() const; */
        /*      bool        isForwardOnly() const; */
        /*      void        setForwardOnly( bool forward ); */

        bool    exec ( const QString& aquery );
        QVariant    value( int i );

        /*      virtual bool    seek( int i, bool relative = FALSE ); */
        bool        next();
        /*      virtual bool        prev(); */
        /*      virtual bool        first(); */
        /*      virtual bool        last(); */

        /*      // prepared query support */
        bool        exec();
        /*      bool        prepare( const QString& query ); */
        /*      void        bindValue( const QString& placeholder, const QVariant& val ); */
        /*      void        bindValue( int pos, const QVariant& val ); */
        /*      void        addBindValue( const QVariant& val ); */

protected:

private:
        void CreateNewQuery( const QString &myquery, QSqlDatabase * db = NULL);
        QString parse_first(QString sin, QChar sep);
        Result res;
        Query *query;
        Result::iterator it;
        bool valid;
        bool active;
        bool first;
        Row row;
        QSqlError serror;
        QString lastquery;
    };
}

#endif

