/***************************************************************************
                          lvi_medium.cpp  -  description
                             -------------------
    begin                : Sun May 6 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lvi_medium.h"
#include "gui.h"
#include "pixmapcache.h"

LVI_Medium::LVI_Medium(QListView *parent, MEDIUM *medium)
: QListViewItem(parent) {
    setText(0, medium->label);
    id       = medium->id;
    type     = medium->type;
    label    = medium->label;
    path     = medium->path;
    checksum = medium->checksum;

    isAvailable = false;
    isLocked = false;

    adjustIcon();
}

QString LVI_Medium::key() {
    QString s = QString::number( type ) + text(0);
    return s.simplifyWhiteSpace();
}

void LVI_Medium::setAvailability(bool state) {
    isAvailable = state;
    adjustIcon();
}

void LVI_Medium::adjustIcon() {
    switch(type) {
    case MEDIUM_HARDDISK:
        setPixmap(0, pixmapcache->get
                  ("lvi_hdd.png"));
        break;
    case MEDIUM_CDROM:
        if(!isAvailable)
            setPixmap(0, pixmapcache->getFaded("lvi_cdrom.png"));
        else
            setPixmap(0, pixmapcache->get
                      ("lvi_cdrom.png"));
        break;
    case MEDIUM_SMB:
        if(!isAvailable)
            setPixmap(0, pixmapcache->getFaded("lvi_smb.png"));
        else
            setPixmap(0, pixmapcache->get
                      ("lvi_smb.png"));
        break;
    case MEDIUM_NFS:
        if(!isAvailable)
            setPixmap(0, pixmapcache->getFaded("lvi_nfs.png"));
        else
            setPixmap(0, pixmapcache->get
                      ("lvi_nfs.png"));
        break;
    }
}
