/***************************************************************************
                 job_callmusicextras.cpp  -  description
                             -------------------
    begin                : Wed Jan 7 2004
    copyright            : (C) 2003 by Markus Kalkbrenner
    email                : mkalkbrenner@users.sourceforge.net
 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>

#include "job_callmusicextras.h"
#include "job_getextradata.h"
#include "jobmanager.h"
#include "datadispatcher.h"
#include "database.h"
#include "gui.h"

#ifdef EMBEDDED
#include <mysql.h>
#endif

Job_CallMusicextras::Job_CallMusicextras(TRACK _track, bool _refresh)
: track(_track),refresh(_refresh),terminated(false) {
    mw=NULL;
}

void Job_CallMusicextras::run() {
    if (verbose==8)
        qWarning( "    >run() job:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

    #ifdef EMBEDDED

    mysql_thread_init();
    #endif

    // first check here if musicextras info is not already cached into prokyon3

    database->lock()
    ;
    EXTRA_STATUS status = database->checkMextras(&track);
    database->unlock();

    // second call musicextras to fetch info from the web/musicextras cache

    if (!terminated) {
        mw = new MusicextrasWrapper();
        data = mw->get
               (&track, status);
    }

    // third  update prokyon3 base with fetched info

    if (!terminated) {
        database->lock()
        ;
        database->updateMextras( data, &track);
        countCovers = database->getCountColumnDistinctFromTable("cover_id", "albums");
        countLyrics = database->getCountColumnDistinctFromTable("lyrics_id", "tracks");
        countImages = database->getCountColumnDistinctFromTable("image_id", "artists");
        error = database->getError();
        database->unlock();
    }

    // four, update GUI status display .

    if(!error && !terminated) {
        QString ss;
        /* TRANSLATORS: short form of 'Images' 'Covers' 'Lyrics' */
        ss.sprintf(_(" Ima.:%d Cov.:%d Lyr.:%d"), countImages, countCovers, countLyrics);
        StatusEvent* se = new StatusEvent( new STATUSDATA( ss, 6) );
        QApplication::postEvent( gui->getPlaylisting(), se );

        // if required refresh all GUI.
        if (refresh) {
            jobman->addJob(new Job_GetExtraData( MEXTRAS_GET, track ));
        }
    }

    jobman->lock()
    ;
    jobman->jobDone(this);
    jobman->unlock();

    #ifdef EMBEDDED

    mysql_thread_end();
    #endif

    if (verbose==8)
        qWarning( "    >exit() job:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

    exit();
}

Job_CallMusicextras::~Job_CallMusicextras() {
    if (mw)
        //      delete mw; // if job is  terminated
        mw->deleteLater(); // if job is  deleted. It is safer to do it once returning to the main event loop.
}
