/***************************************************************************
                          gui_taglisting.h  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GUI_TAGLISTING_H
#define GUI_TAGLISTING_H

#include "prokyon.h"
#include "extendedpushbutton.h"

#include <qframe.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qwidgetstack.h>
#include <qptrlist.h>
#include <qspinbox.h>
#include <qradiobutton.h>
#include <qlistview.h>

class GUI_TagListing : public QFrame  {
    Q_OBJECT
public:
    GUI_TagListing(QWidget *parent, QListView *_tracklist, const char *name=0);

    void notifyAddEditLock();
    void notifyRemoveEditLock();
    void notifyEnableEdit(bool);

    void notifySelectionChanged();
    void notifyCurrentChanged(QListViewItem *lvi);
    void notifySortingInEditModeChanged();

    bool isEditMode() {
        return editMode;
    }

    ~GUI_TagListing();

public slots:
    void slot_setConnectionState(bool state);

private:
    QListView *tracklist;

    QList<QListViewItem> selectedItems;

    int currentTrack;

    int editLock;

    bool editMode, editEnabled, doNothing;

    void setAlbumCategoryFromComment(QString comment);

    QString getCommentFromId(int id);

    QPushButton *buttonEdit, *buttonGuess, *buttonApply, *buttonDiscard;
    #ifdef HAVE_LIBMUSICBRAINZ

    QPushButton *buttonMusicbrainz;
    #endif

    ExtendedPushButton *buttonFilename, *buttonTitle, *buttonArtist, *buttonAlbum, *buttonYear, *buttonGenre, *buttonComment, *buttonTrack, *buttonAlbumCategory;
    ExtendedPushButton *buttonLastClicked;

    QWidgetStack *stackFilename, *stackTitle, *stackArtist, *stackAlbum, *stackYear, *stackGenre, *stackComment, *stackTrack, *stackAlbumCategory, *stackNotes, *stackRating;
    QLabel *labelFilename, *labelTitle, *labelArtist, *labelAlbum, *labelYear, *labelGenre, *labelComment, *labelInfo, *labelPath, *labelTrack, *labelSum, *labelAlbumCategory, *labelFile, *labelNotes, *labelRating;
    QLineEdit *editFilename, *editTitle, *editArtist, *editAlbum, *editYear, *editComment, *editNotes;
    QSpinBox *spinTrack;
    QComboBox *comboGenre, *comboAlbumCategory, *spinRating;

    QString oldtip, nonEditPath;

    bool statusleft, statusright, statusbottom, autohide;

    void getSelectedItems();
    void applyCurrentTrack();
    void switchMode(int, bool);
    QString filter_ext2(QString filename);


public slots:

    void slot_discardbutton();

private slots:

    void slot_editbutton();
    void slot_applybutton();
    void slot_musicbrainzbutton();
    void slot_filenameEdit(const QString&);
    void slot_artistEdit(const QString&);
    void slot_titleEdit(const QString&);
    void slot_albumEdit(const QString&);
    void slot_tracknumberChanged(int);
    void slot_yearEdit(const QString&);
    void slot_commentEdit(const QString&);
    void slot_genreCombo(int);
    void slot_albumCategory(int);
    void slot_notesEdit(const QString&);
    void slot_ratingChanged(int);

    void slot_artistButton();
    void slot_titleButton();
    void slot_albumButton();
    void slot_yearButton();
    void slot_trackButton();
    void slot_autotrackButton();
    void slot_commentButton();
    void slot_genreButton();
    void slot_albumCategoryButton();

    void slot_buttonContext(ExtendedPushButton*, const QPoint&);

    void slot_menuDiscardChanges();
    void slot_menuDiscardChangesALL();
    void slot_menuStandardFilename();
    void slot_menuStandardFilenameALL();
    void slot_menuAndromedaFilename();
    void slot_menuAndromedaFilenameALL();
    void slot_menuCustomFilename();
    void slot_menuCustomFilenameALL();
    void slot_menuFLUpcase();
    void slot_menuFLUpcaseALL();
    void slot_menuDowncase();
    void slot_menuDowncaseALL();
    void slot_menuGuessFilename();
    void slot_menuGuessFilenameALL();
    void slot_menuMusicBrainzALL();
    void slot_menuHelpAndromeda();

    void slot_selPrevTrack();
    void slot_selNextTrack();
};

#endif
