/***************************************************************************
                          extendedpushbutton.cpp  -  description
                             -------------------
    begin                : Fri May 25 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "extendedpushbutton.h"
#include "prokyon.h"
#include "pixmapcache.h"

ExtendedPushButton::ExtendedPushButton(QString label, QWidget *parent, const char *name):
QPushButton(label, parent, name) {
    setPixmap(pixmapcache->get
              ("action_selectall.png"));
}

ExtendedPushButton::~ExtendedPushButton() {}

void ExtendedPushButton::mousePressEvent(QMouseEvent *e) {
    QPushButton::mousePressEvent(e);
    if(e->button() == RightButton)
        emit contextMenu(this, e->globalPos());
}

