/***************************************************************************
                          configuration.cpp  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "prokyon.h"
#include "configuration.h"

#include "gui.h"
#include "configuration_dialog.h"
#include "lvi_track.h"
#include "job_getextradata.h"
#include "jobmanager.h"

#include <qlistview.h>
#include <qtooltip.h>
#include <qdir.h>

Configuration::Configuration(): showtooltip(0) {
    playerOptions["amarok"]["play"] = "amarok --play";
    playerOptions["amarok"]["pause"] = "amarok --pause";
    playerOptions["amarok"]["stop"] = "amarok --stop";
    playerOptions["amarok"]["next"] = "amarok --next";
    playerOptions["amarok"]["prev"] = "amarok --previous";
    playerOptions["amarok"]["enqueue"] = "amarok --enqueue";
    playerOptions["beep-media-player"]["play"] = "beep-media-player --play";
    playerOptions["beep-media-player"]["pause"] = "beep-media-player --pause";
    playerOptions["beep-media-player"]["stop"] = "beep-media-player --stop";
    playerOptions["beep-media-player"]["next"] = "beep-media-player --fwd";
    playerOptions["beep-media-player"]["prev"] = "beep-media-player --rew";
    playerOptions["beep-media-player"]["enqueue"] = "beep-media-player --enqueue";
    playerOptions["kaffeine"]["play"] = "kaffeine";
    playerOptions["kaffeine"]["pause"] = "kaffeine"; // not supported via command line
    playerOptions["kaffeine"]["stop"] = "kaffeine"; // not supported via command line
    playerOptions["kaffeine"]["next"] = "kaffeine"; // not supported via command line
    playerOptions["kaffeine"]["prev"] = "kaffeine"; // not supported via command line
    playerOptions["kaffeine"]["enqueue"] = "kaffeine"; // not supported via command line
    playerOptions["mplayer"]["play"] = "mplayer -playlist";
    playerOptions["mplayer"]["pause"] = "mplayer"; // not supported via command line
    playerOptions["mplayer"]["stop"] = "mplayer"; // not supported via command line
    playerOptions["mplayer"]["next"] = "mplayer"; // not supported via command line
    playerOptions["mplayer"]["prev"] = "mplayer"; // not supported via command line
    playerOptions["mplayer"]["enqueue"] = "mplayer -enqueue";
    playerOptions["noatun"]["play"] = "noatun";
    playerOptions["noatun"]["pause"] = "noatun"; // not supported via command line
    playerOptions["noatun"]["stop"] = "noatun"; // not supported via command line
    playerOptions["noatun"]["next"] = "noatun"; // not supported via command line
    playerOptions["noatun"]["prev"] = "noatun"; // not supported via command line
    playerOptions["noatun"]["enqueue"] = "noatun"; // not supported via command line
    playerOptions["totem"]["play"] = "totem --play";
    playerOptions["totem"]["pause"] = "totem --pause";
    playerOptions["totem"]["stop"] = "totem --quit";
    playerOptions["totem"]["next"] = "totem --next";
    playerOptions["totem"]["prev"] = "totem --previous";
    playerOptions["totem"]["enqueue"] = "totem --enqueue";
    playerOptions["xmms"]["play"] = "xmms --play";
    playerOptions["xmms"]["pause"] = "xmms --pause";
    playerOptions["xmms"]["stop"] = "xmms --stop";
    playerOptions["xmms"]["next"] = "xmms --fwd";
    playerOptions["xmms"]["prev"] = "xmms --rew";
    playerOptions["xmms"]["enqueue"] = "xmms --enqueue";

    settings = new QSettings();
    db_host     = settings->readEntry("/prokyon3/database/host", "localhost");
    db_database = settings->readEntry("/prokyon3/database/database", "prokyon");
    db_user     = settings->readEntry("/prokyon3/database/user", "prokyon");
    db_pass     = settings->readEntry("/prokyon3/database/pass", "prokyon");
    db_encoding = settings->readEntry("/prokyon3/database/encoding", QString::null);
    #ifdef EMBEDDED

    embeddedBasedir  = settings->readEntry("/prokyon3/database/embeddedbasedir", QDir::homeDirPath() + "/mysql");
    embeddedLanguage = settings->readEntry("/prokyon3/database/embeddedlanguage", "/usr/share/mysql/english/");
    #endif /* EMBEDDED */

    musicbrainz_server = settings->readEntry("/prokyon3/musicbrainz/server", "musicbrainz.org");
    musicbrainz_port   = settings->readNumEntry("/prokyon3/musicbrainz/port", 80);
    mp3dirs     = settings->readListEntry("/prokyon3/directories/mp3dirs");
    smbKeywords = settings->readListEntry("/prokyon3/directories/smb");
    nfsKeywords = settings->readListEntry("/prokyon3/directories/nfs");
    startuptip  = settings->readNumEntry("/prokyon3/startup/showtip", 1);
    readid3v2   = settings->readNumEntry("/prokyon3/general/readid3v2", 1);
    writeid3v2  = settings->readNumEntry("/prokyon3/general/writeid3v2", 1);
    autoconn    = settings->readNumEntry("/prokyon3/general/autoconnect", 0);
    autohide    = settings->readNumEntry("/prokyon3/general/autohiding", 1);
    avoidhdd    = settings->readNumEntry("/prokyon3/general/avoidHDDlisting", 0);
    avoidsmb    = settings->readNumEntry("/prokyon3/general/avoidSMBlisting", 0);
    avoidnfs    = settings->readNumEntry("/prokyon3/general/avoidNFSlisting", 0);
    allowguirestore = settings->readNumEntry("/prokyon3/general/allowguirestore", 1);
    customrename = settings->readEntry("/prokyon3/general/customrename", "%A - %T");

    playcmd       = settings->readEntry("/prokyon3/general/playcommand", playerOptions["xmms"]["play"]);
    pausecmd      = settings->readEntry("/prokyon3/general/pausecommand", playerOptions["xmms"]["pause"]);
    stopcmd       = settings->readEntry("/prokyon3/general/stopcommand", playerOptions["xmms"]["stop"]);
    nextcmd       = settings->readEntry("/prokyon3/general/nextcommand", playerOptions["xmms"]["next"]);
    prevcmd       = settings->readEntry("/prokyon3/general/prevcommand", playerOptions["xmms"]["prev"]);
    enqueuecmd    = settings->readEntry("/prokyon3/general/enqueuecommand", playerOptions["xmms"]["enqueue"]);
    preplaycmd    = settings->readEntry("/prokyon3/general/preplaycommand", playerOptions["xmms"]["play"]);
    prepausecmd   = settings->readEntry("/prokyon3/general/prepausecommand", playerOptions["xmms"]["pause"]);
    prestopcmd    = settings->readEntry("/prokyon3/general/prestopcommand", playerOptions["xmms"]["stop"]);
    prenextcmd    = settings->readEntry("/prokyon3/general/prenextcommand", playerOptions["xmms"]["next"]);
    preprevcmd    = settings->readEntry("/prokyon3/general/preprevcommand", playerOptions["xmms"]["prev"]);
    preenqueuecmd = settings->readEntry("/prokyon3/general/preenqueuecommand", playerOptions["xmms"]["enqueue"]);
    burnCDcmd     = settings->readEntry("/prokyon3/general/burnCDcommand", "prokburn");
    k3bcmd        = settings->readEntry("/prokyon3/general/k3bcommand", "k3b");
    #ifdef HAVE_MIXXX

    mixxxHost   = settings->readEntry("/prokyon3/general/mixxxHost", "localhost");
    mixxxPort   = settings->readNumEntry("/prokyon3/general/mixxxPort", 33033);

    enableRegularPlayer = settings->readBoolEntry("/prokyon3/general/enableRegularPlayer", true);
    enableMixxxPlayer   = settings->readBoolEntry("/prokyon3/general/enableMixxxPlayer", false);
    #endif /* HAVE_MIXXX */

    posx  = settings->readNumEntry("/prokyon3/GUIpos/posx", 10);
    posy  = settings->readNumEntry("/prokyon3/GUIpos/posy", 50);
    width  = settings->readNumEntry("/prokyon3/GUIpos/width", 800);
    height  = settings->readNumEntry("/prokyon3/GUIpos/height", 600 );

    setShowToolTip( settings->readNumEntry("/prokyon3/general/showtooltip", 1) );

    info_Length = settings->readNumEntry("/prokyon3/infolist/info_Length", 1 );
    info_Media = settings->readNumEntry("/prokyon3/infolist/info_Media", 0 );
    info_Bitrate = settings->readNumEntry("/prokyon3/infolist/info_Bitrate", 1 );
    info_Album = settings->readNumEntry("/prokyon3/infolist/info_Album", 1 );
    info_Comment = settings->readNumEntry("/prokyon3/infolist/info_Comment", 1 );
    info_Year = settings->readNumEntry("/prokyon3/infolist/info_Year", 1 );
    info_Genre = settings->readNumEntry("/prokyon3/infolist/info_Genre", 1 );
    info_Path = settings->readNumEntry("/prokyon3/infolist/info_Path", 0 );
    info_Filename = settings->readNumEntry("/prokyon3/infolist/info_Filename", 1 );
    info_Notes = settings->readNumEntry("/prokyon3/infolist/info_Notes", 0 );
    info_Rating = settings->readNumEntry("/prokyon3/infolist/info_Rating", 0 );
    info_radiostate = settings->readNumEntry("/prokyon3/infolist/info_radiostate", 2 );

    bool ok;
    info_columnwidth = settings->readListEntry("/prokyon3/infolist/columwidth", &ok);
    if (!ok)
        info_columnwidth.clear();
    info_columnmap = settings->readListEntry("/prokyon3/infolist/colummap", &ok);
    if (!ok)
        info_columnmap.clear();
    info_guisize = settings->readListEntry("/prokyon3/infolist/guisize", &ok);
    if (!ok)
        info_guisize.clear();
    info_guisizer = settings->readListEntry("/prokyon3/infolist/guisizer", &ok);
    if (!ok)
        info_guisizer.clear();
    info_guisizel = settings->readListEntry("/prokyon3/infolist/guisizel", &ok);
    if (!ok)
        info_guisizel.clear();
    info_guisizem = settings->readListEntry("/prokyon3/infolist/guisizem", &ok);
    if (!ok)
        info_guisizem.clear();

    setMaxWidthMode( settings->readNumEntry("/prokyon3/general/maxwidthmode", 1) );

    toggleleft = settings->readBoolEntry("/prokyon3/GUIpos/toggleleft", true );
    togglebottom = settings->readBoolEntry("/prokyon3/GUIpos/togglebottom", true );
    toggleright = settings->readBoolEntry("/prokyon3/GUIpos/toggleright", true );

    #ifdef HAVE_MEXTRAS

    Mextras_bgnd = settings->readNumEntry("/prokyon3/general/mextras_bgnd", 1);
    Mextras_count = settings->readNumEntry("/prokyon3/general/mextras_count", 1);

    checkcover = settings->readBoolEntry("/prokyon3/general/mextras_cover", true );
    checkartist = settings->readBoolEntry("/prokyon3/general/mextras_artist", true );
    checklyrics = settings->readBoolEntry("/prokyon3/general/mextras_lyrics", true );
    checksyncedlyrics = settings->readBoolEntry("/prokyon3/general/mextras_syncedlyrics", true );
    checkalbum = settings->readBoolEntry("/prokyon3/general/mextras_album", true );
    checktracks = settings->readBoolEntry("/prokyon3/general/mextras_tracks", true );
    checkbiography = settings->readBoolEntry("/prokyon3/general/mextras_biography", true );
    checkyears = settings->readBoolEntry("/prokyon3/general/mextras_years", true );
    #endif /* HAVE_MEXTRAS */

    combosortingmode = settings->readEntry("/prokyon3/general/combosortingmode", _("Filename"));
    combosortingauto = settings->readBoolEntry("/prokyon3/general/combosortingauto", true );
}

Configuration::~Configuration() {
    settings->writeEntry("/prokyon3/database/host", db_host);
    settings->writeEntry("/prokyon3/database/database", db_database);
    settings->writeEntry("/prokyon3/database/user", db_user);
    settings->writeEntry("/prokyon3/database/pass", db_pass);
    settings->writeEntry("/prokyon3/database/encoding", db_encoding);
    #ifdef EMBEDDED

    settings->writeEntry("/prokyon3/database/embeddedbasedir", embeddedBasedir);
    settings->writeEntry("/prokyon3/database/embeddedlanguage", embeddedLanguage);
    #endif /* EMBEDDED */
    #ifdef HAVE_LIBMUSICBRAINZ

    settings->writeEntry("/prokyon3/musicbrainz/server", musicbrainz_server);
    settings->writeEntry("/prokyon3/musicbrainz/port", musicbrainz_port);
    #endif /* HAVE_LIBMUSICBRAINZ */

    settings->writeEntry("/prokyon3/directories/mp3dirs", mp3dirs);
    settings->writeEntry("/prokyon3/directories/smb", smbKeywords);
    settings->writeEntry("/prokyon3/directories/nfs", nfsKeywords);
    settings->writeEntry("/prokyon3/startup/showtip", startuptip);
    settings->writeEntry("/prokyon3/general/readid3v2", readid3v2);
    settings->writeEntry("/prokyon3/general/writeid3v2", writeid3v2);
    settings->writeEntry("/prokyon3/general/autoconnect", autoconn);
    settings->writeEntry("/prokyon3/general/autohiding", autohide);
    settings->writeEntry("/prokyon3/general/avoidHDDlisting", avoidhdd);
    settings->writeEntry("/prokyon3/general/avoidSMBlisting", avoidsmb);
    settings->writeEntry("/prokyon3/general/avoidNFSlisting", avoidnfs);
    settings->writeEntry("/prokyon3/general/allowguirestore", allowguirestore);
    settings->writeEntry("/prokyon3/general/customrename", customrename);
    settings->writeEntry("/prokyon3/general/playcommand", playcmd);
    settings->writeEntry("/prokyon3/general/pausecommand", pausecmd);
    settings->writeEntry("/prokyon3/general/stopcommand", stopcmd);
    settings->writeEntry("/prokyon3/general/nextcommand", nextcmd);
    settings->writeEntry("/prokyon3/general/prevcommand", prevcmd);
    settings->writeEntry("/prokyon3/general/enqueuecommand", enqueuecmd);
    settings->writeEntry("/prokyon3/general/preplaycommand", preplaycmd);
    settings->writeEntry("/prokyon3/general/prepausecommand", prepausecmd);
    settings->writeEntry("/prokyon3/general/prestopcommand", prestopcmd);
    settings->writeEntry("/prokyon3/general/prenextcommand", prenextcmd);
    settings->writeEntry("/prokyon3/general/preprevcommand", preprevcmd);
    settings->writeEntry("/prokyon3/general/preenqueuecommand", preenqueuecmd);
    settings->writeEntry("/prokyon3/general/burnCDcommand", burnCDcmd);
    settings->writeEntry("/prokyon3/general/k3bcommand", k3bcmd);
    #ifdef HAVE_MIXXX

    settings->writeEntry("/prokyon3/general/mixxxHost", mixxxHost);
    settings->writeEntry("/prokyon3/general/mixxxPort", mixxxPort);

    settings->writeEntry("/prokyon3/general/enableRegularPlayer", enableRegularPlayer);
    settings->writeEntry("/prokyon3/general/enableMixxxPlayer", enableMixxxPlayer);
    #endif /* HAVE_MIXXX */

    settings->writeEntry("/prokyon3/GUIpos/posx", posx );
    settings->writeEntry("/prokyon3/GUIpos/posy", posy );
    settings->writeEntry("/prokyon3/GUIpos/width", width );
    settings->writeEntry("/prokyon3/GUIpos/height", height );

    settings->writeEntry("/prokyon3/general/showtooltip", showtooltip);

    settings->writeEntry("/prokyon3/infolist/info_Length", (int)gui->getListing()->readInfo_lengthCheck());
    settings->writeEntry("/prokyon3/infolist/info_Media", (int)gui->getListing()->readInfo_mediaCheck());
    settings->writeEntry("/prokyon3/infolist/info_Bitrate", (int)gui->getListing()->readInfo_bitrateCheck());
    settings->writeEntry("/prokyon3/infolist/info_Album", (int)gui->getListing()->readInfo_albumCheck());
    settings->writeEntry("/prokyon3/infolist/info_Comment", (int)gui->getListing()->readInfo_commentCheck());
    settings->writeEntry("/prokyon3/infolist/info_Year", (int)gui->getListing()->readInfo_yearCheck());
    settings->writeEntry("/prokyon3/infolist/info_Genre", (int)gui->getListing()->readInfo_genreCheck());
    settings->writeEntry("/prokyon3/infolist/info_Path", (int)gui->getListing()->readInfo_pathCheck());
    settings->writeEntry("/prokyon3/infolist/info_Filename", (int)gui->getListing()->readInfo_filenameCheck());
    settings->writeEntry("/prokyon3/infolist/info_Notes", (int)gui->getListing()->readInfo_notesCheck());
    settings->writeEntry("/prokyon3/infolist/info_Rating", (int)gui->getListing()->readInfo_ratingCheck());
    settings->writeEntry("/prokyon3/infolist/info_radiostate", gui->getListing()->readInfo_radiostate());
    settings->writeEntry("/prokyon3/infolist/columwidth", gui->getListing()->readColumnWidth());
    settings->writeEntry("/prokyon3/infolist/colummap", gui->getListing()->readColumnMap());

    settings->writeEntry("/prokyon3/infolist/guisize", info_guisize);
    settings->writeEntry("/prokyon3/infolist/guisizer", info_guisizer);
    settings->writeEntry("/prokyon3/infolist/guisizel", info_guisizel);
    settings->writeEntry("/prokyon3/infolist/guisizem", info_guisizem);

    settings->writeEntry("/prokyon3/general/maxwidthmode", maxwidthmode);

    settings->writeEntry("/prokyon3/GUIpos/toggleleft", toggleleft );
    settings->writeEntry("/prokyon3/GUIpos/togglebottom", togglebottom );
    settings->writeEntry("/prokyon3/GUIpos/toggleright", toggleright );

    #ifdef HAVE_MEXTRAS

    settings->writeEntry("/prokyon3/general/mextras_bgnd", Mextras_bgnd);
    settings->writeEntry("/prokyon3/general/mextras_count", Mextras_count);

    settings->writeEntry("/prokyon3/general/mextras_cover", checkcover );
    settings->writeEntry("/prokyon3/general/mextras_artist", checkartist );
    settings->writeEntry("/prokyon3/general/mextras_lyrics", checklyrics );
    settings->writeEntry("/prokyon3/general/mextras_syncedlyrics", checksyncedlyrics );
    settings->writeEntry("/prokyon3/general/mextras_album", checkalbum );
    settings->writeEntry("/prokyon3/general/mextras_tracks", checktracks );
    settings->writeEntry("/prokyon3/general/mextras_biography", checkbiography );
    settings->writeEntry("/prokyon3/general/mextras_years", checkyears );
    #endif /* HAVE_MEXTRAS */

    settings->writeEntry("/prokyon3/general/combosortingmode", combosortingmode);
    settings->writeEntry("/prokyon3/general/combosortingauto", combosortingauto );

    delete settings;
}

void Configuration::showConfigurationDialog() {
    Configuration_Dialog *dlg = new Configuration_Dialog(gui);
    int result = dlg->exec();
    if(result == QDialog::Accepted) {
        db_host = dlg->db_host_line->text();
        db_database = dlg->db_database_line->text();
        db_user = dlg->db_user_line->text();
        db_pass = dlg->db_pass_line->text();
        #ifdef EMBEDDED

        embeddedBasedir  = dlg->embedded_basedir_line->text();
        embeddedLanguage = dlg->embedded_language_line->text();
        #endif /* EMBEDDED */
        #ifdef HAVE_LIBMUSICBRAINZ

        musicbrainz_server = dlg->musicBrainzServer_line->text();
        musicbrainz_port = dlg->musicBrainzPort_line->text().toInt();
        #endif /* HAVE_LIBMUSICBRAINZ */

        playcmd = dlg->play_line->currentText();
        pausecmd = dlg->pause_line->currentText();
        stopcmd = dlg->stop_line->currentText();
        nextcmd = dlg->next_line->currentText();
        prevcmd = dlg->prev_line->currentText();
        enqueuecmd = dlg->enqueue_line->currentText();
        preplaycmd = dlg->preplay_line->currentText();
        prepausecmd = dlg->prepause_line->currentText();
        prestopcmd = dlg->prestop_line->currentText();
        prenextcmd = dlg->prenext_line->currentText();
        preprevcmd = dlg->preprev_line->currentText();
        preenqueuecmd = dlg->preenqueue_line->currentText();
        burnCDcmd = dlg->burnCD_line->text();
        k3bcmd = dlg->k3b_line->text();
        #ifdef HAVE_MIXXX

        mixxxHost = dlg->mixxxhost_line->text();
        mixxxPort = dlg->mixxxport_line->text().toInt();
        enableRegularPlayer = dlg->enableRegularPlayer->isChecked();
        enableMixxxPlayer = dlg->enableMixxxPlayer->isChecked();
        #endif /* HAVE_MIXXX */

        readid3v2 = dlg->readv2check->isChecked() ? 1 : 0;
        writeid3v2 = dlg->writev2check->isChecked() ? 1 : 0;
        autoconn = dlg->autocheck->isChecked() ? 1 : 0;
        autohide = dlg->hidecheck->isChecked() ? 1 : 0;
        avoidhdd = dlg->hddcheck->isChecked() ? 1 : 0;
        avoidsmb = dlg->smbcheck->isChecked() ? 1 : 0;
        avoidnfs = dlg->nfscheck->isChecked() ? 1 : 0;
        allowguirestore =  dlg->guirestore->isChecked() ? 1 : 0;
        customrename = dlg->customrename_line->text();
        setShowToolTip( dlg->showtooltip->isChecked() ? 1 : 0 );
        setMaxWidthMode( dlg->maxwidthmode->isChecked() ? 1 : 0 );
        mp3dirs.clear();
        QListViewItem *curr = dlg->hddlist->firstChild();
        while(curr) {
            mp3dirs.append(curr->text(0));
            curr = curr->nextSibling();
        }
        smbKeywords.clear();
        smbKeywords = QStringList::split(QString(","), dlg->smbKeywords_line->text());
        nfsKeywords.clear();
        nfsKeywords = QStringList::split(QString(","), dlg->nfsKeywords_line->text());
        #ifdef HAVE_MEXTRAS

        Mextras_bgnd = dlg->mextras_bgnd->isChecked() ? 1 : 0;

        // if  mextras_bgnd was changed, update gui accordingly
        gui->getPlaylisting()->clear_IconView();
        gui->getListing()->list()->unsetPalette();
        gui->getPlaylisting()->setCoverPixmap(QIDPixmap());
        gui->getPlaylisting()->setArtistPixmap(QIDPixmap());
        LVI_Track *item = static_cast<LVI_Track*>(gui->getListing()->list()->currentItem());
        if (item) {
            TRACK *track  = new TRACK(*item->getOriginalTrack());
            jobman->addJob(new Job_GetExtraData( MEXTRAS_GET, *track ));
        }

        Mextras_count = dlg->mexspinbox->value();
        jobman->setjob_mextras_max(Mextras_count);

        checkartist = dlg->checkartist->isChecked() ? 1 : 0;
        checkcover = dlg->checkcover->isChecked() ? 1 : 0;
        checklyrics = dlg->checklyrics->isChecked() ? 1 : 0;
        checksyncedlyrics = dlg->checksyncedlyrics->isChecked() ? 1 : 0;
        checkalbum = dlg->checkalbum->isChecked() ? 1 : 0;
        checktracks = dlg->checktracks->isChecked() ? 1 : 0;
        checkbiography = dlg->checkbiography->isChecked() ? 1 : 0;
        checkyears = dlg->checkyears->isChecked() ? 1 : 0;
        #endif /* HAVE_MEXTRAS */

        combosortingmode = dlg->comboSortingMode->currentText();
        combosortingauto = dlg->comboSortingAuto->isChecked() ? 1 : 0;
    }
}

void Configuration::setShowToolTip( int _tooltip) {
    showtooltip = _tooltip;
    QToolTip::setGloballyEnabled( _tooltip );
}

QValueList<int> Configuration::listString2Int( QStringList qs) {
    QValueList<int> qi;
    QStringList::Iterator it = qs.begin();
    while( it != qs.end() ) {
        qi << (*it).toInt() ;
        ++it;
    }
    return qi;
}

QStringList Configuration::listInt2String( QValueList<int> qi) {
    QStringList qs;
    QValueList<int>::Iterator it = qi.begin();
    while( it != qi.end() ) {
        qs << QString::number(*it) ;
        ++it;
    }
    return qs;
}

QValueList<int> Configuration::getinfo_guisize() {
    return listString2Int( info_guisize );
}

QValueList<int> Configuration::getinfo_guisizer() {
    return listString2Int( info_guisizer );
}

QValueList<int> Configuration::getinfo_guisizel() {
    return listString2Int( info_guisizel );
}

QValueList<int> Configuration::getinfo_guisizem() {
    return listString2Int( info_guisizem );
}

void  Configuration::setinfo_guisize( QValueList<int> qi) {
    info_guisize = listInt2String( qi );
}

void  Configuration::setinfo_guisizer( QValueList<int> qi) {
    info_guisizer = listInt2String( qi );
}

void  Configuration::setinfo_guisizel( QValueList<int> qi) {
    info_guisizel = listInt2String( qi );
}

void  Configuration::setinfo_guisizem( QValueList<int> qi) {
    info_guisizem = listInt2String( qi );
}


