/***************************************************************************
                          lvi_smbshare.cpp  -  description
                             -------------------
    begin                : Sun Jun 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lvi_smbshare.h"
#include "gui.h"
#include "pixmapcache.h"

LVI_SMBShare::LVI_SMBShare(QListView *parent, int _shareID, QString _path, QString _share)
  : QListViewItem(parent), shareID(_shareID), path(_path), share(_share)
{
  device = share;

  share.replace(0, 2, "");
  QString machine = share; machine.truncate(share.find("/"));
  QString sharename = share; sharename.replace(0, machine.length()+1, "");

  label = QString(machine.upper() + ": " + sharename.upper());
  isLocked = false;
  applyUnmount();
  applyInfo(-1);
}
  
void LVI_SMBShare::lock(QString comment)
{
  isLocked = true;
  setText(0, label + " [" + comment + "...]");
}

void LVI_SMBShare::unlock()
{
  isLocked = false;
  if(medium != -1) setText(0, label + " [DB]");
  else setText(0, label);
}

void LVI_SMBShare::applyMount()
{
  isMounted = true;
  setPixmap(0, pixmapcache->get("lvi_smb.png"));
}

void LVI_SMBShare::applyUnmount()
{
  isMounted = false;
	setPixmap(0, pixmapcache->getFaded("lvi_smb.png"));
}
    
void LVI_SMBShare::applyInfo(int mediumid)
{
  medium = mediumid;
  if(medium != -1) setText(0, label + " [DB]");
  else setText(0, label);
}
