/***************************************************************************
                 job_getextradata.cpp  -  description
                             -------------------
    begin                : Wed Dec 2 2003
    copyright            : (C) 2003 by Markus Kalkbrenner
    email                : mkalkbrenner@users.sourceforge.net

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_getextradata.h"

#include "jobmanager.h"
#include "database.h"
#include "datadispatcher.h"
#include "gui.h"
#include "job_countdata.h"

#ifdef EMBEDDED 
  #include <mysql.h>
#endif

Job_GetExtraData::Job_GetExtraData(int type, TRACK _track)
  : track(_track), querytype(type)
{}

Job_GetExtraData::Job_GetExtraData(int type, int id)
  : mediumid(id), querytype(type)
{}

void Job_GetExtraData::run()
{
  int error;

  if (verbose==8) qWarning( "    >run() tread:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

  EXTRADATA_GUI* data;

#ifdef EMBEDDED 
  mysql_thread_init(); 
#endif
  database->lock();

  switch(querytype) {
  case MEXTRAS_ZAP:
    database->zapExtraData();
    jobman->addJob(new Job_CountData());
    break;
  case MEXTRAS_GET:
    if ( gui->getListing()->list()->currentItem() && 
	 track.id  == static_cast<LVI_Track*>(gui->getListing()->list()->currentItem())->getOriginalTrack()->id ) {
      qApp->lock();     // required to avoid "Xlib: unexpected async reply (sequence 0x3761c)!"
      data = database->getExtraData(&track);
      qApp->unlock();
    } else data = new EXTRADATA_GUI(); 
    break;
  default:
    qFatal("Job_GetExtraData 1: Cannot handle this code: %d", querytype);
  }

  error = database->getError();

  database->unlock();

  switch(querytype) {
  case MEXTRAS_ZAP:
    if(!error) {
      ExtraEvent* xe = new ExtraEvent( new EXTRADATA_GUI());
      QApplication::postEvent( gui->getPlaylisting(), xe );  // Qt will delete event  when done
    }
    break;
  case MEXTRAS_GET:
    if(!error &&  gui->getListing()->list()->currentItem() && 
       track.id == static_cast<LVI_Track*>(gui->getListing()->list()->currentItem())->getOriginalTrack()->id ) {
      ExtraEvent* xe = new ExtraEvent( data );
      QApplication::postEvent( gui->getPlaylisting(), xe );  // Qt will delete event  when done
    } else delete data;
    break;
  default:
    qFatal("Job_GetExtraData 2: Cannot handle this code: %d", querytype);
  }

  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();
#ifdef EMBEDDED 
  mysql_thread_end(); 
#endif

  if (verbose==8) qWarning( "    >exit() thread:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

  exit();
}

Job_GetExtraData::~Job_GetExtraData() {}
