#include "job_connecttomixxx.h"

#include "jobmanager.h"
#include "mixxxclient.h"
#include "datadispatcher.h"

Job_ConnectToMixxx::Job_ConnectToMixxx(QString _host, int _port)
  : host(_host), port(_port)
{}

void Job_ConnectToMixxx::run()
{
  int error = 0;

  if (verbose==8) qWarning( "    >run() tread:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

  mixxxClient->lock();
  
  mixxxClient->establishConnection(host, port);
  
  app->lock();

  if(mixxxClient->isConnected()) {
    datadispatcher->eventEstablishedMixxxConnection();
  }
  
  app->unlock();
  mixxxClient->unlock();
  
  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();

  if (verbose==8) qWarning( "    >exit() thread:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

  exit();
}

Job_ConnectToMixxx::~Job_ConnectToMixxx() {}
