/***************************************************************************
                          gui_sourcer.cpp  -  description
                             -------------------
    begin                : Wed May 2 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "gui_sourcer.h"
#include "gui.h"
#include "jobmanager.h"
#include "datadispatcher.h"
#include "job_synchronizewithdatabase.h"
#include "job_computecdromid.h"
#include "job_appendcdromtodatabase.h"
#include "job_appendsmbtodatabase.h"
#include "job_appendnfstodatabase.h"
#include "mtabwatcher.h"
#include "supermountwatcher.h"
#include "submountwatcher.h"
#include "pixmapcache.h"

#include <qfile.h>
#include <qdir.h>
#include <qtextstream.h>
#include <qregexp.h>
#include <qpopupmenu.h>
#include <qtooltip.h>
#include <qmessagebox.h>

#define DELIMITER '#'
#define BLANK     ' '

GUI_Sourcer::GUI_Sourcer(QWidget *parent, const char *name )
  : QListView(parent,name)
{
  rwLock = 0;

  isConnected = false;
  doSynchro = false;
  
  //  setFixedHeight(140);
  addColumn(_("Sources"), -1);
  setColumnWidthMode(0, QListView::Maximum);
  setHScrollBarMode(QScrollView::AlwaysOff);
  setSorting(-1);
  
  // item for local files
  lviHDD = new QListViewItem(this, _("Files on Harddisk"));
  lviHDD->setPixmap(0, pixmapcache->get("lvi_hdd.png"));
  
  connect(this, SIGNAL(contextMenuRequested(QListViewItem*, const QPoint&, int)),
	  this, SLOT(slot_contextMenu(QListViewItem*, const QPoint&, int)));
}


GUI_Sourcer::~GUI_Sourcer() {}

// ##############################################
// # callback for contextmenu
// ##############################################
void GUI_Sourcer::slot_contextMenu(QListViewItem* item, const QPoint &point, int)
{
  if(!item || !item->isSelectable()) return;
  setCurrentItem(item);
  setSelected(item, true);
  
  if(isConnected && item == lviHDD && !doSynchro) {
    QPopupMenu *menu = new QPopupMenu(this);
//-    menu->insertTitle("Harddisk Operations");
    menu->insertItem(pixmapcache->get("action_synchronize.png"), _("Synchronize (prefer Database)"), this, SLOT(slot_menuSynchronize6()), 0, 6);
    menu->insertItem(pixmapcache->get("action_synchronize.png"), _("Synchronize (prefer Sources)"), this, SLOT(slot_menuSynchronize7()), 0, 7);
    menu->insertSeparator();
    menu->insertItem(pixmapcache->get("action_readtags.png"), _("Update + Read Tags"), this, SLOT(slot_menuSynchronize2()), 0, 2);
    menu->insertItem(pixmapcache->get("action_readtags.png"), _("Update + Read Tags (force)"), this, SLOT(slot_menuSynchronize3()), 0, 3);
    menu->insertSeparator();
    menu->insertItem(pixmapcache->get("action_writetags.png"), _("Update + Write Tags"), this, SLOT(slot_menuSynchronize4()), 0, 4);
    menu->insertItem(pixmapcache->get("action_writetags.png"), _("Update + Write Tags (force)"), this, SLOT(slot_menuSynchronize5()), 0, 5);
    menu->insertSeparator();
    menu->insertItem(pixmapcache->get("action_updateonly.png"), _("Update Only"), this, SLOT(slot_menuSynchronize1()), 0, 1);
    menu->insertSeparator();
    menu->insertItem(pixmapcache->get("help.png"), _("More Info"), this, SLOT(slot_menuHelp()), 0, 8);
    if(rwLock > 0) {
      menu->setItemEnabled(1, false);
      menu->setItemEnabled(2, false);
      menu->setItemEnabled(3, false);
      menu->setItemEnabled(4, false);
      menu->setItemEnabled(5, false);
      menu->setItemEnabled(6, false);
      menu->setItemEnabled(7, false);
    }
    menu->exec(point, 0);
    delete menu;
  }
  else if(dynamic_cast<LVI_SMBShare*>(item)) {
    LVI_SMBShare *lvi = static_cast<LVI_SMBShare*>(item);
    if(lvi->getIsLocked()) return;
    QPopupMenu *menu = new QPopupMenu(this);
//-    menu->insertTitle("SMB Share Operations");
    if(lvi->getIsMounted()) {
      menu->insertItem(pixmapcache->get("lvi_smb.png"), _("Unmount"), this, SLOT(slot_menuUnmountSMB()), 0, 1);
      if(isConnected) {
	menu->insertSeparator();
      	if(!lvi->getIsKnown()) {
	  menu->insertItem(pixmapcache->get("action_append.png"), _("Append To Database"), this, SLOT(slot_menuAppendSMB()), 0, 2);
	  if(rwLock > 0) menu->setItemEnabled(2, false);
	} else {
	  currSMB = lvi;
	  menu->insertItem(pixmapcache->get("action_synchronize.png"), _("Synchronize (prefer Database)"), this, SLOT(slot_menuSynchronize16()), 0, 7);
	  menu->insertItem(pixmapcache->get("action_synchronize.png"), _("Synchronize (prefer Sources)"), this, SLOT(slot_menuSynchronize17()), 0, 8);
	  menu->insertSeparator();
	  menu->insertItem(pixmapcache->get("action_readtags.png"), _("Update + Read Tags"), this, SLOT(slot_menuSynchronize12()), 0, 3);
	  menu->insertItem(pixmapcache->get("action_readtags.png"), _("Update + Read Tags (force)"), this, SLOT(slot_menuSynchronize13()), 0, 4);
	  menu->insertSeparator();
	  menu->insertItem(pixmapcache->get("action_writetags.png"), _("Update + Write Tags"), this, SLOT(slot_menuSynchronize14()), 0, 5);
	  menu->insertItem(pixmapcache->get("action_writetags.png"), _("Update + Write Tags (force)"), this, SLOT(slot_menuSynchronize15()), 0, 6);
	  menu->insertSeparator();
	  menu->insertItem(pixmapcache->get("action_updateonly.png"), _("Update Only"), this, SLOT(slot_menuSynchronize11()), 0, 2);
	  if(rwLock > 0) {
	    menu->setItemEnabled(2, false);
	    menu->setItemEnabled(3, false);
	    menu->setItemEnabled(4, false);
	    menu->setItemEnabled(5, false);
	    menu->setItemEnabled(6, false);
	    menu->setItemEnabled(7, false);
	    menu->setItemEnabled(8, false);
	  }	
	}
      }
    } else {
      menu->insertItem(pixmapcache->get("lvi_smb.png"), _("Mount"), this, SLOT(slot_menuMountSMB()), 0, 1);
    }
    menu->exec(point, 0);
    delete menu;
  }

  else if(dynamic_cast<LVI_NFSExport*>(item)) {
    LVI_NFSExport *lvi = static_cast<LVI_NFSExport*>(item);
    if(lvi->getIsLocked()) return;
    QPopupMenu *menu = new QPopupMenu(this);
//-    menu->insertTitle("NFS Share Operations");
    if(lvi->getIsMounted()) {
      menu->insertItem(pixmapcache->get("lvi_nfs.png"), _("Unmount"), this, SLOT(slot_menuUnmountNFS()), 0, 1);
      if(isConnected) {
	menu->insertSeparator();
      	if(!lvi->getIsKnown()) {
	  menu->insertItem(pixmapcache->get("action_append.png"), _("Append To Database"), this, SLOT(slot_menuAppendNFS()), 0, 2);
	  if(rwLock > 0) menu->setItemEnabled(2, false);
	} else {
	  currNFS = lvi;
	  menu->insertItem(pixmapcache->get("action_synchronize.png"), _("Synchronize (prefer Database)"), this, SLOT(slot_menuSynchronize36()), 0, 7);
	  menu->insertItem(pixmapcache->get("action_synchronize.png"), _("Synchronize (prefer Sources)"), this, SLOT(slot_menuSynchronize37()), 0, 8);
	  menu->insertSeparator();
	  menu->insertItem(pixmapcache->get("action_readtags.png"), _("Update + Read Tags"), this, SLOT(slot_menuSynchronize32()), 0, 3);
	  menu->insertItem(pixmapcache->get("action_readtags.png"), _("Update + Read Tags (force)"), this, SLOT(slot_menuSynchronize33()), 0, 4);
	  menu->insertSeparator();
	  menu->insertItem(pixmapcache->get("action_writetags.png"), _("Update + Write Tags"), this, SLOT(slot_menuSynchronize34()), 0, 5);
	  menu->insertItem(pixmapcache->get("action_writetags.png"), _("Update + Write Tags (force)"), this, SLOT(slot_menuSynchronize35()), 0, 6);
	  menu->insertSeparator();
	  menu->insertItem(pixmapcache->get("action_updateonly.png"), _("Update Only"), this, SLOT(slot_menuSynchronize31()), 0, 2);
	  if(rwLock > 0) {
	    menu->setItemEnabled(2, false);
	    menu->setItemEnabled(3, false);
	    menu->setItemEnabled(4, false);
	    menu->setItemEnabled(5, false);
	    menu->setItemEnabled(6, false);
	    menu->setItemEnabled(7, false);
	    menu->setItemEnabled(8, false);
	  }
	}
      }
    } else {
      menu->insertItem(pixmapcache->get("lvi_nfs.png"), _("Mount"), this, SLOT(slot_menuMountNFS()), 0, 1);
    }
    menu->exec(point, 0);
    delete menu;
  }


  else if(dynamic_cast<LVI_CDDrive*>(item)) {
    LVI_CDDrive *lvi = static_cast<LVI_CDDrive*>(item);
    if(lvi->getIsLocked()) return;
    QPopupMenu *menu = new QPopupMenu(this);
//-    menu->insertTitle("CDROM Operations");
    if(lvi->getIsMounted()) {
      if(lvi->getIsAutoMounted() == SUBMOUNT) {
        menu->insertItem(pixmapcache->get("lvi_cdrom.png"), _("Eject"), this, SLOT(slot_menuUnmountCDROM()), 0, 1);
      } else if(lvi->getIsAutoMounted() == NO_AUTOMOUNT) {
        menu->insertItem(pixmapcache->get("lvi_cdrom.png"), _("Unmount"), this, SLOT(slot_menuUnmountCDROM()), 0, 1);
      }
      if(isConnected) {
	menu->insertSeparator();
	if(!lvi->getIsKnown()) {
	  menu->insertItem(pixmapcache->get("action_append.png"), _("Append To Database"), this, SLOT(slot_menuAppendCDROM()), 0, 2);
	  if(rwLock > 0) menu->setItemEnabled(2, false);
	} else {
	  currCDROM = lvi;
	  menu->insertItem(pixmapcache->get("action_updateonly.png"), _("Update Only"), this, SLOT(slot_menuSynchronize21()), 0, 2);
	  if(rwLock > 0) {
	    menu->setItemEnabled(2, false);
	  }
	}
      }
    } else if(lvi->getIsAutoMounted() != SUBMOUNT) {
      menu->insertItem(pixmapcache->get("lvi_cdrom.png"), _("Mount"), this, SLOT(slot_menuMountCDROM()), 0, 1);
    }
    if(menu->idAt(0) != -1) menu->exec(point, 0); // at least one entry
    delete menu;
  }
}

// ##############################################
// # callbacks for menuitems
// ##############################################
void GUI_Sourcer::slot_menuSynchronize1() { jobman->addJob(new Job_SynchronizeWithDatabase(UPDATE_ONLY, NO_PARAMETER)); }
void GUI_Sourcer::slot_menuSynchronize2() { jobman->addJob(new Job_SynchronizeWithDatabase(UPDATE_AND_READ_EXTERN_CHANGED_TRACKS, ONLY_NOT_INTERN_CHANGED)); }
void GUI_Sourcer::slot_menuSynchronize3() { jobman->addJob(new Job_SynchronizeWithDatabase(UPDATE_AND_READ_EXTERN_CHANGED_TRACKS, FORCE_REREAD)); }
void GUI_Sourcer::slot_menuSynchronize4() { jobman->addJob(new Job_SynchronizeWithDatabase(UPDATE_AND_WRITE_INTERN_CHANGED_TRACKS, ONLY_NOT_EXTERN_CHANGED)); }
void GUI_Sourcer::slot_menuSynchronize5() { jobman->addJob(new Job_SynchronizeWithDatabase(UPDATE_AND_WRITE_INTERN_CHANGED_TRACKS, FORCE_WRITE)); }
void GUI_Sourcer::slot_menuSynchronize6() { jobman->addJob(new Job_SynchronizeWithDatabase(UPDATE_AND_SYNCHRONIZE, PREFER_INTERN_CHANGED)); }
void GUI_Sourcer::slot_menuSynchronize7() { jobman->addJob(new Job_SynchronizeWithDatabase(UPDATE_AND_SYNCHRONIZE, PREFER_EXTERN_CHANGED)); }

void GUI_Sourcer::slot_menuSynchronize11() { jobman->addJob(new Job_SynchronizeWithDatabase(currSMB, UPDATE_ONLY, NO_PARAMETER)); }
void GUI_Sourcer::slot_menuSynchronize12() { jobman->addJob(new Job_SynchronizeWithDatabase(currSMB, UPDATE_AND_READ_EXTERN_CHANGED_TRACKS, ONLY_NOT_INTERN_CHANGED)); }
void GUI_Sourcer::slot_menuSynchronize13() { jobman->addJob(new Job_SynchronizeWithDatabase(currSMB, UPDATE_AND_READ_EXTERN_CHANGED_TRACKS, FORCE_REREAD)); }
void GUI_Sourcer::slot_menuSynchronize14() { jobman->addJob(new Job_SynchronizeWithDatabase(currSMB, UPDATE_AND_WRITE_INTERN_CHANGED_TRACKS, ONLY_NOT_EXTERN_CHANGED)); }
void GUI_Sourcer::slot_menuSynchronize15() { jobman->addJob(new Job_SynchronizeWithDatabase(currSMB, UPDATE_AND_WRITE_INTERN_CHANGED_TRACKS, FORCE_WRITE)); }
void GUI_Sourcer::slot_menuSynchronize16() { jobman->addJob(new Job_SynchronizeWithDatabase(currSMB, UPDATE_AND_SYNCHRONIZE, PREFER_INTERN_CHANGED)); }
void GUI_Sourcer::slot_menuSynchronize17() { jobman->addJob(new Job_SynchronizeWithDatabase(currSMB, UPDATE_AND_SYNCHRONIZE, PREFER_EXTERN_CHANGED)); }

void GUI_Sourcer::slot_menuSynchronize31() { jobman->addJob(new Job_SynchronizeWithDatabase(currNFS, UPDATE_ONLY, NO_PARAMETER)); }
void GUI_Sourcer::slot_menuSynchronize32() { jobman->addJob(new Job_SynchronizeWithDatabase(currNFS, UPDATE_AND_READ_EXTERN_CHANGED_TRACKS, ONLY_NOT_INTERN_CHANGED)); }
void GUI_Sourcer::slot_menuSynchronize33() { jobman->addJob(new Job_SynchronizeWithDatabase(currNFS, UPDATE_AND_READ_EXTERN_CHANGED_TRACKS, FORCE_REREAD)); }
void GUI_Sourcer::slot_menuSynchronize34() { jobman->addJob(new Job_SynchronizeWithDatabase(currNFS, UPDATE_AND_WRITE_INTERN_CHANGED_TRACKS, ONLY_NOT_EXTERN_CHANGED)); }
void GUI_Sourcer::slot_menuSynchronize35() { jobman->addJob(new Job_SynchronizeWithDatabase(currNFS, UPDATE_AND_WRITE_INTERN_CHANGED_TRACKS, FORCE_WRITE)); }
void GUI_Sourcer::slot_menuSynchronize36() { jobman->addJob(new Job_SynchronizeWithDatabase(currNFS, UPDATE_AND_SYNCHRONIZE, PREFER_INTERN_CHANGED)); }
void GUI_Sourcer::slot_menuSynchronize37() { jobman->addJob(new Job_SynchronizeWithDatabase(currNFS, UPDATE_AND_SYNCHRONIZE, PREFER_EXTERN_CHANGED)); }

void GUI_Sourcer::slot_menuSynchronize21() { jobman->addJob(new Job_SynchronizeWithDatabase(currCDROM, UPDATE_ONLY, NO_PARAMETER)); }

void GUI_Sourcer::slot_menuHelp() { 
  QMessageBox::information(this, _("About Synchronizing Commands"), 
_("In the following, by \"files\", we mean information from the filesystem and "
"by \"tags\" information kept by Prokyon3 into its database."
"<br><br>"
"<u>Update Only</u><br>"
"New files are read and added to tags. Deleted files are removed from tags.<br>"
"No other tags or files change is taking place.<br>"
" As a result, information from some files can still be different from their tags equivalent.<br>"
"<br>"
"<u>Synchronize</u><br>"
"Same as Update Only command. In addition, write modified tags to files and read tags from modifed files.<br>"
"As an option, one can prefer tags or files when both have been changed.<br>"
"Both files and tags are modified."
"<br><br>"
"<u>Update and Read tags</u><br>"
"Same as Update Only command.<br>"
"In addition, read tags from modified files.<br>"
"As an option one can force read if both files and tags have been changed.<br>"
"Some modified tags may be lost, but files are never modifed."
"<br><br>"
"<u>Update and Write tags</u><br>"
"Same as Update Only command.<br>"
"In addition, write files from modified tags.<br>"
"As an option one can force write if both files and tags have been changed.<br>"
"Some files info may be lost, but tags are never modifed."
"<br><br>"
"Note: Prokyon3 use smart heuristics to detect files moved to"
" another directory or changed file name.") );
}

// ##############################################
// # find CDROM and enable autonotify
// ##############################################
void GUI_Sourcer::init()
{
  QListViewItem *prev = lviHDD;

  // read FSTAB and append to CDROMs to tree
  QFile f(FSTAB);
  if(f.open(IO_ReadOnly)) {
    QTextStream t(&f);
    QString s;
    int count = 0, smbcount = 0, nfscount = 0;
    while(!t.eof()) {
      s = t.readLine();
      s = s.simplifyWhiteSpace();
      if((!s.isEmpty()) && (s.find(DELIMITER) != 0)) {
	QString devicename = s.left(s.find(BLANK));
	s = s.remove(0, s.find(BLANK) + 1);
	QString mountpoint = s.left(s.find(BLANK));
	s = s.remove(0, s.find(BLANK) + 1);
	QString fstype = s.left(s.find(BLANK));
	s = s.remove(0, s.find(BLANK) + 1);
	QString mountoptions = s.left(s.find(BLANK));
	s = s.remove(0, s.find(BLANK) + 1);
	if(fstype.find("smbfs", 0, false) != -1) {
        bool keywordMatch = false;
        QStringList smbKeywords = config->getSmbKeywords();
        if(smbKeywords.isEmpty()) {
            // show all amb shares
            keywordMatch = true;
        } else {
            for(QStringList::Iterator it = smbKeywords.begin(); it != smbKeywords.end(); ++it ) {
                if(devicename.find(*it, 0, false) != -1 || mountpoint.find(*it, 0, false) != -1) {
                    keywordMatch = true;
                    break;
                }
            }
        }
        if(keywordMatch) {
	        smbcount++;
	        LVI_SMBShare *smb = new LVI_SMBShare(this, smbcount, mountpoint, devicename);
	        smb->moveItem(prev);
	        prev = smb;
	        mapSMB[smbcount] = smb;
	        if(isPathMounted(mountpoint)) smb->applyMount();
        }
	}
	else if(fstype.find("nfs", 0, false) != -1) {
        bool keywordMatch = false;
        QStringList nfsKeywords = config->getNfsKeywords();
        if(nfsKeywords.isEmpty()) {
            // show all amb shares
            keywordMatch = true;
        } else {
            for(QStringList::Iterator it = nfsKeywords.begin(); it != nfsKeywords.end(); ++it ) {
                if(devicename.find(*it, 0, false) != -1 || mountpoint.find(*it, 0, false) != -1) {
                    keywordMatch = true;
                    break;
                }
            }
        }
        if(keywordMatch) {
	        nfscount++;
	        LVI_NFSExport *nfs = new LVI_NFSExport(this, nfscount, mountpoint, devicename);
	        nfs->moveItem(prev);
	        prev = nfs;
	        mapNFS[nfscount] = nfs;
	        if(isPathMounted(mountpoint)) nfs->applyMount();
        }
	}
	else if(devicename.find("cdrom", 0, false)       != -1 || mountpoint.find("cdrom", 0, false)       != -1 ||
		devicename.find("dvd", 0, false)         != -1 || mountpoint.find("dvd", 0, false)         != -1 ||
		devicename.find("cdrecorder", 0, false)  != -1 || mountpoint.find("cdrecorder", 0, false)  != -1 ||
		devicename.find("dvdrecorder", 0, false) != -1 || mountpoint.find("dvdrecorder", 0, false) != -1 )
	  //devicename.find("floppy", 0, false) != -1 || mountpoint.find("floppy", 0, false) != -1)
	{
	  count++;
     int automounted = NO_AUTOMOUNT;
     if(fstype.find("supermount",0,false) != -1) {
         // Mandrake 10
         QRegExp rx("dev=([^,\\s]*)");
         if(rx.search(mountoptions) > -1) {
           devicename = rx.cap(1);
         }
         automounted = SUPERMOUNT;
     } else if(fstype.find("subfs",0,false) != -1) {
         automounted = SUBMOUNT;
     }
     
     LVI_CDDrive *lvi = new LVI_CDDrive(this, count, mountpoint, devicename, automounted);
     lvi->moveItem(prev);
       prev = lvi;
        mapCDROM[count] = lvi;
    if((automounted && isPathAutoMounted(mountpoint)) ||
      (!automounted && isPathMounted(mountpoint)))
               jobman->addJob(new Job_ComputeCDROMID(lvi));
	}
      }
    }
    f.close();
  }
  
  // enable autonotify
  
  for(QMap<int, LVI_CDDrive*>::Iterator it = mapCDROM.begin(); it != mapCDROM.end(); ++it)
    { /*- watcher->addDir(it.data()->getPath()); -*/
       if(it.data()->getIsAutoMounted() == SUPERMOUNT)
          supermountwatcher->addDevice(it.data()->getDevice(), it.data()->getPath());
       else if (it.data()->getIsAutoMounted() == SUBMOUNT)
          submountwatcher->addDevice(it.data()->getDevice(), it.data()->getPath());
       else
          mtabwatcher->addDir(it.data()->getPath());
     }
  for(QMap<int, LVI_SMBShare*>::Iterator it = mapSMB.begin(); it != mapSMB.end(); ++it)
    { /*- watcher->addDir(it.data()->getPath()); -*/ mtabwatcher->addDir(it.data()->getPath()); }
  for(QMap<int, LVI_NFSExport*>::Iterator it = mapNFS.begin(); it != mapNFS.end(); ++it)
    { /*- watcher->addDir(it.data()->getPath()); -*/ mtabwatcher->addDir(it.data()->getPath()); }
  
  //  connect(watcher, SIGNAL(dirty(const QString&)), this, SLOT(slot_DirNotify(const QString&)));
}

void GUI_Sourcer::notifyDirHasChanged(QString dir)
{
  int ID = 0;
  
  for(QMap<int, LVI_CDDrive*>::Iterator it = mapCDROM.begin(); it != mapCDROM.end(); ++it)
    if(it.data()->getPath() == dir) ID = it.key();
  if(ID != 0) {
    if(mapCDROM[ID]->getIsMounted()) {
      datadispatcher->eventMediumNoMoreAvailable(mapCDROM[ID]->getCdID());
      mapCDROM[ID]->applyUnmount();
    } else {
      mapCDROM[ID]->applyMount(0);
      if(mapCDROM[ID]->getIsAutoMounted() == SUBMOUNT) {
        submountwatcher->keepMounted(mapCDROM[ID]->getDevice());
      }
      jobman->addJob(new Job_ComputeCDROMID(mapCDROM[ID]));
    }
    return;
  }

  for(QMap<int, LVI_SMBShare*>::Iterator it = mapSMB.begin(); it != mapSMB.end(); ++it)
    if(it.data()->getPath() == dir) ID = it.key();
  if(ID != 0) {
    if(!isPathMounted(dir)) {
      datadispatcher->eventMediumNoMoreAvailable(mapSMB[ID]->getMediumID());
      mapSMB[ID]->applyUnmount();
    } else {
      mapSMB[ID]->applyMount();
      datadispatcher->eventSMBMounted(mapSMB[ID]);
    }
    return;
  }

  for(QMap<int, LVI_NFSExport*>::Iterator it = mapNFS.begin(); it != mapNFS.end(); ++it)
    if(it.data()->getPath() == dir) ID = it.key();
  if(ID != 0) {
    if(!isPathMounted(dir)) {
      datadispatcher->eventMediumNoMoreAvailable(mapNFS[ID]->getMediumID());
      mapNFS[ID]->applyUnmount();
    } else {
      mapNFS[ID]->applyMount();
      datadispatcher->eventNFSMounted(mapNFS[ID]);
    }
    return;
  }
}


// ##############################################
// # check if path is mounted
// ##############################################
bool GUI_Sourcer::isPathMounted(QString path)
{
  QFile f(MTAB);
  if(f.open(IO_ReadOnly)) {
    QTextStream t(&f);
    QString s;
    while(!t.eof()) {
      s = t.readLine();
      s = s.simplifyWhiteSpace();
      if((!s.isEmpty()) && (s.find(DELIMITER) != 0)) {
	QString devicename = s.left(s.find(BLANK));
	s = s.remove(0, s.find(BLANK) + 1);
	QString mountpoint = s.left(s.find(BLANK));
	if(mountpoint == path) {
	  QDir dirinfo(path);
	  if(dirinfo.exists()) {
	    f.close();
	    return true;
	  }
	}
      }
    }
    f.close();
  }
  return false;
}

bool GUI_Sourcer::isPathAutoMounted(QString path)
{
  if(QDir(path).count() > 0) return true;
  return false;
}

void GUI_Sourcer::notifyCDROMInserted(LVI_CDDrive *drive)
{
  int checksum = drive->getChecksum();
  if(mapChecksum.contains(checksum)) drive->applyInfo(true, mapLabel[mapChecksum[checksum]], mapChecksum[checksum]);
  else drive->applyInfo(false, _("Unknown"), -1);
}

void GUI_Sourcer::notifySMBMounted(LVI_SMBShare *share) {
  if(mapSMBDevice.contains(share->getDevice())) share->applyInfo(mapSMBDevice[share->getDevice()]);
  else share->applyInfo(-1);
}

void GUI_Sourcer::notifyNFSMounted(LVI_NFSExport *Export) {
  if(mapNFSDevice.contains(Export->getDevice())) Export->applyInfo(mapNFSDevice[Export->getDevice()]);
  else Export->applyInfo(-1);
}

void GUI_Sourcer::notifyNewMediumBasis(QList<MEDIUM> *list) {
  for(MEDIUM *curr = list->first(); curr != 0; curr = list->next()) notifyNewMedium(curr);
}

void GUI_Sourcer::notifyNewMedium(MEDIUM *medium)
{
  if(medium->type == MEDIUM_CDROM) {
    mapChecksum[medium->checksum] = medium->id;
    mapLabel[medium->id] = medium->label;
    for(QMap<int, LVI_CDDrive*>::Iterator it = mapCDROM.begin(); it != mapCDROM.end(); ++it)
      if(it.data()->getIsMounted() && it.data()->getChecksum() == medium->checksum) datadispatcher->eventCDROMInserted(it.data());
  } else if(medium->type == MEDIUM_SMB) {
    mapSMBDevice[medium->path] = medium->id;
    for(QMap<int, LVI_SMBShare*>::Iterator it = mapSMB.begin(); it != mapSMB.end(); ++it) {
      if(it.data()->getDevice() == medium->path) {
	it.data()->applyInfo(medium->id);
	if(it.data()->getIsMounted()) datadispatcher->eventSMBMounted(it.data());
      }
    }  
  } else if(medium->type == MEDIUM_NFS) {
    mapNFSDevice[medium->path] = medium->id;
    for(QMap<int, LVI_NFSExport*>::Iterator it = mapNFS.begin(); it != mapNFS.end(); ++it) {
      if(it.data()->getDevice() == medium->path) {
	it.data()->applyInfo(medium->id);
	if(it.data()->getIsMounted()) datadispatcher->eventNFSMounted(it.data());
      }
    }  
  }
}

void GUI_Sourcer::notifyMediumRemoved(int id)
{
  if(mapLabel.contains(id)) {
    unsigned checksum = 0;
    for(QMap<unsigned, int>::Iterator it = mapChecksum.begin(); it != mapChecksum.end(); ++it) if(it.data() == id) checksum = it.key();
    mapChecksum.remove(checksum);
    mapLabel.remove(id);
    for(QMap<int, LVI_CDDrive*>::Iterator it = mapCDROM.begin(); it != mapCDROM.end(); ++it)
      if(it.data()->getCdID() == id) it.data()->applyInfo(false, _("Unknown"), it.data()->getChecksum());
  } else { // SMB
    QString device = "";
    for(QMap<QString, int>::Iterator it = mapSMBDevice.begin(); it != mapSMBDevice.end(); ++it) if(it.data() == id) device = it.key();
    if(!device.isEmpty()) {
      for(QMap<int, LVI_SMBShare*>::Iterator it = mapSMB.begin(); it != mapSMB.end(); ++it) {
	if(it.data()->getDevice() == device) it.data()->applyInfo(-1);
      }  
      mapSMBDevice.remove(device);
    }
  // NFS
//    QString device = "";
    for(QMap<QString, int>::Iterator it = mapNFSDevice.begin(); it != mapNFSDevice.end(); ++it) if(it.data() == id) device = it.key();
    if(!device.isEmpty()) {
      for(QMap<int, LVI_NFSExport*>::Iterator it = mapNFS.begin(); it != mapNFS.end(); ++it) {
	if(it.data()->getDevice() == device) it.data()->applyInfo(-1);
      }  
      mapNFSDevice.remove(device);
    }
  }
}

void GUI_Sourcer::notifyMediumRenamed(MEDIUM *medium)
{
  mapLabel[medium->id] = medium->label;
  for (QMap<int, LVI_CDDrive*>::Iterator it = mapCDROM.begin(); it != mapCDROM.end(); ++it) {
    if (it.data()->getCdID() == medium->id) {
      notifyCDROMInserted(it.data());
    }
  }
}

void GUI_Sourcer::notifyStartedHarddiskSynchronizing() {
  doSynchro = true;
  lviHDD->setText(0, QString(_("sync")) + "...");
}

void GUI_Sourcer::notifyStoppedHarddiskSynchronizing() {
  doSynchro = false;
  lviHDD->setText(0, _("Files on Harddisk"));
}

void GUI_Sourcer::notifyStartedCDROMSynchronizing(LVI_CDDrive *drive) {
  drive->lock(_("sync"));
}

void GUI_Sourcer::notifyStoppedCDROMSynchronizing(LVI_CDDrive *drive) {
  drive->unlock();
}

void GUI_Sourcer::notifyStartedSMBSynchronizing(LVI_SMBShare *share) {
  share->lock(_("sync"));
}

void GUI_Sourcer::notifyStoppedSMBSynchronizing(LVI_SMBShare *share) {
  share->unlock();
}

void GUI_Sourcer::notifyStartedNFSSynchronizing(LVI_NFSExport *Export) {
  Export->lock(_("sync"));
}

void GUI_Sourcer::notifyStoppedNFSSynchronizing(LVI_NFSExport *Export) {
  Export->unlock();
}

void GUI_Sourcer::slot_setConnectionState(bool state)
{
  isConnected = state;
  mapChecksum.clear();
  mapLabel.clear();
  mapSMBDevice.clear();
  mapNFSDevice.clear();
  for(QMap<int, LVI_CDDrive*>::Iterator it = mapCDROM.begin(); it != mapCDROM.end(); ++it) if(it.data()->getIsMounted()) notifyCDROMInserted(it.data());
  for(QMap<int, LVI_SMBShare*>::Iterator it = mapSMB.begin(); it != mapSMB.end(); ++it) notifySMBMounted(it.data());
  for(QMap<int, LVI_NFSExport*>::Iterator it = mapNFS.begin(); it != mapNFS.end(); ++it) notifyNFSMounted(it.data());
  rwLock = 0;
}
	
void GUI_Sourcer::slot_menuMountCDROM() {
    LVI_CDDrive *lvi = dynamic_cast<LVI_CDDrive*>(currentItem());
    if(lvi->getIsAutoMounted() == NO_AUTOMOUNT) {
        QString cmd = "mount " + lvi->getPath() + " &";
        system(cmd.local8Bit().data());
    } else if(lvi->getIsAutoMounted() == SUPERMOUNT) {
        QString cmd = "ls " + lvi->getPath() + "> /dev/null &";
        system(cmd.local8Bit().data());
    }
//-	KIO::mount(false, 0, lvi->getDevice(), lvi->getPath());
}

void GUI_Sourcer::slot_menuUnmountCDROM() {
    LVI_CDDrive *lvi = dynamic_cast<LVI_CDDrive*>(currentItem());
    if(lvi->getIsAutoMounted() == NO_AUTOMOUNT) {
        QString cmd = "umount " + lvi->getPath() + " &";
        system(cmd.local8Bit().data());
    } else if(lvi->getIsAutoMounted() == SUBMOUNT){
        submountwatcher->pause();
        QString cmd = "eject " + lvi->getPath() + " &";
        system(cmd.local8Bit().data());
        submountwatcher->release(lvi->getDevice());
        submountwatcher->proceed();
    }
//-	KIO::unmount(lvi->getPath());
}

void GUI_Sourcer::slot_menuMountSMB() {
	LVI_SMBShare *lvi = dynamic_cast<LVI_SMBShare*>(currentItem());
	QString cmd = "mount " + lvi->getPath() + " &";
	system(cmd.local8Bit().data());
//-	KIO::mount(false, 0, lvi->getDevice(), lvi->getPath());
}

void GUI_Sourcer::slot_menuUnmountSMB() {
	LVI_SMBShare *lvi = dynamic_cast<LVI_SMBShare*>(currentItem());
	QString cmd = "umount " + lvi->getPath() + " &";
	system(cmd.local8Bit().data());
//-	KIO::unmount(lvi->getPath());
}

void GUI_Sourcer::slot_menuMountNFS() {
	LVI_NFSExport *lvi = dynamic_cast<LVI_NFSExport*>(currentItem());
	QString cmd = "mount " + lvi->getPath() + " &";
	system(cmd.local8Bit().data());
//-	KIO::mount(false, 0, lvi->getDevice(), lvi->getPath());
}

void GUI_Sourcer::slot_menuUnmountNFS() {
	LVI_NFSExport *lvi = dynamic_cast<LVI_NFSExport*>(currentItem());
	QString cmd = "umount " + lvi->getPath() + " &";
	system(cmd.local8Bit().data());
//-	KIO::unmount(lvi->getPath());
}

void GUI_Sourcer::slot_menuAppendCDROM() {
	LVI_CDDrive *lvi = dynamic_cast<LVI_CDDrive*>(currentItem());
	jobman->addJob(new Job_AppendCDROMToDatabase(lvi));
}

void GUI_Sourcer::slot_menuAppendSMB() {
	LVI_SMBShare *lvi = dynamic_cast<LVI_SMBShare*>(currentItem());
	jobman->addJob(new Job_AppendSMBToDatabase(lvi));
}

void GUI_Sourcer::slot_menuAppendNFS() {
	LVI_NFSExport *lvi = dynamic_cast<LVI_NFSExport*>(currentItem());
	jobman->addJob(new Job_AppendNFSToDatabase(lvi));
}

bool GUI_Sourcer::existsLabel(QString label)
{
	bool existing = false;
	QMap<int, QString>::Iterator it = mapLabel.begin();
	for(; it != mapLabel.end(); ++it) if(it.data() == label) existing = true;
	return existing;
}

LVI_SMBShare *GUI_Sourcer::getSMBByID(int ID)
{
  for(QMap<int, LVI_SMBShare*>::Iterator it = mapSMB.begin(); it != mapSMB.end(); ++it)
    if(it.data()->getMediumID() == ID) return it.data();
  return 0;
}

LVI_NFSExport *GUI_Sourcer::getNFSByID(int ID)
{
  for(QMap<int, LVI_NFSExport*>::Iterator it = mapNFS.begin(); it != mapNFS.end(); ++it)
    if(it.data()->getMediumID() == ID) return it.data();
  return 0;
}

// *** resize ***
void GUI_Sourcer::resizeEvent(QResizeEvent* e)
{
	QListView::resizeEvent(e);
	setColumnWidth(0, visibleWidth());
}
