/******************************************************************************
* Copyright (C) 2009 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.23                                                         *
******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "CPfStadiumsDAOSQLiteEntity.h"
#include "../../../../../exceptions/PFException.h"
#include "../../../../../utils/CLog.h"

CPfStadiumsDAOSQLiteEntity::CPfStadiumsDAOSQLiteEntity(sqlite3 *database)
{
    m_database = database;
}

CPfStadiumsDAOSQLiteEntity::~CPfStadiumsDAOSQLiteEntity()
{
}

void CPfStadiumsDAOSQLiteEntity::setSQLite(sqlite3 *database)
{
    m_database = database;
}

bool CPfStadiumsDAOSQLiteEntity::deleteReg(CPfStadiums *reg)
{
    std::string sql("DELETE FROM PF_STADIUMS WHERE X_STADIUM=");
    sql += "'"+reg->getXStadium_str()+"'";
    return exec(sql);
}

bool CPfStadiumsDAOSQLiteEntity::insertReg(CPfStadiums *reg)
{
    std::string sql("INSERT INTO PF_STADIUMS (D_BUILD,N_CAPACITY,S_NAME,S_PHOTO,X_FK_COUNTRY) VALUES (");
    sql += (reg->getDBuild_str()=="")?"NULL":"'"+reg->getDBuild_str()+"'";
    sql += (reg->getNCapacity_str()=="")?",NULL":",'"+reg->getNCapacity_str()+"'";
    sql += (reg->getSName_str()=="")?",NULL":",'"+reg->getSName_str()+"'";
    sql += (reg->getSPhoto_str()=="")?",NULL":",'"+reg->getSPhoto_str()+"'";
    sql += (reg->getXFkCountry_str()=="")?",NULL":",'"+reg->getXFkCountry_str()+"'";
    sql += ")";
    if( exec(sql) ){
        reg->setXStadium(sqlite3_last_insert_rowid(m_database));
        return true;
    }else{
        return false;
    }
}

bool CPfStadiumsDAOSQLiteEntity::updateReg(CPfStadiums *reg)
{
    std::string sql("UPDATE PF_STADIUMS SET ");
    sql += (reg->getDBuild_str()=="")?" D_BUILD=NULL":" D_BUILD='"+reg->getDBuild_str()+"'";
    sql += (reg->getNCapacity_str()=="")?",N_CAPACITY=NULL":",N_CAPACITY='"+reg->getNCapacity_str()+"'";
    sql += (reg->getSName_str()=="")?",S_NAME=NULL":",S_NAME='"+reg->getSName_str()+"'";
    sql += (reg->getSPhoto_str()=="")?",S_PHOTO=NULL":",S_PHOTO='"+reg->getSPhoto_str()+"'";
    sql += (reg->getXStadium_str()=="")?",X_STADIUM=NULL":",X_STADIUM='"+reg->getXStadium_str()+"'";
    sql += (reg->getXFkCountry_str()=="")?",X_FK_COUNTRY=NULL":",X_FK_COUNTRY='"+reg->getXFkCountry_str()+"'";
    sql += " WHERE X_STADIUM='"+reg->getXStadium_str()+"'";
    return exec(sql);
}

void CPfStadiumsDAOSQLiteEntity::freeVector(std::vector<CPfStadiums*>* vector )
{
    std::vector<CPfStadiums*>::iterator it;
    for( it=vector->begin(); it!=vector->end(); it++ ){
        delete (*it);
        (*it) = NULL;
    }
    delete vector;
}

CPfStadiums* CPfStadiumsDAOSQLiteEntity::loadRegister(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    CPfStadiums *destiny = new CPfStadiums();
    int result = sqlite3_exec(m_database, sql.c_str(), callbackRegister, destiny, &msgError);
    if( result!=SQLITE_OK && result!=SQLITE_ABORT ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return destiny;
}

std::vector<CPfStadiums*> * CPfStadiumsDAOSQLiteEntity::loadVector(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    std::vector<CPfStadiums*> *container = new std::vector<CPfStadiums*>;
    int result = sqlite3_exec(m_database, sql.c_str(), callbackVector, container, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return container;
}

bool CPfStadiumsDAOSQLiteEntity::exec(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    bool correct = true;
    int result = sqlite3_exec(m_database, sql.c_str(), NULL, NULL, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
        correct = false;
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return correct;
}

int CPfStadiumsDAOSQLiteEntity::callbackRegister(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        CPfStadiums *destiny = (CPfStadiums*)object;
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "D_BUILD")==0 ){
                destiny->setDBuild_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "N_CAPACITY")==0 ){
                destiny->setNCapacity_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_NAME")==0 ){
                destiny->setSName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_PHOTO")==0 ){
                destiny->setSPhoto_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_STADIUM")==0 ){
                destiny->setXStadium_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_COUNTRY")==0 ){
                destiny->setXFkCountry_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
    }
    return -1; // Abort, don't load more rows
}

int CPfStadiumsDAOSQLiteEntity::callbackVector(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        std::vector<CPfStadiums*> *container = (std::vector<CPfStadiums*> *)object;
        CPfStadiums *destiny = new CPfStadiums();
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "D_BUILD")==0 ){
                destiny->setDBuild_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "N_CAPACITY")==0 ){
                destiny->setNCapacity_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_NAME")==0 ){
                destiny->setSName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_PHOTO")==0 ){
                destiny->setSPhoto_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_STADIUM")==0 ){
                destiny->setXStadium_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_COUNTRY")==0 ){
                destiny->setXFkCountry_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
        container->push_back(destiny);
    }
    return 0; // All OK
}

