/******************************************************************************
* Copyright (C) 2009 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.23                                                         *
******************************************************************************/

#include <iostream>
#include <sstream>

#include "CPfScorersDAOSQLite.h"

CPfScorersDAOSQLite::CPfScorersDAOSQLite(sqlite3 *database)
  : CPfScorersDAOSQLiteEntity(database)
{
}

CPfScorersDAOSQLite::~CPfScorersDAOSQLite()
{
}

std::vector<CPfScorers*>* CPfScorersDAOSQLite::findScorersByXSeasonAndXCompetition(int XSeason, int XCompetition)
{
    std::ostringstream season;
    std::ostringstream competition;
    season << XSeason;
    competition << XCompetition;

    std::string sql("");
    sql += "SELECT "
                 "TP.S_NAME as S_TEAM_PLAYER, "
                 "TP.S_SHORT_NAME as S_SHORT_TEAM_PLAYER_NAME, "
                 "T.S_TEAM, "
                 "T.S_SHORT_NAME as S_SHORT_TEAM_NAME, "
                 "COUNT(*) AS N_GOALS "
           "FROM PF_GOALS G "
           "JOIN PF_TEAMS T ON T.X_TEAM = G.X_FK_TEAM_SCORER "
           "JOIN PF_TEAM_PLAYERS TP ON TP.X_TEAM_PLAYER = G.X_FK_TEAM_PLAYER_SCORER "
           "JOIN PF_MATCHES M ON M.X_MATCH = G.X_FK_MATCH "
           "JOIN PF_COMPETITION_PHASES CP ON CP.X_COMPETITION_PHASE = M.X_FK_COMPETITION_PHASE "
           "WHERE G.L_OWN_GOAL = 'N' "
             "AND M.X_FK_SEASON = " + season.str() + " "
             "AND CP.X_FK_COMPETITION = " + competition.str() + " "
           "GROUP BY S_TEAM_PLAYER "
           "ORDER BY N_GOALS DESC";
    return loadVector(sql);
}
