# dictformat-usage.rb: Converter module for my usage dict.
# $Id: dictformat-usage.rb,v 1.2 2005/03/07 07:51:33 komatsu Exp $
#
# Copyright (C) 2004 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.

require 'prime/makedict/dictformat'
$KCODE = 'e'

class DictFormatUsage < DictFormat
  def initialize (is_interactive = true)
    super(is_interactive)
    @default_pos  = nil
    @default_freq = 0
    @default_attr = nil
  end

  def parse (line)
    if line =~ /^ *;/ then
      return nil
    end
    line.chomp!
    (reading, pos, literal, comment) = line.split(/\t/)
    comment = "usage=" + comment
    result = [reading, pos, literal, @default_freq, comment]
    return [result]
  end
end
