//
//  PRImage.h
//  PRICE
//
//  Created by Riccardo Mottola on Wed Oct 12 2005.
//  Copyright (c) 2005-2010 Carduus. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

// this class implements a tailored variation of NSImage for PRICE
// the assumption that each time only one representation (of bitmap type) is available is done
// thus it can be made directly accessible as well as some of its properties can be cached

#import <AppKit/AppKit.h>


@interface PRImage : NSImage
{
    @private NSBitmapImageRep *bitRep;
    @private int              pixelH;
    @private int              pixelW;
    @private int              bitsPerPixel;
}

- (int)height;
- (int)width;
- (int)bitsPP;
- (NSSize)pixelSize;
- (NSBitmapImageRep *)bitmapRep;


@end
