//
//  PRInvert.m
//  PRICE
//
//  Created by Riccardo Mottola on Fri Dec 07 2007.
//  Copyright (c) 2007 Carduus. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#include <limits.h>
#import "PRInvert.h"


@implementation PRInvert

- (PRImage *)filterImage:(PRImage *)srcImage
{
    NSBitmapImageRep *srcImageRep;
    PRImage          *destImage;
    NSBitmapImageRep *destImageRep;
    int              w, h;
    int              x, y;
    unsigned char    *srcData;
    unsigned char    *destData;
    unsigned char    *p1;
    unsigned char    *p2;
    int              bytesPerPixel;


    /* get source image representation and associated information */
    srcImageRep = [srcImage tiffRep];

    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;


    /* allocate destination image and its representation */
    destImage = [[PRImage alloc] initWithSize:NSMakeSize(w, h)];
    destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                                  pixelsWide:w
                                  pixelsHigh:h
                               bitsPerSample:8
                             samplesPerPixel:[srcImageRep samplesPerPixel]
                                    hasAlpha:[srcImageRep hasAlpha]
                                    isPlanar:NO
                              colorSpaceName:[srcImageRep colorSpaceName]
                                 bytesPerRow:0
                                bitsPerPixel:0];

    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];

    /* execute the actual filtering  */
    /* take in account if image has alpha and if it is has one or 3 samples */
    /* alpha shall be preserved and not inverted */
    if ([srcImageRep hasAlpha])
    {
        if ([srcImageRep samplesPerPixel] == 2)
            for (y = 0; y < h; y++)
                for (x = 0; x < w; x++)
                {
                    p1 = srcData + bytesPerPixel * (y * w + x);
                    p2 = destData + bytesPerPixel * (y * w + x);
                    p2[0] = UCHAR_MAX - p1[0];
                }
        else
            for (y = 0; y < h; y++)
                for (x = 0; x < w; x++)
                {
                    p1 = srcData + bytesPerPixel * (y * w + x);
                    p2 = destData + bytesPerPixel * (y * w + x);
                    p2[0] = UCHAR_MAX - p1[0];
                    p2[1] = p1[1];
                }

    } else
    {
        if ([srcImageRep samplesPerPixel] == 1)
            for (y = 0; y < h; y++)
                for (x = 0; x < w; x++)
                {
                    p1 = srcData + bytesPerPixel * (y * w + x);
                    p2 = destData + bytesPerPixel * (y * w + x);
                    p2[0] = UCHAR_MAX - p1[0];
                }
        else
            for (y = 0; y < h; y++)
                for (x = 0; x < w; x++)
                {
                    p1 = srcData + bytesPerPixel * (y * w + x);
                    p2 = destData + bytesPerPixel * (y * w + x);
                    p2[0] = UCHAR_MAX - p1[0];
                    p2[1] = UCHAR_MAX - p1[1];
                    p2[2] = UCHAR_MAX - p1[2];
                }
    }
    [destImage addRepresentation:destImageRep];
    [destImageRep release];
    [destImage autorelease];
    return destImage;
}


@end
