/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: emphnode.h,v $
 * Revision 1.1.1.1  2001/01/30 18:36:41  slash
 * Initial release.
 *
 */

#ifndef EMPHNODE_H
#define EMPHNODE_H


#include "inlinenode.h"


//---------------------------------------------------------------------------
/**
 * This class represents an emph-node.
 */
class EmphNode : public InlineNode { 
  public:
    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the emph-node.
     *
     * @param node The XML-node, which represents the emph-node.
     */
    EmphNode(xmlNodePtr node);

    //-----------------------------------------------------------------------
    /**
     * Destructor.
     */
    ~EmphNode();
};

#endif //EMPHNODE_H
