  /*  menu.c - powershell
   *  Copyright (C) 1999  Matt Spong <spong@glue.umd.edu>
   *  Based from zterm.c by Michael Zucci from the libzvt docs
   *
   *  A big, puffy lotsa-shells-in-one app. 
   *
   *  This program is free software; you can redistribute it and/or modify
   *  it under the terms of the GNU General Public License as published by
   *  the Free Software Foundation; either version 2 of the License, or
   *  (at your option) any later version.
   *
   *  This program is distributed in the hope that it will be useful,
   *  but WITHOUT ANY WARRANTY; without even the implied warranty of
   *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   *  GNU General Public License for more details.
   *
   *  You should have received a copy of the GNU General Public License
   *  along with this program; if not, write to the Free Software
   *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "powershell.h"

GnomeUIInfo * file_menu, *file_menu2;
GnomeUIInfo edit_menu[] = {
  GNOMEUIINFO_MENU_CUT_ITEM (MenuHandler, 101),
  GNOMEUIINFO_MENU_COPY_ITEM (MenuHandler, 102),
  GNOMEUIINFO_MENU_PASTE_ITEM (MenuHandler, 103),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_PREFERENCES_ITEM (MenuHandler, 104),
  GNOMEUIINFO_MENU_NEW_ITEM ("Choose Font...", "Choose a font", MenuHandler, 105),
  GNOMEUIINFO_END
};

GnomeUIInfo help_menu[] = {
  GNOMEUIINFO_HELP("powershell"),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_ABOUT_ITEM(MenuHandler, 1001),
  GNOMEUIINFO_END
};

int mn, mn2;

GnomeUIInfo menubar[5];
GtkWidget * hidemenubaritem, * hidemenubaritem2;
GtkWidget * hidestatusbaritem, * hidestatusbaritem2;

int i=0;

void Dump_Menus(GnomeUIInfo * a)
{
  GnomeUIInfo * t;

  int b;
  t = a;
  while (t->type != GNOME_APP_UI_ENDOFINFO)
    {
      if (t->type == GNOME_APP_UI_SUBTREE)
	{
	  for (b=0;b<i;b++)
	    printf ("  ");
	  printf ("->Subtree: %s\n", t->label);
	  i++;
	  Dump_Menus(t->moreinfo);
	  i--;
	  for (b=0;b<i;b++)
	    printf ("  ");
	  printf ("->End Subtree: %s\n", t->label);
	}
      else
	{
	  for (b=0;b<i;b++)
	    printf ("  ");
	  printf ("%s\n", t->label);
	}
      t++;
    }
}

GnomeUIInfo * build_menus(int starting_point, int * ending_point)
     /***** god-awful recursive function to build the menus *****/
{
  int a;
  int b = 1;
  GnomeUIInfo * submenu, * tmp;
  char * tmp2;

  submenu = NULL;
		   
  a = starting_point;

  while ((a < num_apps) && (strcmp (app_entries[a].command, "<decrease>")))
    {
      if (strcmp (app_entries[a].command, "<increase>"))
	{
	  b++;
	  if (submenu)
	    submenu = (GnomeUIInfo *)realloc (submenu, (sizeof(GnomeUIInfo)*b));
	  else
	    submenu = (GnomeUIInfo *)malloc (sizeof(GnomeUIInfo) * b);

	  submenu[b-2].label = app_entries[a].menu_item_title;
	  submenu[b-2].accelerator_key = 0;
	  submenu[b-2].moreinfo = MenuHandler;
	  submenu[b-2].user_data = (gpointer)(a+1);
	  
	  submenu[b-2].hint = app_entries[a].command;
	  submenu[b-2].type = GNOME_APP_UI_ITEM;
	  submenu[b-2].pixmap_type = GNOME_APP_PIXMAP_STOCK;
	  submenu[b-2].pixmap_info = strstr(app_entries[a].command, "%s")  ? 
	    GNOME_STOCK_PIXMAP_CONVERT : GNOME_STOCK_MENU_EXEC;
	  submenu[b-1].type = GNOME_APP_UI_ENDOFINFO;
	}      
      else
	{
	  b++;

	  if (submenu)
	    submenu = (GnomeUIInfo *)realloc (submenu, (sizeof(GnomeUIInfo)*b));
	  else
	    submenu = (GnomeUIInfo *)malloc (sizeof(GnomeUIInfo)*b);

	  tmp = build_menus(a+1, &a);
	  tmp2 = app_entries[a].menu_item_title;
	  bzero (&submenu[b-2], sizeof(GnomeUIInfo));
	  submenu[b-2].label = tmp2;
	  submenu[b-2].type = GNOME_APP_UI_SUBTREE;
	  submenu[b-2].moreinfo = tmp;
	  submenu[b-1].type = GNOME_APP_UI_ENDOFINFO;
	}
      a++;
    }

  *ending_point = a;
  return submenu;
}

int InitMenus (GtkWidget * window)
{
  int a;
  int b;
  char * tmp;
  int rebuilding=0;
  int nom;
  GtkWidget * curmenu;

  if (GNOME_APP(window)->menubar)
    {
      /* this is probably going to cause a memory leak.
	 it shouldn't be too big, but I think it's there.

	 I'll have to find a better way to do this later.
      */

      rebuilding = 1;

      free (file_menu);
      free (file_menu2);
    }

  bzero (menubar, sizeof(GnomeUIInfo) * 5);

  file_menu = build_menus(0, &b);
  file_menu2 = build_menus(0, &b);

  Dump_Menus(file_menu);

  file_menu = (GnomeUIInfo *)realloc (file_menu, sizeof(GnomeUIInfo)*(b+11));
  file_menu2 = (GnomeUIInfo *)realloc (file_menu2, sizeof(GnomeUIInfo)*(b+11));

  for (a=0;file_menu[a].type != GNOME_APP_UI_ENDOFINFO;a++)
    ;
  
  bzero (file_menu+a, sizeof(GnomeUIInfo) * ((b+11) - a));
  bzero (file_menu2+a, sizeof(GnomeUIInfo) * ((b+11) - a));

  nom = a;

  file_menu[a].type = GNOME_APP_UI_SEPARATOR;
  
  a++;
  file_menu[a].type = GNOME_APP_UI_ITEM;
  file_menu[a].label = (gchar *)malloc (13);
  strcpy (file_menu[a].label, "_Rename Term");
  file_menu[a].accelerator_key = 0;
  file_menu[a].moreinfo = MenuHandler;
  file_menu[a].user_data = (gpointer) 97;
  file_menu[a].hint = "Rename Term";
  file_menu[a].pixmap_type = GNOME_APP_PIXMAP_STOCK;
  file_menu[a].pixmap_info = GNOME_STOCK_MENU_REFRESH;

  a++;
  file_menu[a].type = GNOME_APP_UI_ITEM;
  file_menu[a].label = (gchar *)malloc (8);
  strcpy (file_menu[a].label, "_Run...");
  file_menu[a].accelerator_key = 0;
  file_menu[a].moreinfo = MenuHandler;
  file_menu[a].user_data = (gpointer) 96;
  file_menu[a].hint = "Run a Program";
  file_menu[a].pixmap_type = GNOME_APP_PIXMAP_STOCK;
  file_menu[a].pixmap_info = GNOME_STOCK_MENU_BOOK_BLUE;
  
  a++;
  file_menu[a].type = GNOME_APP_UI_SEPARATOR;
  
  a++;
  file_menu[a].type = GNOME_APP_UI_ITEM;
  file_menu[a].label = (gchar *)malloc (7);
  strcpy (file_menu[a].label, "_Close");
  file_menu[a].accelerator_key = 0;
  file_menu[a].moreinfo = MenuHandler;
  file_menu[a].user_data = (gpointer) 98;
  file_menu[a].hint = "Close this Terminal";
  file_menu[a].pixmap_type = GNOME_APP_PIXMAP_STOCK;
  file_menu[a].pixmap_info = GNOME_STOCK_MENU_CLOSE;

  a++;
  file_menu[a].type = GNOME_APP_UI_TOGGLEITEM;
  file_menu[a].label = (gchar *)malloc (15);

  strcpy (file_menu[a].label, "_Hide Menu Bar");

  file_menu[a].accelerator_key = 0;
  file_menu[a].moreinfo = MenuHandler;
  file_menu[a].user_data = (gpointer) 94;
  file_menu[a].hint = "Hide or Unhide the Menu Bar";
  file_menu[a].pixmap_type = GNOME_APP_PIXMAP_NONE;
  file_menu[a].pixmap_info = (gpointer)0;

  mn = a;
  
  a++;
  file_menu[a].type = GNOME_APP_UI_TOGGLEITEM;
  file_menu[a].label = (gchar *)malloc (15);

  strcpy (file_menu[a].label, "_Hide Status Bar");

  file_menu[a].accelerator_key = 0;
  file_menu[a].moreinfo = MenuHandler;
  file_menu[a].user_data = (gpointer) 93;
  file_menu[a].hint = "Hide or Unhide the Status Bar";
  file_menu[a].pixmap_type = GNOME_APP_PIXMAP_NONE;
  file_menu[a].pixmap_info = (gpointer)0;

  mn2 = a;
  
  a++;
  file_menu[a].type = GNOME_APP_UI_ITEM;
  file_menu[a].label = (gchar *)malloc (6);
  strcpy (file_menu[a].label, "_Quit");
  file_menu[a].accelerator_key = 0;
  file_menu[a].moreinfo = MenuHandler;
  file_menu[a].user_data = (gpointer) 99;
  file_menu[a].hint = "Quit the Program";
  file_menu[a].pixmap_type = GNOME_APP_PIXMAP_STOCK;
  file_menu[a].pixmap_info = GNOME_STOCK_MENU_QUIT;

  a++;
  file_menu[a].type = GNOME_APP_UI_ENDOFINFO;

  menubar[0].type = GNOME_APP_UI_SUBTREE;
  menubar[0].label = (gchar *)malloc (6);
  strcpy (menubar[0].label, "_File");
  menubar[0].hint = (gchar *)malloc (10);
  strcpy (menubar[0].hint, "File Menu");
  menubar[0].moreinfo = (gpointer)file_menu;
  
  menubar[1].type = GNOME_APP_UI_SUBTREE;
  menubar[1].label = (gchar *)malloc (6);
  strcpy (menubar[1].label, "_Edit");
  menubar[1].hint = (gchar *)malloc (10);
  strcpy (menubar[1].hint, "Edit Menu");
  menubar[1].moreinfo = (gpointer)edit_menu;

  menubar[2].type = GNOME_APP_UI_SUBTREE;
  menubar[2].label = (gchar *)malloc (6);
  strcpy (menubar[2].label, "_Help");
  menubar[2].hint = (gchar *)malloc (10);
  strcpy (menubar[2].hint, "Help Menu");
  menubar[2].moreinfo = (gpointer)help_menu;

  menubar[3].type = GNOME_APP_UI_ENDOFINFO;

  for (a=nom;file_menu[a].type != GNOME_APP_UI_ENDOFINFO;a++)
    file_menu2[a] = file_menu[a];
  
  if (!rebuilding)
    {
      gnome_app_create_menus (GNOME_APP(window), menubar);
       
      hidemenubaritem = (GtkWidget*)(&(file_menu[mn]));
      hidemenubaritem2 = (GtkWidget*)(&(file_menu2[mn]));

      hidestatusbaritem = (GtkWidget*)(&(file_menu[mn2]));
      hidestatusbaritem2 = (GtkWidget*)(&(file_menu2[mn2]));

    }
  else
    {
      gnome_app_remove_menus (GNOME_APP(window), "_File/", 1000);
      gnome_app_insert_menus (GNOME_APP(window), "_File/", file_menu);
    }

  gtk_widget_hide (file_menu[mn].widget);
  gtk_widget_hide (file_menu[mn2].widget);


  popup_file = gnome_popup_menu_new (file_menu2);

  GTK_CHECK_MENU_ITEM(file_menu2[mn].widget)->active = Prefs.hidemenubar;
  GTK_CHECK_MENU_ITEM(file_menu2[mn2].widget)->active = Prefs.hidestatusbar;
  
  return 0;
}



