/*                                            
Skin.cc
*/

#include "Skin.h"

extern Language *L;

Skin::Skin (void)
  {
  beginDecorationTable = new StringList();
  endDecorationTable = new StringList();  
  xstrncpy (theiconset, CSMALLBUFFER, DEFOPT_ICON_SET);  
  xstrncpy (theskin, MAXLENGTHSKIN, DEFOPT_SKIN);
  setSkin (theskin);
  DISPLAYBUTTONLABELS = true;
  ICONS_SIZE = ICONS_SIZE_SMALL;
  initStr(ICONSIZE);
  }

Skin::~Skin (void)
  {
  delete beginDecorationTable;
  delete endDecorationTable;  
  }

bool Skin::getDisplayButtonLabels (void)
  {
  return DISPLAYBUTTONLABELS;
  }

void Skin::setDisplayButtonLabels (bool value)
  {
  DISPLAYBUTTONLABELS = value;;
  }

const char *Skin::getCSSPage (void)
  {
  if (strcmp (theskin, "CLASSIC") == 0) 
    {
    return CSS_SKIN_CLASSIC;
    }
  else if (strcmp (theskin, "OLIVE") == 0) 
    {
    return CSS_SKIN_OLIVE;
    }
  else if (strcmp (theskin, "RED") == 0) 
    {
    return CSS_SKIN_RED;
    }
  else if (strcmp (theskin, "BLUE") == 0) 
    {
    return CSS_SKIN_BLUE;
    }
  else if (strcmp (theskin, "ORANGE") == 0)
    {
    return CSS_SKIN_ORANGE;
    }
  else
    {
    return CSS_SKIN_DEFAULT;
    }                                  
  }
  
void Skin::setSkin (const char *askin)
  {  
  beginDecorationTable->Clear();
  endDecorationTable->Clear();
  xstrncpy (theskin, MAXLENGTHSKIN, askin);
  xucase (theskin);
  if (strcmp (theskin, "CLASSIC") == 0) 
    {
    xstrncpy (COLOR_BGTABLE,              MAXLENGTHCOLORHTML, "#CCCCCC");
    xstrncpy (COLOR_BGTABLECOPYRIGHT,     MAXLENGTHCOLORHTML, "#CCCCCC");
    xstrncpy (COLOR_BGBOTONERA,           MAXLENGTHCOLORHTML, "#CCCCCC");
    xstrncpy (COLOR_BGTABLEMSGINDEX,      MAXLENGTHCOLORHTML, "#CCCCCC");    
    xstrncpy (COLOR_BGBODY,               MAXLENGTHCOLORHTML, "#CCCCCC");        
    xstrncpy (COLOR_BGTEXTO,              MAXLENGTHCOLORHTML, "#000000");
    xstrncpy (COLOR_BGFILASMSGINDEX,      MAXLENGTHCOLORHTML, "#E6E6E6");
    xstrncpy (COLOR_BGFILASADDBOOK,       MAXLENGTHCOLORHTML, "#E6E6E6");    
    xstrncpy (COLOR_FONT_TABLE,           MAXLENGTHCOLORHTML, "#000000");    
    xstrncpy (COLOR_FONT_MAIN,            MAXLENGTHCOLORHTML, "#000000");    
    xstrncpy (COLOR_FONT_STATUS,          MAXLENGTHCOLORHTML, "#000000");
    xstrncpy (COLOR_FONT_STATUSLINE,      MAXLENGTHCOLORHTML, "#0000FF");
    xstrncpy (COLOR_FONT_TABLECOPYRIGHT,  MAXLENGTHCOLORHTML, "#000000");        
    xstrncpy (COLOR_BGFILASREADINGMSG,    MAXLENGTHCOLORHTML, "#FFF0DC");
    xstrncpy (FONT_TABLE,                 MAXLENGTHFONTNAME, "Arial,PrimaSans BT,Verdana,sans-serif");    
    xstrncpy (FONT_MAIN,                  MAXLENGTHFONTNAME, "Arial,PrimaSans BT,Verdana,sans-serif");        
    xstrncpy (FONT_STATUS,                MAXLENGTHFONTNAME, "Arial,PrimaSans BT,Verdana,sans-serif");            
    xstrncpy (FONT_TABLECOPYRIGHT,        MAXLENGTHFONTNAME, "Arial,PrimaSans BT,Verdana,sans-serif");                
    FONT_TABLE_SIZE  = 2;
    FONT_MAIN_SIZE   = 2;
    FONT_STATUS_SIZE = 2;
    FONT_BOTONERA_SIZE = 1;
    FONT_TABLECOPYRIGHT_SIZE = -1;
    xsnprintf (IMG_BG, CSMALLBUFFER, "%s/%s/background.jpg", PATH_IMAGENS, theiconset);
    setIconSet(DEFOPT_ICON_SET);
    xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"32\" HEIGHT=\"32\" "); 
    xstrncpy (BODYMARGINS, CSMALLBUFFER, " ");
    }
  else if (strcmp (theskin, "OLIVE") == 0) 
    {
    xstrncpy (COLOR_BGTABLE,              MAXLENGTHCOLORHTML, "#888800"); 
    xstrncpy (COLOR_BGTABLECOPYRIGHT,     MAXLENGTHCOLORHTML, "#888866");
    xstrncpy (COLOR_BGBOTONERA,           MAXLENGTHCOLORHTML, "#888866");
    xstrncpy (COLOR_BGTABLEMSGINDEX,      MAXLENGTHCOLORHTML, "#888800");    
    xstrncpy (COLOR_BGBODY,               MAXLENGTHCOLORHTML, "#AAAA66");        
    xstrncpy (COLOR_BGTEXTO,              MAXLENGTHCOLORHTML, "#000000");
    xstrncpy (COLOR_BGFILASMSGINDEX,      MAXLENGTHCOLORHTML, "#888866");
    xstrncpy (COLOR_BGFILASADDBOOK,       MAXLENGTHCOLORHTML, "#FFF0DC");    
    xstrncpy (COLOR_FONT_TABLE,           MAXLENGTHCOLORHTML, "#222200");    
    xstrncpy (COLOR_FONT_MAIN,            MAXLENGTHCOLORHTML, "#222200");    
    xstrncpy (COLOR_FONT_STATUS,          MAXLENGTHCOLORHTML, "#AAFF00");
    xstrncpy (COLOR_FONT_STATUSLINE,      MAXLENGTHCOLORHTML, "#0000FF");                  
    xstrncpy (COLOR_FONT_TABLECOPYRIGHT,  MAXLENGTHCOLORHTML, "#000000");        
    xstrncpy (COLOR_BGFILASREADINGMSG,    MAXLENGTHCOLORHTML, "#888866");
    xstrncpy (FONT_TABLE,                 MAXLENGTHFONTNAME, "Arial, Helvetica, sans-serif");    
    xstrncpy (FONT_MAIN,                  MAXLENGTHFONTNAME, "Times New Roman");        
    xstrncpy (FONT_STATUS,                MAXLENGTHFONTNAME, "Lucida Blackletter");            
    xstrncpy (FONT_TABLECOPYRIGHT,        MAXLENGTHFONTNAME, "Arial,PrimaSans BT,Verdana,sans-serif");                
    FONT_TABLE_SIZE  = 3;
    FONT_MAIN_SIZE   = 3;
    FONT_STATUS_SIZE = 3;
    FONT_BOTONERA_SIZE = 1;
    FONT_TABLECOPYRIGHT_SIZE = -1;
    xsnprintf (IMG_BG, CSMALLBUFFER, " ");
    setIconSet("set2");  
    switch (ICONS_SIZE)
      {
      case ICONS_SIZE_MEDIUM: xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"32\" HEIGHT=\"32\" "); break;
      case ICONS_SIZE_BIG:    xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"40\" HEIGHT=\"40\" "); break;      
      case ICONS_SIZE_SMALL:  xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"24\" HEIGHT=\"24\" "); break;
      default: xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"32\" HEIGHT=\"32\" "); break; 
      }        
    xstrncpy (BODYMARGINS, CSMALLBUFFER, " ");
    
    beginDecorationTable->Add ("<TABLE WIDTH=\"100%%\" VALIGN=\"top\" cellspacing=\"0\">");  
    beginDecorationTable->Add ("<TR>");      
    beginDecorationTable->Add ("<TD BGCOLOR=\"#888866\" VALIGN=\"top\" ROWSPAN=\"3\">");      
    beginDecorationTable->Add ("<FONT COLOR=\"#888866\"> &copy;<BR></FONT>");
    beginDecorationTable->Add ("</TD>");      
    beginDecorationTable->Add ("<TD COLSPAN=\"1\" BGCOLOR=\"#888866\">");  
    beginDecorationTable->Add ("<A HREF=\"http://correo.uv.es\">");
    beginDecorationTable->Add ("<IMG SRC=\"/postman/icons/uv.gif\" align=\"bottom\" border=\"0\" alt=\"\"></a>");
    beginDecorationTable->Add ("<A HREF=\"http://www.uv.es/ciuv\"><IMG SRC=\"/postman/icons/siuv.gif\" align=\"bottom\" border=\"0\" alt=\"\"></a>\n");
    beginDecorationTable->Add ("</TD>");    
    beginDecorationTable->Add ("</TR>");      
    beginDecorationTable->Add ("<TD>");      

    endDecorationTable->Add ("</TD>");
    endDecorationTable->Add ("</TR>");
    endDecorationTable->Add ("</TABLE>");
    }                          
  else if (strcmp (theskin, "RED") == 0) 
    {
    xstrncpy (COLOR_BGTABLE,              MAXLENGTHCOLORHTML, "#DD5555"); 
    xstrncpy (COLOR_BGTABLECOPYRIGHT,     MAXLENGTHCOLORHTML, "#DD6666");
    xstrncpy (COLOR_BGBOTONERA,           MAXLENGTHCOLORHTML, "#DD6666");
    xstrncpy (COLOR_BGTABLEMSGINDEX,      MAXLENGTHCOLORHTML, "#DD6666");    
    xstrncpy (COLOR_BGBODY,               MAXLENGTHCOLORHTML, "#DDAAAA");        
    xstrncpy (COLOR_BGTEXTO,              MAXLENGTHCOLORHTML, "#000000");
    xstrncpy (COLOR_BGFILASMSGINDEX,      MAXLENGTHCOLORHTML, "#BBAAAA");
    xstrncpy (COLOR_BGFILASADDBOOK,       MAXLENGTHCOLORHTML, "#BBAAAA");    
    xstrncpy (COLOR_FONT_TABLE,           MAXLENGTHCOLORHTML, "#FFFF00");    
    xstrncpy (COLOR_FONT_MAIN,            MAXLENGTHCOLORHTML, "#000000");    
    xstrncpy (COLOR_FONT_STATUS,          MAXLENGTHCOLORHTML, "#000000");
    xstrncpy (COLOR_FONT_STATUSLINE,      MAXLENGTHCOLORHTML, "#0000FF");
    xstrncpy (COLOR_FONT_TABLECOPYRIGHT,  MAXLENGTHCOLORHTML, "#000000");        
    xstrncpy (COLOR_BGFILASREADINGMSG,    MAXLENGTHCOLORHTML, "#BBAAAA");
    xstrncpy (FONT_TABLE,                 MAXLENGTHFONTNAME, "Arial, Helvetica, sans-serif");    
    xstrncpy (FONT_MAIN,                  MAXLENGTHFONTNAME, "Times New Roman");        
    xstrncpy (FONT_STATUS,                MAXLENGTHFONTNAME, "Lucida Blackletter");            
    xstrncpy (FONT_TABLECOPYRIGHT,        MAXLENGTHFONTNAME, "Arial,PrimaSans BT,Verdana,sans-serif");                
    FONT_TABLE_SIZE  = 3;
    FONT_MAIN_SIZE   = 3;
    FONT_STATUS_SIZE = 3;
    FONT_BOTONERA_SIZE = 1;
    FONT_TABLECOPYRIGHT_SIZE = -1;
    xsnprintf (IMG_BG, CSMALLBUFFER, " ");
    setIconSet("set2");  
    switch (ICONS_SIZE)
      {
      case ICONS_SIZE_MEDIUM: xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"32\" HEIGHT=\"32\" "); break;
      case ICONS_SIZE_BIG:    xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"40\" HEIGHT=\"40\" "); break;      
      case ICONS_SIZE_SMALL:  xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"24\" HEIGHT=\"24\" "); break;
      default: xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"32\" HEIGHT=\"32\" "); break; 
      }        
    xstrncpy (BODYMARGINS, CSMALLBUFFER, " ");
    
    beginDecorationTable->Add ("<TABLE WIDTH=\"100%%\" VALIGN=\"top\" cellspacing=\"0\">");  
    beginDecorationTable->Add ("<TR>\n");      
    beginDecorationTable->Add ("<TD BGCOLOR=\"#DD6666\" VALIGN=\"top\" ROWSPAN=\"3\">\n");      
    beginDecorationTable->Add ("<FONT COLOR=\"#DD6666\"> &copy;<BR></FONT>\n");
    beginDecorationTable->Add ("</TD>\n");      
    beginDecorationTable->Add ("<TD COLSPAN=\"1\" BGCOLOR=\"#DD6666\">\n");  
    beginDecorationTable->Add ("<A HREF=\"http://correo.uv.es\">\n");
    beginDecorationTable->Add ("<IMG SRC=\"/postman/icons/uv.gif\" align=\"bottom\" border=\"0\" alt=\"\"></a>");
    beginDecorationTable->Add ("<A HREF=\"http://www.uv.es/ciuv\"><IMG SRC=\"/postman/icons/siuv.gif\" align=\"bottom\" border=\"0\" alt=\"\"></a>\n");
    beginDecorationTable->Add ("</TD>\n");    
    beginDecorationTable->Add ("</TR>\n");      
    beginDecorationTable->Add ("<TD>\n");      

    endDecorationTable->Add ("</TD>\n");
    endDecorationTable->Add ("</TR>\n");
    endDecorationTable->Add ("</TABLE>\n");
    }                                  
  else if (strcmp (theskin, "BLUE") == 0) 
    {
    xstrncpy (COLOR_BGTABLE,              MAXLENGTHCOLORHTML, "#DBEAF5"); 
    xstrncpy (COLOR_BGTABLECOPYRIGHT,     MAXLENGTHCOLORHTML, "#DBEAF5");
    xstrncpy (COLOR_BGBOTONERA,           MAXLENGTHCOLORHTML, "#DBEAF5");
    xstrncpy (COLOR_BGTABLEMSGINDEX,      MAXLENGTHCOLORHTML, "#DBEAF5");    
    xstrncpy (COLOR_BGBODY,               MAXLENGTHCOLORHTML, "#337799");
    xstrncpy (COLOR_BGTEXTO,              MAXLENGTHCOLORHTML, "#000000");
    xstrncpy (COLOR_BGFILASMSGINDEX,      MAXLENGTHCOLORHTML, "#FFFFFF");
    xstrncpy (COLOR_BGFILASADDBOOK,       MAXLENGTHCOLORHTML, "#FFFFFF");    
    xstrncpy (COLOR_FONT_TABLE,           MAXLENGTHCOLORHTML, "#FFFF00");    
    xstrncpy (COLOR_FONT_MAIN,            MAXLENGTHCOLORHTML, "#000000");    
    xstrncpy (COLOR_FONT_STATUS,          MAXLENGTHCOLORHTML, "#000000");
    xstrncpy (COLOR_FONT_STATUSLINE,      MAXLENGTHCOLORHTML, "#000000");
    xstrncpy (COLOR_FONT_TABLECOPYRIGHT,  MAXLENGTHCOLORHTML, "#000000");        
    xstrncpy (COLOR_BGFILASREADINGMSG,    MAXLENGTHCOLORHTML, "#DBEAF0");
    xstrncpy (FONT_TABLE,                 MAXLENGTHFONTNAME, "Arial, Helvetica, sans-serif");    
    xstrncpy (FONT_MAIN,                  MAXLENGTHFONTNAME, "Times New Roman");        
    xstrncpy (FONT_STATUS,                MAXLENGTHFONTNAME, "Lucida Blackletter");            
    xstrncpy (FONT_TABLECOPYRIGHT,        MAXLENGTHFONTNAME, "Arial,PrimaSans BT,Verdana,sans-serif");                
    FONT_TABLE_SIZE  = 3;
    FONT_MAIN_SIZE   = 3;
    FONT_STATUS_SIZE = 3;
    FONT_BOTONERA_SIZE = 1;
    FONT_TABLECOPYRIGHT_SIZE = -1;
    xsnprintf (IMG_BG, CSMALLBUFFER, " ");
    setIconSet("set2");  
    switch (ICONS_SIZE)
      {
      case ICONS_SIZE_MEDIUM: xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"32\" HEIGHT=\"32\" "); break;
      case ICONS_SIZE_BIG:    xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"40\" HEIGHT=\"40\" "); break;      
      case ICONS_SIZE_SMALL:  xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"24\" HEIGHT=\"24\" "); break;
      default: xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"32\" HEIGHT=\"32\" "); break; 
      }        
    xstrncpy (BODYMARGINS, CSMALLBUFFER, " ");
    
    beginDecorationTable->Add ("<TABLE WIDTH=\"100%%\" VALIGN=\"top\" cellspacing=\"0\">");  
    beginDecorationTable->Add ("<TR>\n");      
    beginDecorationTable->Add ("<TD BGCOLOR=\"#DBEAF5\" VALIGN=\"top\" ROWSPAN=\"3\">\n");      
    beginDecorationTable->Add ("<FONT COLOR=\"#DBEAF5\"> &copy;<BR></FONT>\n");
    beginDecorationTable->Add ("</TD>\n");      
    beginDecorationTable->Add ("<TD COLSPAN=\"1\" BGCOLOR=\"#DBEAF5\">\n");  
    beginDecorationTable->Add ("<A HREF=\"http://correo.uv.es\">\n");
    beginDecorationTable->Add ("<IMG SRC=\"/postman/icons/uv.gif\" align=\"bottom\" border=\"0\" alt=\"\"></a>");
    beginDecorationTable->Add ("<A HREF=\"http://www.uv.es/ciuv\"><IMG SRC=\"/postman/icons/siuv.gif\" align=\"bottom\" border=\"0\" alt=\"\"></a>\n");
    beginDecorationTable->Add ("</TD>\n");    
    beginDecorationTable->Add ("</TR>\n");      
    beginDecorationTable->Add ("<TD>\n");      

    endDecorationTable->Add ("</TD>\n");
    endDecorationTable->Add ("</TR>\n");
    endDecorationTable->Add ("</TABLE>\n");
    }    
  else if (strcmp (theskin, "ORANGE") == 0)
    {
    xstrncpy (COLOR_BGTABLE,              MAXLENGTHCOLORHTML, "#CCCCCC");
    xstrncpy (COLOR_BGTABLECOPYRIGHT,     MAXLENGTHCOLORHTML, "#555555");
    xstrncpy (COLOR_BGBOTONERA,           MAXLENGTHCOLORHTML, "#FFFFFF");
    xstrncpy (COLOR_BGTABLEMSGINDEX,      MAXLENGTHCOLORHTML, "#CCCCCC");
    xstrncpy (COLOR_BGBODY,               MAXLENGTHCOLORHTML, "#CCCCCC");        
    xstrncpy (COLOR_BGTEXTO,              MAXLENGTHCOLORHTML, "#000000");
    xstrncpy (COLOR_BGFILASMSGINDEX,      MAXLENGTHCOLORHTML, "#E6E6E6");
    xstrncpy (COLOR_BGFILASADDBOOK,       MAXLENGTHCOLORHTML, "#E6E6E6");    
    xstrncpy (COLOR_FONT_TABLE,           MAXLENGTHCOLORHTML, "#000000");    
    xstrncpy (COLOR_FONT_MAIN,            MAXLENGTHCOLORHTML, "#000000");    
    xstrncpy (COLOR_FONT_STATUS,          MAXLENGTHCOLORHTML, "#000000");
    xstrncpy (COLOR_FONT_STATUSLINE,      MAXLENGTHCOLORHTML, "#66a848");
    xstrncpy (COLOR_FONT_TABLECOPYRIGHT,  MAXLENGTHCOLORHTML, "#FFFFFF");        
    xstrncpy (COLOR_BGFILASREADINGMSG,    MAXLENGTHCOLORHTML, "#E6E6E6");
    xstrncpy (FONT_TABLE,                 MAXLENGTHFONTNAME, "Arial,PrimaSans BT,Verdana,sans-serif");    
    xstrncpy (FONT_MAIN,                  MAXLENGTHFONTNAME, "Arial,PrimaSans BT,Verdana,sans-serif");        
    xstrncpy (FONT_STATUS,                MAXLENGTHFONTNAME, "Arial,PrimaSans BT,Verdana,sans-serif");            
    xstrncpy (FONT_TABLECOPYRIGHT,        MAXLENGTHFONTNAME, "Arial,PrimaSans BT,Verdana,sans-serif");                
    FONT_TABLE_SIZE  = 2;
    FONT_MAIN_SIZE   = 2;
    FONT_STATUS_SIZE = 2;
    FONT_BOTONERA_SIZE = 1;
    FONT_TABLECOPYRIGHT_SIZE = -1;
    xsnprintf (IMG_BG, CSMALLBUFFER, "%s/%s/fondouv.gif", PATH_IMAGENS, theiconset);
    setIconSet("set2");  
    switch (ICONS_SIZE)
      {
      case ICONS_SIZE_MEDIUM: xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"32\" HEIGHT=\"32\" "); break;
      case ICONS_SIZE_BIG:    xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"40\" HEIGHT=\"40\" "); break;      
      case ICONS_SIZE_SMALL:  xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"24\" HEIGHT=\"24\" "); break;
      default: xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"32\" HEIGHT=\"32\" "); break; 
      }        
    xstrncpy (BODYMARGINS, CSMALLBUFFER, " topmargin=\"0\" leftmargin=\"0\" marginheight=\"0\" marginwidth=\"0\" "); 
    
    beginDecorationTable->Add ("<TABLE  BGCOLOR=\"#ffffff\" WIDTH=\"100%%\" cellspacing=\"5\" cellpadding=\"0\">");  
    beginDecorationTable->Add ("<TR>\n");      
    beginDecorationTable->Add ("<TD COLSPAN=\"1\" BGCOLOR=\"#ff7310\">\n");      
    beginDecorationTable->Add ("<A HREF=\"http://www.uv.es\"><IMG SRC=\"/postman/icons/uv.gif\"        align=\"bottom\" border=\"0\" alt=\"\"></a>\n");
    beginDecorationTable->Add ("<A HREF=\"http://www.uv.es/ciuv\"><IMG SRC=\"/postman/icons/siuv.gif\" align=\"bottom\" border=\"0\" alt=\"\"></a>\n");
    beginDecorationTable->Add ("</TD>\n");      
    beginDecorationTable->Add ("</TR>\n");      
    beginDecorationTable->Add ("<TD>\n");      

    endDecorationTable->Add ("</TD>\n");
    endDecorationTable->Add ("</TR>\n");
    endDecorationTable->Add ("</TABLE>\n");
    }                                                                            
  else
    {
    xstrncpy (COLOR_BGTABLE,              MAXLENGTHCOLORHTML, "#CCCCCC");
    xstrncpy (COLOR_BGTABLECOPYRIGHT,     MAXLENGTHCOLORHTML, "#555555");
    xstrncpy (COLOR_BGBOTONERA,           MAXLENGTHCOLORHTML, "#FFFFFF");
    xstrncpy (COLOR_BGTABLEMSGINDEX,      MAXLENGTHCOLORHTML, "#CCCCCC");
    xstrncpy (COLOR_BGBODY,               MAXLENGTHCOLORHTML, "#CCCCCC");        
    xstrncpy (COLOR_BGTEXTO,              MAXLENGTHCOLORHTML, "#000000");
    xstrncpy (COLOR_BGFILASMSGINDEX,      MAXLENGTHCOLORHTML, "#E6E6E6");
    xstrncpy (COLOR_BGFILASADDBOOK,       MAXLENGTHCOLORHTML, "#E6E6E6");    
    xstrncpy (COLOR_FONT_TABLE,           MAXLENGTHCOLORHTML, "#000000");    
    xstrncpy (COLOR_FONT_MAIN,            MAXLENGTHCOLORHTML, "#000000");    
    xstrncpy (COLOR_FONT_STATUS,          MAXLENGTHCOLORHTML, "#000000");
    xstrncpy (COLOR_FONT_STATUSLINE,      MAXLENGTHCOLORHTML, "#66a848");
    xstrncpy (COLOR_FONT_TABLECOPYRIGHT,  MAXLENGTHCOLORHTML, "#FFFFFF");        
    xstrncpy (COLOR_BGFILASREADINGMSG,    MAXLENGTHCOLORHTML, "#E6E6E6");
    xstrncpy (FONT_TABLE,                 MAXLENGTHFONTNAME, "Arial,PrimaSans BT,Verdana,sans-serif");    
    xstrncpy (FONT_MAIN,                  MAXLENGTHFONTNAME, "Arial,PrimaSans BT,Verdana,sans-serif");        
    xstrncpy (FONT_STATUS,                MAXLENGTHFONTNAME, "Arial,PrimaSans BT,Verdana,sans-serif");            
    xstrncpy (FONT_TABLECOPYRIGHT,        MAXLENGTHFONTNAME, "Arial,PrimaSans BT,Verdana,sans-serif");                
    FONT_TABLE_SIZE  = 2;
    FONT_MAIN_SIZE   = 2;
    FONT_STATUS_SIZE = 2;
    FONT_BOTONERA_SIZE = 1;
    FONT_TABLECOPYRIGHT_SIZE = -1;
    xsnprintf (IMG_BG, CSMALLBUFFER, "%s/%s/fondouv.gif", PATH_IMAGENS, theiconset);
    setIconSet("set2");  
    switch (ICONS_SIZE)
      {
      case ICONS_SIZE_MEDIUM: xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"32\" HEIGHT=\"32\" "); break;
      case ICONS_SIZE_BIG:    xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"40\" HEIGHT=\"40\" "); break;      
      case ICONS_SIZE_SMALL:  xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"24\" HEIGHT=\"24\" "); break;
      default: xstrncpy (ICONSIZE, CSMALLBUFFER, " WIDTH=\"32\" HEIGHT=\"32\" "); break; 
      }        
    xstrncpy (BODYMARGINS, CSMALLBUFFER, " topmargin=\"0\" leftmargin=\"0\" marginheight=\"0\" marginwidth=\"0\" "); 
    
    beginDecorationTable->Add ("<TABLE  BGCOLOR=\"#ffffff\" WIDTH=\"100%%\" cellspacing=\"5\" cellpadding=\"0\">");  
    beginDecorationTable->Add ("<TR>\n");      
    beginDecorationTable->Add ("<TD COLSPAN=\"1\" BGCOLOR=\"#ff7310\">\n");      
    beginDecorationTable->Add ("<A HREF=\"http://www.uv.es\"><IMG SRC=\"/postman/icons/uv.gif\"        align=\"bottom\" border=\"0\" alt=\"\"></a>\n");
    beginDecorationTable->Add ("<A HREF=\"http://www.uv.es/ciuv\"><IMG SRC=\"/postman/icons/siuv.gif\" align=\"bottom\" border=\"0\" alt=\"\"></a>\n");
    beginDecorationTable->Add ("</TD>\n");      
    beginDecorationTable->Add ("</TR>\n");      
    beginDecorationTable->Add ("<TD>\n");      

    endDecorationTable->Add ("</TD>\n");
    endDecorationTable->Add ("</TR>\n");
    endDecorationTable->Add ("</TABLE>\n");
    }                                      
  }

int Skin::getSkinAtribPropI (const char *propiedad)
  {
  if      (strcmp (propiedad, "FONT_TABLE_SIZE") == 0)          {return FONT_TABLE_SIZE;}
  else if (strcmp (propiedad, "FONT_MAIN_SIZE") == 0)           {return FONT_MAIN_SIZE;}  
  else if (strcmp (propiedad, "FONT_STATUS_SIZE") == 0)         {return FONT_STATUS_SIZE;}    
  else if (strcmp (propiedad, "FONT_BOTONERA_SIZE") == 0)       {return FONT_BOTONERA_SIZE;}      
  else if (strcmp (propiedad, "FONT_TABLECOPYRIGHT_SIZE") == 0) {return FONT_TABLECOPYRIGHT_SIZE;}        
  else return -1;
  }  
  
char *Skin::getSkinAtribProp (const char *propiedad)
  {
  if      (strcmp (propiedad, "COLOR_BGTABLE") == 0)             {return COLOR_BGTABLE;}
  else if (strcmp (propiedad, "COLOR_BGTABLECOPYRIGHT") == 0)    {return COLOR_BGTABLECOPYRIGHT;}  
  else if (strcmp (propiedad, "COLOR_BGBOTONERA") == 0)          {return COLOR_BGBOTONERA;}  
  else if (strcmp (propiedad, "COLOR_BGTABLEMSGINDEX") == 0)     {return COLOR_BGTABLEMSGINDEX;}    
  else if (strcmp (propiedad, "COLOR_BGBODY") == 0)              {return COLOR_BGBODY;}      
  else if (strcmp (propiedad, "COLOR_BGTEXTO") == 0)             {return COLOR_BGTEXTO;}      
  else if (strcmp (propiedad, "COLOR_BGFILASMSGINDEX") == 0)     {return COLOR_BGFILASMSGINDEX;}      
  else if (strcmp (propiedad, "COLOR_BGFILASADDBOOK") == 0)      {return COLOR_BGFILASADDBOOK;}      
  else if (strcmp (propiedad, "COLOR_BGFILASREADINGMSG") == 0)   {return COLOR_BGFILASREADINGMSG;}      
  else if (strcmp (propiedad, "COLOR_FONT_TABLE") == 0)          {return COLOR_FONT_TABLE;}      
  else if (strcmp (propiedad, "COLOR_FONT_MAIN") == 0)           {return COLOR_FONT_MAIN;}      
  else if (strcmp (propiedad, "COLOR_FONT_STATUS") == 0)         {return COLOR_FONT_STATUS;}   
  else if (strcmp (propiedad, "COLOR_FONT_STATUSLINE") == 0)     {return COLOR_FONT_STATUSLINE;}      
  else if (strcmp (propiedad, "COLOR_FONT_TABLECOPYRIGHT") == 0) {return COLOR_FONT_TABLECOPYRIGHT;}        
  else if (strcmp (propiedad, "FONT_TABLE") == 0)                {return FONT_TABLE;}
  else if (strcmp (propiedad, "FONT_MAIN") == 0)                 {return FONT_MAIN;}        
  else if (strcmp (propiedad, "FONT_STATUS") == 0)               {return FONT_STATUS;}        
  else if (strcmp (propiedad, "FONT_TABLECOPYRIGHT") == 0)       {return FONT_TABLECOPYRIGHT;}          
  else if (strcmp (propiedad, "IMG_BG") == 0)                    {return IMG_BG;}        
  else if (strcmp (propiedad, "BODYMARGINS") == 0)               {return BODYMARGINS;}            
  else return "";
  }
 
const char *Skin::getSkin (void)
  {
  return theskin;
  }   
  
void Skin::setIconSet (const char *aiconset)
  {
  xstrncpy (theiconset, CSMALLBUFFER, aiconset);
  }    

void Skin::setIconsSize (int size)
  {
  ICONS_SIZE = size;
  }
    
const char *Skin::getI (int WHAT)
  {
  switch (L->getLang())
    {
    case LANG_ENGLISH:  return getImageEnglish (WHAT); 
    case LANG_SPANISH:  return getImageSpanish (WHAT); 
    case LANG_CATALA :  return getImageCatala (WHAT); 
    case LANG_EUSKERA : return getImageEuskera (WHAT); 
    default: return getImageEnglish (WHAT); 
    }
  }  

const char *Skin::getISize (void)
  {
  return ICONSIZE;
  }

const char *Skin::getImageEnglish (int WHAT)
  {
  return getImageNoLang (WHAT);
  }
  
const char *Skin::getImageSpanish (int WHAT)
  {
  return getImageNoLang (WHAT);
  } 

const char *Skin::getImageCatala (int WHAT)
  {
  return getImageNoLang (WHAT);
  } 
  
const char *Skin::getImageEuskera (int WHAT)
  {
  return getImageNoLang (WHAT);
  } 

const char *Skin::getImageNoLang (int WHAT)
  {
  static TBuffer abuff;
  switch (WHAT)
    {
    case IMG_LOGO:            xsnprintf (abuff, CMAXBUFFER, "%s/%s/logo.gif", PATH_IMAGENS, theiconset); break;
    case IMG_FLAG_DELETED:    xsnprintf (abuff, CMAXBUFFER, "%s/%s/flag_deleted.gif", PATH_IMAGENS, theiconset); break;
    case IMG_FLAG_ANSWERED:   xsnprintf (abuff, CMAXBUFFER, "%s/%s/flag_answered.gif", PATH_IMAGENS, theiconset); break;
    case IMG_FLAG_FLAGGED:    xsnprintf (abuff, CMAXBUFFER, "%s/%s/flag_flagged.gif", PATH_IMAGENS, theiconset); break;
    case IMG_FLAG_UNSEEN:     xsnprintf (abuff, CMAXBUFFER, "%s/%s/flag_unseen.gif", PATH_IMAGENS, theiconset); break;
    case IMG_FLAG_SEARCHED:   xsnprintf (abuff, CMAXBUFFER, "%s/%s/flag_searched.gif", PATH_IMAGENS, theiconset); break;
    case IMG_FLAG_UNDELETED:  xsnprintf (abuff, CMAXBUFFER, "%s/%s/flag_undeleted.gif", PATH_IMAGENS, theiconset); break;
    case IMG_FLAG_UNANSWERED: xsnprintf (abuff, CMAXBUFFER, "%s/%s/flag_unanswered.gif", PATH_IMAGENS, theiconset); break;
    case IMG_FLAG_UNFLAGGED:  xsnprintf (abuff, CMAXBUFFER, "%s/%s/flag_unflagged.gif", PATH_IMAGENS, theiconset); break;
    case IMG_FLAG_SEEN:       xsnprintf (abuff, CMAXBUFFER, "%s/%s/flag_seen.gif", PATH_IMAGENS, theiconset); break;
    case IMG_FLAG_UNSEARCHED: xsnprintf (abuff, CMAXBUFFER, "%s/%s/flag_unsearched.gif", PATH_IMAGENS, theiconset); break;
    case IMG_FLAG_COPIED:     xsnprintf (abuff, CMAXBUFFER, "%s/%s/flag_copied.gif", PATH_IMAGENS, theiconset); break;
    case IMG_FLAG_UNCOPIED:   xsnprintf (abuff, CMAXBUFFER, "%s/%s/flag_uncopied.gif", PATH_IMAGENS, theiconset); break;
    case IMG_LEFT_ARROW:      xsnprintf (abuff, CMAXBUFFER, "%s/%s/arrow_left.gif", PATH_IMAGENS, theiconset); break;
    case IMG_RIGHT_ARROW:     xsnprintf (abuff, CMAXBUFFER, "%s/%s/arrow_right.gif", PATH_IMAGENS, theiconset); break;        
    case L_LOGOUT:            xsnprintf (abuff, CMAXBUFFER, "%s/%s/logout.gif", PATH_IMAGENS, theiconset); break;
    case L_NEXTPAGE_ACT:      xsnprintf (abuff, CMAXBUFFER, "%s/%s/nextpage.gif", PATH_IMAGENS, theiconset); break;
    case L_NEXTPAGE_INA:      xsnprintf (abuff, CMAXBUFFER, "%s/%s/nextpage_ina.gif", PATH_IMAGENS, theiconset); break;
    case L_PREVPAGE_ACT:      xsnprintf (abuff, CMAXBUFFER, "%s/%s/prevpage.gif", PATH_IMAGENS, theiconset); break;
    case L_PREVPAGE_INA:      xsnprintf (abuff, CMAXBUFFER, "%s/%s/prevpage_ina.gif", PATH_IMAGENS, theiconset); break;
    case L_FIRSTPAGE_ACT:     xsnprintf (abuff, CMAXBUFFER, "%s/%s/firstpage.gif", PATH_IMAGENS, theiconset); break;
    case L_FIRSTPAGE_INA:     xsnprintf (abuff, CMAXBUFFER, "%s/%s/firstpage_ina.gif", PATH_IMAGENS, theiconset); break;
    case L_LASTPAGE_ACT:      xsnprintf (abuff, CMAXBUFFER, "%s/%s/lastpage.gif", PATH_IMAGENS, theiconset); break;
    case L_LASTPAGE_INA:      xsnprintf (abuff, CMAXBUFFER, "%s/%s/lastpage_ina.gif", PATH_IMAGENS, theiconset); break;   
    case L_DUMPFULLMSG:       xsnprintf (abuff, CMAXBUFFER, "%s/%s/dumpfullmsg.gif", PATH_IMAGENS, theiconset); break;
    case L_DUMPFULLHEADER:    xsnprintf (abuff, CMAXBUFFER, "%s/%s/dumpfullheader.gif", PATH_IMAGENS, theiconset); break;    
    case L_NEXTMSG:           xsnprintf (abuff, CMAXBUFFER, "%s/%s/nextmsg.gif", PATH_IMAGENS, theiconset); break;
    case L_PREVMSG:           xsnprintf (abuff, CMAXBUFFER, "%s/%s/prevmsg.gif", PATH_IMAGENS, theiconset); break;
    case L_NEXTMSG_INA:       xsnprintf (abuff, CMAXBUFFER, "%s/%s/nextmsg_ina.gif", PATH_IMAGENS, theiconset); break;
    case L_PREVMSG_INA:       xsnprintf (abuff, CMAXBUFFER, "%s/%s/prevmsg_ina.gif", PATH_IMAGENS, theiconset); break;        
    case L_EXPUNGE:           xsnprintf (abuff, CMAXBUFFER, "%s/%s/expunge.gif", PATH_IMAGENS, theiconset); break;
    case L_HELP:              xsnprintf (abuff, CMAXBUFFER, "%s/%s/help.gif", PATH_IMAGENS, theiconset); break;   
    case L_COMPOSEMSG:        xsnprintf (abuff, CMAXBUFFER, "%s/%s/compose.gif", PATH_IMAGENS, theiconset); break;
    case L_MAILBOXES:         xsnprintf (abuff, CMAXBUFFER, "%s/%s/showmailboxes.gif", PATH_IMAGENS, theiconset); break;
    case L_CANCEL:            xsnprintf (abuff, CMAXBUFFER, "%s/%s/cancel.gif", PATH_IMAGENS, theiconset); break;
    case L_CONFIRM:           xsnprintf (abuff, CMAXBUFFER, "%s/%s/confirm.gif", PATH_IMAGENS, theiconset); break;
    case L_REPLYMSG:          xsnprintf (abuff, CMAXBUFFER, "%s/%s/reply.gif", PATH_IMAGENS, theiconset); break;
    case L_REPLYALLMSG:       xsnprintf (abuff, CMAXBUFFER, "%s/%s/replyall.gif", PATH_IMAGENS, theiconset); break;    
    case L_FORWARDMSG:        xsnprintf (abuff, CMAXBUFFER, "%s/%s/forward.gif", PATH_IMAGENS, theiconset); break;
    case L_SHOWOPTIONS:       xsnprintf (abuff, CMAXBUFFER, "%s/%s/showoptions.gif", PATH_IMAGENS, theiconset); break;    
    case L_ADDBOOK:           xsnprintf (abuff, CMAXBUFFER, "%s/%s/addbook.gif", PATH_IMAGENS, theiconset); break;    
    case L_AB_EDITENTRY:      xsnprintf (abuff, CMAXBUFFER, "%s/%s/editentry.gif", PATH_IMAGENS, theiconset); break;
    case L_BACK:              xsnprintf (abuff, CMAXBUFFER, "%s/%s/back.gif", PATH_IMAGENS, theiconset); break;
    case L_SAVEADDRESS:       xsnprintf (abuff, CMAXBUFFER, "%s/%s/saveaddress.gif", PATH_IMAGENS, theiconset); break;
    case L_INDEXMAILBOX:      xsnprintf (abuff, CMAXBUFFER, "%s/%s/littleback.gif", PATH_IMAGENS, theiconset); break;
    case L_AB_NEWENTRY:       xsnprintf (abuff, CMAXBUFFER, "%s/%s/ab_newentry.gif", PATH_IMAGENS, theiconset); break;
    case L_AB_NEWENTRY_S:     xsnprintf (abuff, CMAXBUFFER, "%s/%s/ab_newentry_small.gif", PATH_IMAGENS, theiconset); break;
    case L_DELNEXTMSG:        xsnprintf (abuff, CMAXBUFFER, "%s/%s/paperbox.gif", PATH_IMAGENS, theiconset); break;
    case L_UNDELNEXTMSG:      xsnprintf (abuff, CMAXBUFFER, "%s/%s/unpaperbox.gif", PATH_IMAGENS, theiconset); break;    
    case L_ABOUT:             xsnprintf (abuff, CMAXBUFFER, "%s/%s/about.gif", PATH_IMAGENS, theiconset); break;
    case L_AB_DUMP:           xsnprintf (abuff, CMAXBUFFER, "%s/%s/dump.gif", PATH_IMAGENS, theiconset); break;
    case L_AB_DUMP_S:         xsnprintf (abuff, CMAXBUFFER, "%s/%s/dump_small.gif", PATH_IMAGENS, theiconset); break;
    case L_SECURITYPROBLEM:   xsnprintf (abuff, CMAXBUFFER, "%s/%s/security.gif", PATH_IMAGENS, theiconset); break;        
    case L_SENDTONNTPGROUP:   xsnprintf (abuff, CMAXBUFFER, "%s/%s/replyall.gif", PATH_IMAGENS, theiconset); break;            
    case L_COMPOSEMSGNNTP:    xsnprintf (abuff, CMAXBUFFER, "%s/%s/replyall.gif", PATH_IMAGENS, theiconset); break;                
    case L_FILE:              xsnprintf (abuff, CMAXBUFFER, "%s/%s/file.gif", PATH_IMAGENS, theiconset); break;
    case L_FOLDER:            xsnprintf (abuff, CMAXBUFFER, "%s/%s/folder.gif", PATH_IMAGENS, theiconset); break;
    case L_PARENTFOLDER:      xsnprintf (abuff, CMAXBUFFER, "%s/%s/parentdir.gif", PATH_IMAGENS, theiconset); break;
    case L_EDIT:              xsnprintf (abuff, CMAXBUFFER, "%s/%s/edit.gif", PATH_IMAGENS, theiconset); break;     
    case L_ROOT:              xsnprintf (abuff, CMAXBUFFER, "%s/%s/desktop.gif", PATH_IMAGENS, theiconset); break;         
    case L_MAIL:              xsnprintf (abuff, CMAXBUFFER, "%s/%s/mail.gif", PATH_IMAGENS, theiconset); break;
    case L_NNTP:              xsnprintf (abuff, CMAXBUFFER, "%s/%s/nntp.gif", PATH_IMAGENS, theiconset); break;
    case L_POPPASS:           xsnprintf (abuff, CMAXBUFFER, "%s/%s/changepassword.gif", PATH_IMAGENS, theiconset); break;
    case L_FILEBROWSER:       xsnprintf (abuff, CMAXBUFFER, "%s/%s/filebrowser.gif", PATH_IMAGENS, theiconset); break;    
    case L_FORWARDMAIL:       xsnprintf (abuff, CMAXBUFFER, "%s/%s/forwardmail.gif", PATH_IMAGENS, theiconset); break;        
    case L_FOLDER_COPY:       xsnprintf (abuff, CMAXBUFFER, "%s/%s/foldercopy.gif", PATH_IMAGENS, theiconset); break;
    case L_FOLDER_CUT:        xsnprintf (abuff, CMAXBUFFER, "%s/%s/foldercut.gif", PATH_IMAGENS, theiconset); break;    
    case L_FILE_COPY:         xsnprintf (abuff, CMAXBUFFER, "%s/%s/filecopy.gif", PATH_IMAGENS, theiconset); break;    
    case L_FILE_CUT:          xsnprintf (abuff, CMAXBUFFER, "%s/%s/filecut.gif", PATH_IMAGENS, theiconset); break;    
    case L_SECVIRTUAL:        xsnprintf (abuff, CMAXBUFFER, "%s/%s/office2.gif", PATH_IMAGENS, theiconset); break;    
    case L_UPSORT:            xsnprintf (abuff, CMAXBUFFER, "%s/%s/arrow_up.gif", PATH_IMAGENS, theiconset); break;        
    case L_DOWNSORT:          xsnprintf (abuff, CMAXBUFFER, "%s/%s/arrow_down.gif", PATH_IMAGENS, theiconset); break;            
    case L_DATABASES:         xsnprintf (abuff, CMAXBUFFER, "%s/%s/databases.gif", PATH_IMAGENS, theiconset); break;                
    case L_DISPLAY:           xsnprintf (abuff, CMAXBUFFER, "%s/%s/eye.gif", PATH_IMAGENS, theiconset); break;           
    case L_USERACCOUNTS:      xsnprintf (abuff, CMAXBUFFER, "%s/%s/useraccounts.gif", PATH_IMAGENS, theiconset); break;         
    case L_CONFIG:            xsnprintf (abuff, CMAXBUFFER, "%s/%s/config.gif", PATH_IMAGENS, theiconset); break;             
    case L_CONFIG_CCLIENT:    xsnprintf (abuff, CMAXBUFFER, "%s/%s/tool.gif", PATH_IMAGENS, theiconset); break;                 
    case L_CONFIG_NNTP:       xsnprintf (abuff, CMAXBUFFER, "%s/%s/tool.gif", PATH_IMAGENS, theiconset); break;                     
    case L_CONFIG_APPEARANCE: xsnprintf (abuff, CMAXBUFFER, "%s/%s/tool.gif", PATH_IMAGENS, theiconset); break;                 
    case L_SIEVE:             xsnprintf (abuff, CMAXBUFFER, "%s/%s/sieve.gif", PATH_IMAGENS, theiconset); break;                                 
    case L_CALENDAR:          xsnprintf (abuff, CMAXBUFFER, "%s/%s/calendar.gif", PATH_IMAGENS, theiconset); break;                                     
    case LANG_ENGLISH:        xsnprintf (abuff, CMAXBUFFER, "%s/%s/eng.gif", PATH_IMAGENS, theiconset); break;
    case LANG_SPANISH:        xsnprintf (abuff, CMAXBUFFER, "%s/%s/spa.gif", PATH_IMAGENS, theiconset); break;    
    case LANG_CATALA:         xsnprintf (abuff, CMAXBUFFER, "%s/%s/val.gif", PATH_IMAGENS, theiconset); break;    
    case LANG_EUSKERA:        xsnprintf (abuff, CMAXBUFFER, "%s/%s/unknown.gif", PATH_IMAGENS, theiconset); break;
    case L_DOTLEARN:          xsnprintf (abuff, CMAXBUFFER, "%s/%s/blackboard.gif", PATH_IMAGENS, theiconset); break;
    default:                  xsnprintf (abuff, CMAXBUFFER, "%s/%s/unknown.gif", PATH_IMAGENS, theiconset); break;
    }
  return abuff;          
  }
 
  
  
  
