/*
ClientLDAP.h
*/

#ifndef __CLIENTLDAP_H
#define __CLIENTLDAP_H

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>

#include <ldap.h>

#include "Language.h"
#include "Utils.h"
#include "Config.h"
#include "XSocket.h"
#include "XVector.h"

class ClientLDAP
  {
  private:
    IPNAME server;
    TBuffer user, password;
    int ldapport; 
    TBuffer ErrorString;
  public:
    ClientLDAP (const char *aserver, int aport, const char *auser,  const char *apassword);
    virtual ~ClientLDAP ();
    bool Authenticate ();
    const char *getErrorMsg (void);
    bool SearchServices (const char *base);
  };

#endif

